/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.config;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.CosyStartupAdapter;
import com.alibabacloud.intellij.qoder.core.lsp.model.AuthGrantInfoResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthGrantInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.qoder.search.asyn.Debouncer;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseConfigUI {
    private static final Logger LOGGER = Logger.getInstance(BaseConfigUI.class);
    protected static final Debouncer DEBOUNCER = new Debouncer();
    protected static final long FETCH_DELAY_MILLIS = 500L;

    public abstract void configTextField(Project var1, ConfigMainForm var2);

    public abstract void setLoginButtonState(ConfigMainForm var1);

    public abstract boolean checkText(ConfigMainForm var1);

    public abstract JComboBox<Object> getOrgIdComboBox(ConfigMainForm var1);

    public abstract GetGrantInfosParams getGrantInfosParams(ConfigMainForm var1);

    public abstract void configHelperLabel(ConfigMainForm var1);

    public abstract LoginParams getLoginParams(ConfigMainForm var1);

    public abstract void configLoginButton(Project var1, ConfigMainForm var2);

    public abstract void configLoginRadioButton(Project var1, ConfigMainForm var2);

    public void setup(Project project, ConfigMainForm configMainForm) {
        this.configTextField(project, configMainForm);
        this.getOrgIdComboBox(configMainForm).setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel com = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return com;
                }
                if (value instanceof AuthOrgItem) {
                    this.setText(((AuthOrgItem)value).getDisplay());
                    com.setToolTipText(((AuthOrgItem)value).getDisplay());
                } else {
                    this.setText(value.toString());
                    com.setToolTipText(value.toString());
                }
                return com;
            }
        });
        this.configHelperLabel(configMainForm);
        this.configLoginButton(project, configMainForm);
        this.configLoginRadioButton(project, configMainForm);
    }

    public String getOrganizationId(ConfigMainForm configMainForm) {
        JComboBox<Object> orgIdComboBox = this.getOrgIdComboBox(configMainForm);
        if (orgIdComboBox.getSelectedItem() == null || !(orgIdComboBox.getSelectedItem() instanceof AuthOrgItem)) {
            return null;
        }
        return ((AuthOrgItem)orgIdComboBox.getSelectedItem()).getKey();
    }

    protected void configTextField(JTextField textField, final Project project, final ConfigMainForm configMainForm, final JComboBox<Object> orgIdComboBox) {
        if (textField == null) {
            return;
        }
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (BaseConfigUI.this.needFetchOrganizations(configMainForm)) {
                    BaseConfigUI.this.fetchOrganizations(project, configMainForm);
                }
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BaseConfigUI.this.configOrgLogin(orgIdComboBox, configMainForm, project);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BaseConfigUI.this.configOrgLogin(orgIdComboBox, configMainForm, project);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BaseConfigUI.this.configOrgLogin(orgIdComboBox, configMainForm, project);
            }
        });
    }

    protected void configOrgLogin(JComboBox<Object> orgIdComboBox, ConfigMainForm configMainForm, Project project) {
        orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        this.setLoginButtonState(configMainForm);
        DEBOUNCER.debounce(() -> this.fetchOrganizations(project, configMainForm), 500L, TimeUnit.MILLISECONDS);
    }

    protected boolean needFetchOrganizations(ConfigMainForm configMainForm) {
        return true;
    }

    protected void fetchOrganizations(final Project project, final ConfigMainForm configMainForm) {
        JComboBox<Object> orgIdComboBox;
        if (this.checkText(configMainForm) && !this.checkComboBoxItem(orgIdComboBox = this.getOrgIdComboBox(configMainForm))) {
            orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{CosyBundle.message("settings.login.label.orgs.loading", new Object[0])}));
            orgIdComboBox.setSelectedIndex(0);
            ThreadUtil.execute(() -> {
                CosyStartupAdapter listener = new CosyStartupAdapter(){

                    @Override
                    public void onStartup() {
                        BaseConfigUI.this.updateOrgIds(project, configMainForm);
                    }
                };
                if (Cosy.INSTANCE.checkCosy(project, true, Collections.singletonList(listener))) {
                    this.updateOrgIds(project, configMainForm);
                }
            });
        }
    }

    private boolean checkComboBoxItem(JComboBox<Object> orgIdComboBox) {
        return orgIdComboBox.getModel() != null && orgIdComboBox.getSelectedItem() != null && orgIdComboBox.getSelectedItem() instanceof AuthOrgItem;
    }

    private void updateOrgIds(Project project, ConfigMainForm configMainForm) {
        GetGrantInfosParams getGrantInfosParams = this.getGrantInfosParams(configMainForm);
        if (this.checkText(configMainForm) && null != getGrantInfosParams) {
            AuthGrantInfoResult authGrantInfoResult = Cosy.INSTANCE.getLanguageService(project).getGrantInfoResult(getGrantInfosParams, 3000L);
            ArrayList<AuthOrgItem> orgIds = new ArrayList<AuthOrgItem>();
            JComboBox<Object> orgIdComboBox = this.getOrgIdComboBox(configMainForm);
            if (authGrantInfoResult != null) {
                List<AuthGrantInfo> authGrantInfos = authGrantInfoResult.getAccountInfo();
                if (CollectionUtils.isNotEmpty(authGrantInfos)) {
                    for (AuthGrantInfo info : authGrantInfos) {
                        AuthOrgItem org;
                        if ("personal".equals(info.getGrantType()) && this.filterPersonaType()) continue;
                        LOGGER.debug("get login grant info:" + info);
                        if ("personal".equals(info.getGrantType())) {
                            org = new AuthOrgItem(info.getUserId(), null, info.getUserName(), "personal");
                            orgIds.add(org);
                            continue;
                        }
                        if (!"organization".equals(info.getGrantType())) continue;
                        org = new AuthOrgItem(info.getUserId(), info.getOrgId(), info.getOrgName(), "org");
                        orgIds.add(org);
                    }
                } else if (authGrantInfoResult.getErrorCode() != null) {
                    this.notificationError(project, authGrantInfoResult.getErrorCode(), orgIdComboBox);
                    this.setLoginButtonState(configMainForm);
                    LOGGER.warn("get auth grant info error, errorMsg is " + authGrantInfoResult.getErrorMessage() + ",errorCode is " + authGrantInfoResult.getErrorCode());
                    return;
                }
            }
            SwingUtilities.invokeLater(() -> {
                orgIdComboBox.setModel(new DefaultComboBoxModel<AuthOrgItem>(orgIds.toArray(new AuthOrgItem[0])));
                if (!orgIds.isEmpty()) {
                    orgIdComboBox.setSelectedIndex(0);
                } else {
                    NotificationFactory.showToast((JComponent)orgIdComboBox, MessageType.ERROR, CosyBundle.messageVpc("notifications.auth.org.list.not.apply", new Object[0]));
                }
                this.setLoginButtonState(configMainForm);
            });
        }
    }

    private void notificationError(Project project, String errorCode, JComponent component) {
        if (project == null || StringUtils.isBlank((CharSequence)errorCode)) {
            return;
        }
        String errorMsg = null;
        switch (errorCode) {
            case "unknown_error": {
                errorMsg = CosyBundle.message("aksk.error.unknown", new Object[0]);
                break;
            }
            case "network_error": {
                errorMsg = CosyBundle.message("aksk.error.network.error", new Object[0]);
                break;
            }
            case "token_wrong_error": {
                errorMsg = CosyBundle.message("access.token.wrong", new Object[0]);
                break;
            }
            case "ak_sk_wrong_error": {
                errorMsg = CosyBundle.message("aksk.error.aksk.wrong", new Object[0]);
                break;
            }
            case "server_error": {
                errorMsg = CosyBundle.message("aksk.error.server.error", new Object[0]);
            }
        }
        if (StringUtils.isBlank(errorMsg)) {
            return;
        }
        String finalErrorMsg = errorMsg;
        SwingUtilities.invokeLater(() -> NotificationFactory.showToast(component, MessageType.ERROR, finalErrorMsg));
    }

    protected boolean filterPersonaType() {
        return false;
    }
}

