/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.config;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginDedicatedType;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RegionEnvEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.qoder.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.config.BaseConfigUI;
import com.alibabacloud.intellij.qoder.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyBrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Optional;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;

public class ConfigAccessKeyUI
extends BaseConfigUI {
    private static final Logger log = Logger.getInstance(ConfigAccessKeyUI.class);

    @Override
    public void configTextField(Project project, ConfigMainForm configMainForm) {
        this.configTextField(configMainForm.getAkTextField(), project, configMainForm, configMainForm.getOrgIdComboBox());
        this.configTextField(configMainForm.getSkTextField(), project, configMainForm, configMainForm.getOrgIdComboBox());
    }

    @Override
    public void setLoginButtonState(ConfigMainForm configMainForm) {
        configMainForm.getAkLogInButton().setEnabled(this.checkText(configMainForm) && configMainForm.getOrgIdComboBox().getSelectedItem() instanceof AuthOrgItem);
    }

    @Override
    public boolean checkText(ConfigMainForm configMainForm) {
        return StringUtils.isNotBlank((CharSequence)this.getLoginAccessKey(configMainForm)) && StringUtils.isNotBlank((CharSequence)this.getLoginSecretKey(configMainForm));
    }

    @Override
    public JComboBox<Object> getOrgIdComboBox(ConfigMainForm configMainForm) {
        return configMainForm.getOrgIdComboBox();
    }

    @Override
    public GetGrantInfosParams getGrantInfosParams(ConfigMainForm configMainForm) {
        return new GetGrantInfosParams(this.getLoginAccessKey(configMainForm), this.getLoginSecretKey(configMainForm), RegionEnvEnum.CN);
    }

    @Override
    public void configHelperLabel(ConfigMainForm configMainForm) {
        configMainForm.getGetAkLabel().setForeground(ColorUtil.getLinkForegroundColor());
        configMainForm.getGetAkLabel().setCursor(Cursor.getPredefinedCursor(12));
        configMainForm.getGetAkLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(QoderUrls.GET_ACCESS_KEY_URL);
            }
        });
    }

    @Override
    public LoginParams getLoginParams(ConfigMainForm configMainForm) {
        return LoginParams.fromAccessKey(this.getLoginAccessKey(configMainForm), this.getLoginSecretKey(configMainForm), this.getOrganizationId(configMainForm), RegionEnvEnum.CN, LoginDedicatedType.STANDARD);
    }

    @Override
    public void configLoginButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getAkLogInButton().addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    configMainForm.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.ACCESS_KEY.getLabel());
                } else {
                    log.warn("Setting is null when ak login button entered.");
                }
                configMainForm.getAkLogInButton().setEnabled(false);
                configMainForm.getLabelLoginState().setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = this.getLoginParams(configMainForm);
                UserAuthService.getInstance().login(project, configMainForm.getLabelLoginState(), loginParams);
            }
        });
    }

    @Override
    public void configLoginRadioButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getLoggedInByAKRadioButton().addActionListener(e -> {
            configMainForm.getAkConfigPanel().setVisible(true);
            configMainForm.getTokenConfigPanel().setVisible(false);
            configMainForm.getBtnLogin().setVisible(false);
            configMainForm.getAkLogInButton().setVisible(true);
            configMainForm.checkAndChangeEndpointWhenSelectAkLogin(project);
            configMainForm.getConfigAccessKeyUI().setLoginButtonState(configMainForm);
            configMainForm.getLoggedInByAKRadioButton().setSelected(true);
            configMainForm.getLoggedInByAccountRadioButton().setSelected(false);
            configMainForm.getLogInByAccessTokenRadioButton().setSelected(false);
            configMainForm.getDedicatedDomainRadioButton().setSelected(false);
            configMainForm.getAliyunIntlAccountRadioButton().setSelected(false);
        });
    }

    public String getLoginAccessKey(ConfigMainForm configMainForm) {
        return configMainForm.getAkTextField().getText();
    }

    public String getLoginSecretKey(ConfigMainForm configMainForm) {
        return Optional.ofNullable(configMainForm.getSkTextField().getPassword()).map(String::new).orElse(null);
    }
}

