/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.config;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginDedicatedType;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RegionEnvEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.qoder.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.config.BaseConfigUI;
import com.alibabacloud.intellij.qoder.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyBrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import org.apache.commons.lang3.StringUtils;

public class ConfigAccessTokenUI
extends BaseConfigUI {
    private static final Logger log = Logger.getInstance(ConfigAccessTokenUI.class);

    @Override
    public void configTextField(Project project, ConfigMainForm configMainForm) {
        this.configTextField(configMainForm.getAccessTokenTextField(), project, configMainForm, configMainForm.getOrgIdTokenComboBox());
    }

    @Override
    public void setLoginButtonState(ConfigMainForm configMainForm) {
        configMainForm.getTokenLogInButton().setEnabled(StringUtils.isNotBlank((CharSequence)this.getToken(configMainForm)) && this.getOrgIdComboBox(configMainForm).getSelectedItem() instanceof AuthOrgItem);
    }

    @Override
    public boolean checkText(ConfigMainForm configMainForm) {
        return StringUtils.isNotBlank((CharSequence)this.getToken(configMainForm));
    }

    @Override
    public JComboBox<Object> getOrgIdComboBox(ConfigMainForm configMainForm) {
        return configMainForm.getOrgIdTokenComboBox();
    }

    @Override
    public GetGrantInfosParams getGrantInfosParams(ConfigMainForm configMainForm) {
        return new GetGrantInfosParams(this.getToken(configMainForm), RegionEnvEnum.CN);
    }

    @Override
    public void configHelperLabel(ConfigMainForm configMainForm) {
        configMainForm.getGetAccessTokenLabel().setForeground(ColorUtil.getLinkForegroundColor());
        configMainForm.getGetAccessTokenLabel().setCursor(Cursor.getPredefinedCursor(12));
        configMainForm.getGetAccessTokenLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(QoderUrls.GET_ACCESS_TOKEN_URL);
            }
        });
    }

    @Override
    public LoginParams getLoginParams(ConfigMainForm configMainForm) {
        return LoginParams.fromPersonalToken(this.getToken(configMainForm), this.getOrganizationId(configMainForm), RegionEnvEnum.CN, LoginDedicatedType.STANDARD);
    }

    @Override
    public void configLoginButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getTokenLogInButton().addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    configMainForm.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.PERSONAL_TOKEN.getLabel());
                } else {
                    log.warn("Setting is null when token login button entered.");
                }
                configMainForm.getTokenLogInButton().setEnabled(false);
                configMainForm.getLabelLoginState().setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = this.getLoginParams(configMainForm);
                UserAuthService.getInstance().login(project, configMainForm.getLabelLoginState(), loginParams);
            }
        });
    }

    @Override
    public void configLoginRadioButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getLogInByAccessTokenRadioButton().addActionListener(e -> {
            configMainForm.getAkConfigPanel().setVisible(false);
            configMainForm.getTokenConfigPanel().setVisible(true);
            configMainForm.getBtnLogin().setVisible(false);
            configMainForm.getAkLogInButton().setVisible(false);
            configMainForm.getTokenLogInButton().setVisible(true);
            configMainForm.getConfigAccessTokenUI().setLoginButtonState(configMainForm);
            configMainForm.getLogInByAccessTokenRadioButton().setSelected(true);
            configMainForm.getLoggedInByAccountRadioButton().setSelected(false);
            configMainForm.getLoggedInByAKRadioButton().setSelected(false);
            configMainForm.getDedicatedDomainRadioButton().setSelected(false);
            configMainForm.getAliyunIntlAccountRadioButton().setSelected(false);
        });
    }

    private String getToken(ConfigMainForm configMainForm) {
        return configMainForm.getAccessTokenTextField().getText();
    }

    @Override
    protected boolean filterPersonaType() {
        return true;
    }
}

