/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.config;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.LoginDedicatedType;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RegionEnvEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.qoder.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.config.BaseConfigUI;
import com.alibabacloud.intellij.qoder.ui.config.ConfigMainForm;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyBrowserUtil;
import com.alibabacloud.intellij.qoder.util.QoderAgentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTextField;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class ConfigDedicatedAccessTokenUI
extends BaseConfigUI {
    private static final Logger log = Logger.getInstance(ConfigDedicatedAccessTokenUI.class);

    @Override
    public void configTextField(Project project, ConfigMainForm configMainForm) {
        this.configTextField(configMainForm.getDedicatedAccessTokenTextField(), project, configMainForm, configMainForm.getDedicatedOrgIdTokenComboBox());
        this.configDedicatedUrlField(configMainForm, project);
    }

    @Override
    public void setLoginButtonState(ConfigMainForm configMainForm) {
        configMainForm.getDedicatedLoginByTokenBtn().setEnabled(StringUtils.isNotBlank((CharSequence)configMainForm.getDedicatedUrlField().getText()) && StringUtils.isNotBlank((CharSequence)this.getToken(configMainForm)) && this.getOrgIdComboBox(configMainForm).getSelectedItem() instanceof AuthOrgItem);
    }

    @Override
    public boolean checkText(ConfigMainForm configMainForm) {
        return StringUtils.isNotBlank((CharSequence)this.getToken(configMainForm));
    }

    @Override
    public JComboBox<Object> getOrgIdComboBox(ConfigMainForm configMainForm) {
        return configMainForm.getDedicatedOrgIdTokenComboBox();
    }

    @Override
    public GetGrantInfosParams getGrantInfosParams(ConfigMainForm configMainForm) {
        return new GetGrantInfosParams(this.getToken(configMainForm), RegionEnvEnum.UNKNOWN);
    }

    @Override
    public void configHelperLabel(ConfigMainForm configMainForm) {
        configMainForm.getDedicatedGetAccessTokenLabel().setForeground(ColorUtil.getLinkForegroundColor());
        configMainForm.getDedicatedGetAccessTokenLabel().setCursor(Cursor.getPredefinedCursor(12));
        configMainForm.getDedicatedGetAccessTokenLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(QoderUrls.GET_ACCESS_TOKEN_URL);
            }
        });
    }

    @Override
    public LoginParams getLoginParams(ConfigMainForm configMainForm) {
        return LoginParams.fromPersonalToken(this.getToken(configMainForm), this.getOrganizationId(configMainForm), RegionEnvEnum.UNKNOWN, LoginDedicatedType.DEDICATED);
    }

    @Override
    public void configLoginButton(Project project, ConfigMainForm configMainForm) {
        this.configDedicatedLogInByAccountBtn(project, configMainForm);
        this.configDedicatedLogInByTokenBtn(project, configMainForm);
    }

    @Override
    public void configLoginRadioButton(Project project, ConfigMainForm configMainForm) {
        configMainForm.getDedicatedLoginByTokenRadioBtn().addActionListener(e -> {
            configMainForm.getDedicatedDomainRadioButton().setSelected(true);
            configMainForm.getDedicatedLoginByAccountRadioBtn().setSelected(false);
            configMainForm.getDedicatedTokenConfigPanel().setVisible(true);
            configMainForm.getDedicatedLoginByAccountBtn().setVisible(false);
        });
    }

    @Override
    protected void fetchOrganizations(Project project, ConfigMainForm configMainForm) {
        this.checkDedicatedSetting(project, configMainForm, configMainForm.getDedicatedUrlField(true));
        super.fetchOrganizations(project, configMainForm);
    }

    private String getToken(ConfigMainForm configMainForm) {
        return configMainForm.getDedicatedAccessTokenTextField().getText();
    }

    private void configDedicatedUrlField(final ConfigMainForm configMainForm, final Project project) {
        final JBTextField dedicatedUrlField = configMainForm.getDedicatedUrlField();
        dedicatedUrlField.getEmptyText().setText(CosyBundle.message("settings.login.dedicated.url", new Object[0]));
        dedicatedUrlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (configMainForm.getDedicatedDomainRadioButton().isSelected()) {
                    if (configMainForm.getDedicatedLoginByAccountRadioBtn().isSelected()) {
                        configMainForm.getDedicatedLoginByAccountBtn().setVisible(true);
                    }
                    if (configMainForm.getDedicatedLoginByTokenRadioBtn().isSelected()) {
                        ConfigDedicatedAccessTokenUI.this.configOrgLogin(ConfigDedicatedAccessTokenUI.this.getOrgIdComboBox(configMainForm), configMainForm, project);
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigDedicatedAccessTokenUI.this.setLoginButtonState(configMainForm);
                configMainForm.getDedicatedLoginByAccountBtn().setVisible(StringUtils.isNotBlank((CharSequence)dedicatedUrlField.getText()) && configMainForm.getDedicatedLoginByAccountRadioBtn().isSelected());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (configMainForm.getDedicatedDomainRadioButton().isSelected() && configMainForm.getDedicatedLoginByAccountRadioBtn().isSelected()) {
                    configMainForm.getDedicatedLoginByAccountBtn().setVisible(StringUtils.isNotBlank((CharSequence)dedicatedUrlField.getText()));
                }
            }
        });
    }

    private void configDedicatedLogInByAccountBtn(Project project, ConfigMainForm configMainForm) {
        configMainForm.getDedicatedLoginByAccountBtn().addActionListener(e -> {
            configMainForm.getLabelLoginState().setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
            String dedicatedDomainUrl = configMainForm.getDedicatedUrlField(true);
            if (StringUtils.isNotBlank((CharSequence)dedicatedDomainUrl)) {
                this.checkDedicatedSetting(project, configMainForm, dedicatedDomainUrl);
                if (project != null) {
                    UserAuthService.getInstance().login(project, configMainForm.getLabelLoginState(), LoginParams.fromDedicatedDomain());
                }
            }
        });
    }

    private void checkDedicatedSetting(Project project, ConfigMainForm configMainForm, String dedicatedDomainUrl) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            boolean differentEndpointUrl;
            GlobalEndpointConfig endpointConfig = QoderAgentUtil.getGlobalEndpointConfigDirectly(project);
            boolean bl = differentEndpointUrl = endpointConfig != null && endpointConfig.getEndpoint() != null && !endpointConfig.getEndpoint().equals(dedicatedDomainUrl);
            if (differentEndpointUrl) {
                log.info("Log in by dedicated login button. Detected dedicated domain url changed, update lingma endpoint config.");
                configMainForm.updateLingmaEndpointConfig(project);
            } else {
                log.info("Log in by dedicated login button. Don't need update endpoint, directly login.");
            }
            setting.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
            setting.setDedicatedDomainUrl(dedicatedDomainUrl);
        }
    }

    private void configDedicatedLogInByTokenBtn(Project project, ConfigMainForm configMainForm) {
        configMainForm.getDedicatedLoginByTokenBtn().addActionListener(e -> {
            if (project != null) {
                this.checkDedicatedSetting(project, configMainForm, configMainForm.getDedicatedUrlField(true));
                configMainForm.getLabelLoginState().setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = this.getLoginParams(configMainForm);
                UserAuthService.getInstance().login(project, configMainForm.getLabelLoginState(), loginParams);
            }
        });
    }

    @Override
    protected boolean filterPersonaType() {
        return true;
    }

    @Override
    protected void configOrgLogin(JComboBox<Object> orgIdComboBox, ConfigMainForm configMainForm, Project project) {
        if (this.needFetchOrganizations(configMainForm)) {
            super.configOrgLogin(orgIdComboBox, configMainForm, project);
        }
    }

    @Override
    protected boolean needFetchOrganizations(ConfigMainForm configMainForm) {
        return StringUtils.isNotBlank((CharSequence)configMainForm.getDedicatedUrlField().getText()) && StringUtils.isNotBlank((CharSequence)this.getToken(configMainForm));
    }
}

