/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.config;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="QoderSettings", storages={@Storage(value="qoder_setting.xml")})
public class CosyPersistentSetting
implements PersistentStateComponent<CosySetting> {
    private static Logger log = Logger.getInstance(CosyPersistentSetting.class);
    private static CosyPersistentSetting fallbackSetting = new CosyPersistentSetting();
    CosySetting setting;

    public static CosyPersistentSetting getInstance() {
        try {
            CosyPersistentSetting state = (CosyPersistentSetting)ServiceManager.getService(CosyPersistentSetting.class);
            if (state == null || state.getState() == null) {
                log.info("use fallbackSetting");
                return fallbackSetting;
            }
            return state;
        }
        catch (Throwable t) {
            log.warn("Fail to get Cosy persistent setting", t);
            return fallbackSetting;
        }
    }

    @Nullable
    public CosySetting getState() {
        if (this.setting != null && this.setting.getParameter() == null) {
            this.setting.setParameter(CosySetting.DEFAULT_PARAMS);
        }
        return this.setting;
    }

    public void loadState(@NotNull CosySetting cosySetting) {
        if (cosySetting == null) {
            CosyPersistentSetting.$$$reportNull$$$0(0);
        }
        this.setting = cosySetting;
    }

    public void noStateLoaded() {
        this.setting = new CosySetting();
    }

    public boolean isEnableCloudCompletion(CosySetting settings, CompletionTriggerModeEnum triggerMode) {
        if (settings != null) {
            if (settings.getParameter().getCloud().getEnable().booleanValue()) {
                ChangeUserSettingParams.CloudModelAutoTrigger autoTrigger = settings.getParameter().getCloud().getAutoTrigger();
                if (triggerMode != null && CompletionTriggerModeEnum.AUTO.getName().equals(triggerMode.getName()) && (autoTrigger == null || autoTrigger.getEnable() == null || !autoTrigger.getEnable().booleanValue())) {
                    log.warn("ignore invoke cloud completion request, auto trigger is disabled");
                    return false;
                }
            } else {
                log.warn("ignore invoke cloud completion request, cloud model is disabled");
                return false;
            }
        }
        return true;
    }

    static {
        CosyPersistentSetting.fallbackSetting.setting = new CosySetting();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cosySetting", "com/alibabacloud/intellij/qoder/ui/config/CosyPersistentSetting", "loadState"));
    }
}

