/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.ineditordiff;

import com.alibabacloud.intellij.qoder.service.handler.ChatAskApplyDiffHandler;
import com.alibabacloud.intellij.qoder.ui.chat.inline.InlineChatPanel;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.DiffAlgorithmResult;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InlineDiffSingleChangeComponent;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InlineDiffsActionTab;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.JGitDiffAlgorithmAdapter;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.LinesSequence;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.OffsetRange;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.SequenceDiff;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InEditorDiffRenderer
implements Disposable,
InlineDiffSingleChangeComponent.InlineDiffChangeCallback {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @Nullable
    private final FileType fileType;
    @NotNull
    private final Document initialDocument;
    private final int startLine;
    private final String selectedText;
    @NotNull
    private final String requestId;
    @NotNull
    private final String sessionId;
    private final InlineChatPanel inlineChatPanel;
    private final List<InlineDiffSingleChangeComponent> diffComponents;
    private MouseAdapter mouseAdapter;
    private VisibleAreaListener visibleAreaListener;
    private InlineDiffsActionTab inlineDiffsActionTab;
    private DocumentListener documentListener;
    private static final Logger log = Logger.getInstance(InEditorDiffRenderer.class);
    public static Key<InEditorDiffRenderer> INLINE_DIFF_RENDERER_KEY = Key.create((String)"INLINE_DIFF_RENDERER_KEY");

    public InEditorDiffRenderer(final @NotNull Editor editor, @NotNull Project project, @Nullable FileType fileType, @NotNull Document initialDocument, int startLine, String selectedText, @NotNull String requestId, @NotNull String sessionId, InlineChatPanel inlineChatPanel) {
        if (editor == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(1);
        }
        if (initialDocument == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(2);
        }
        if (requestId == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(3);
        }
        if (sessionId == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(4);
        }
        this.diffComponents = new CopyOnWriteArrayList<InlineDiffSingleChangeComponent>();
        this.mouseAdapter = null;
        this.visibleAreaListener = null;
        this.editor = editor;
        this.project = project;
        this.fileType = fileType;
        this.initialDocument = initialDocument;
        this.startLine = startLine;
        this.selectedText = selectedText;
        this.requestId = requestId;
        this.sessionId = sessionId;
        this.inlineChatPanel = inlineChatPanel;
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point mousePosition = e.getPoint();
                InEditorDiffRenderer.showDiffBlockWhenMouseMove(mousePosition, InEditorDiffRenderer.this.diffComponents, editor);
            }
        };
        this.visibleAreaListener = visibleAreaEvent -> {
            for (InlineDiffSingleChangeComponent component : this.diffComponents) {
                if (!component.isShowActionPanel()) continue;
                component.showActionPanel();
            }
        };
        editor.putUserData(INLINE_DIFF_RENDERER_KEY, (Object)this);
    }

    public static void showDiffBlockWhenMouseMove(Point mousePosition, List<InlineDiffSingleChangeComponent> diffComponents, Editor editor) {
        InlineDiffSingleChangeComponent target = null;
        InlineDiffSingleChangeComponent lastDiffBlock = null;
        int i = 0;
        for (InlineDiffSingleChangeComponent component : diffComponents) {
            int lastDiffBlockBottom = lastDiffBlock == null ? 0 : lastDiffBlock.getTargetBounds().y;
            int nextDiffBlockTop = editor.getComponent().getPreferredSize().height;
            if (i < diffComponents.size() - 1) {
                nextDiffBlockTop = diffComponents.get((int)(i + 1)).getTargetBounds().y;
            }
            if (component.isPositionIn(lastDiffBlockBottom, nextDiffBlockTop, mousePosition)) {
                target = component;
                break;
            }
            lastDiffBlock = component;
            ++i;
        }
        if (target != null) {
            target.showActionPanel();
            for (InlineDiffSingleChangeComponent component : diffComponents) {
                if (component == target) continue;
                component.hideActionPanel();
            }
        }
    }

    @Override
    public void onAccept(InlineDiffSingleChangeComponent component) {
        this.diffComponents.remove(component);
        if (this.diffComponents.isEmpty()) {
            if (this.inlineDiffsActionTab != null) {
                this.inlineDiffsActionTab.dispose();
            }
            this.editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
            if (this.inlineChatPanel != null) {
                this.inlineChatPanel.onAcceptAllChanges();
            }
            this.removeChatAskApplyDiffCache();
        }
    }

    @Override
    public void onReject(InlineDiffSingleChangeComponent component) {
        this.diffComponents.remove(component);
        if (this.diffComponents.isEmpty()) {
            if (this.inlineDiffsActionTab != null) {
                this.inlineDiffsActionTab.dispose();
            }
            this.editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
            if (this.inlineChatPanel != null) {
                this.inlineChatPanel.onRejectAllChanges();
            }
            this.removeChatAskApplyDiffCache();
        }
    }

    public void render(String newText, Boolean needButton) {
        this.clear();
        ReadAction.run(() -> this.editor.getSelectionModel().removeSelection());
        this.doRender(newText);
        if (needButton.booleanValue()) {
            for (InlineDiffSingleChangeComponent component : this.diffComponents) {
                component.ready(this.diffComponents);
            }
            this.showFirstDiffActionPanel();
            this.editor.getContentComponent().addMouseMotionListener(this.mouseAdapter);
            this.editor.getScrollingModel().addVisibleAreaListener(this.visibleAreaListener);
        }
    }

    public void renderInlineDiffs(String newText) {
        this.render(newText, true);
        this.documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                InEditorDiffRenderer.this.handleDocumentChange(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/qoder/ui/ineditordiff/InEditorDiffRenderer$2", "documentChanged"));
            }
        };
        this.editor.getDocument().addDocumentListener(this.documentListener);
        if (!this.diffComponents.isEmpty()) {
            if (this.diffComponents.get(0).getChange() != null) {
                int startLine = this.diffComponents.get(0).getChange().getStartLine1();
                LogicalPosition logicalPosition = new LogicalPosition(startLine, 0);
                this.editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
            }
            this.inlineDiffsActionTab = new InlineDiffsActionTab(this.editor, this);
        }
    }

    private void handleDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(5);
        }
        Document document = event.getDocument();
        int offset = event.getOffset();
        int changeLine = document.getLineNumber(offset);
        int addedLines = this.countLines(event.getNewFragment()) - this.countLines(event.getOldFragment());
        log.info("handleDocumentChange: changeLine=" + changeLine + ", addedLines=" + addedLines);
        this.adjustChangeLine(changeLine, addedLines);
    }

    private int countLines(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private void showFirstDiffActionPanel() {
        int i = 0;
        for (InlineDiffSingleChangeComponent component : this.diffComponents) {
            if (i == 0) {
                component.showActionPanel();
            } else {
                component.hideActionPanel();
            }
            ++i;
        }
    }

    private void doRender(String newText) {
        ArrayList changes;
        if (newText != null) {
            changes = this.comparePrefixDiff(this.selectedText, newText);
            changes = this.adjustLineFragments(changes, this.startLine);
        } else {
            List diffChanges = ComparisonManager.getInstance().compareLinesInner((CharSequence)this.editor.getDocument().getText(), (CharSequence)this.initialDocument.getText(), ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            ArrayList inlineDiffLineFragments = Lists.newArrayList();
            for (LineFragment change : diffChanges) {
                InlineDiffLineFragment inlineDiffLineFragment = new InlineDiffLineFragment(change);
                inlineDiffLineFragments.add(inlineDiffLineFragment);
            }
            changes = inlineDiffLineFragments;
        }
        int totalChangeCounts = CollectionUtils.size(changes);
        String source = "inline_edit";
        if (this.inlineChatPanel == null) {
            source = "chat_ask_apply";
        }
        for (int i = 0; i < changes.size(); ++i) {
            InlineDiffLineFragment lineFragment = (InlineDiffLineFragment)changes.get(i);
            InlineDiffSingleChangeComponent changeComponent = new InlineDiffSingleChangeComponent(this.editor, this.project, this.requestId, this.sessionId, newText, lineFragment, totalChangeCounts, i + 1, this.fileType, this, source);
            this.diffComponents.add(changeComponent);
        }
    }

    public List<InlineDiffLineFragment> comparePrefixDiff(String text1, String text2) {
        LinesSequence seq1 = new LinesSequence(text1.split("\n"));
        LinesSequence seq2 = new LinesSequence(text2.split("\n"));
        JGitDiffAlgorithmAdapter jGitDiffAlgorithmAdapter = new JGitDiffAlgorithmAdapter();
        DiffAlgorithmResult result = jGitDiffAlgorithmAdapter.compute(seq1, seq2);
        ArrayList<InlineDiffLineFragment> fragments = new ArrayList<InlineDiffLineFragment>();
        for (SequenceDiff diff : result.getDiffs()) {
            OffsetRange range1 = diff.getRange1();
            OffsetRange range2 = diff.getRange2();
            InlineDiffLineFragment fragment = new InlineDiffLineFragment(range1.getStart(), range1.getEnd(), range2.getStart(), range2.getEnd(), List.of(), 0, 0, 0, 0);
            fragments.add(fragment);
        }
        return fragments;
    }

    public void clear() {
        try {
            if (this.mouseAdapter != null) {
                this.editor.getContentComponent().removeMouseMotionListener(this.mouseAdapter);
            }
            if (this.documentListener != null) {
                this.editor.getDocument().removeDocumentListener(this.documentListener);
                this.documentListener = null;
            }
        }
        catch (Exception e) {
            log.warn("clear inline diff error", (Throwable)e);
        }
        for (InlineDiffSingleChangeComponent singleChangeComponent : this.diffComponents) {
            singleChangeComponent.dispose();
        }
        this.diffComponents.clear();
    }

    public void dispose() {
        if (this.inlineDiffsActionTab != null) {
            this.inlineDiffsActionTab.dispose();
        }
        this.clear();
    }

    public boolean isDisposed() {
        return CollectionUtils.isEmpty(this.diffComponents);
    }

    @NotNull
    public static InEditorDiffRenderer create(@NotNull Editor editor, @NotNull Project project, @Nullable FileType fileType, int startLine, String selectedText, String requestId, String sessionId, InlineChatPanel inlineChatPanel) {
        if (editor == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(6);
        }
        if (project == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        LightVirtualFile vfile = new LightVirtualFile("initial-" + virtualFile.getName(), fileType, (CharSequence)editor.getDocument().getText());
        Document initialDocument = (Document)ApplicationManager.getApplication().runReadAction(() -> InEditorDiffRenderer.lambda$create$2((VirtualFile)vfile));
        if (initialDocument == null) {
            throw new IllegalStateException("Cannot create in memory document for comparison");
        }
        initialDocument.setReadOnly(true);
        return new InEditorDiffRenderer(editor, project, fileType, initialDocument, startLine, selectedText, requestId, sessionId, inlineChatPanel);
    }

    private List<InlineDiffLineFragment> adjustLineFragments(List<InlineDiffLineFragment> fragments, int startLine) {
        ArrayList<InlineDiffLineFragment> result = new ArrayList<InlineDiffLineFragment>();
        for (InlineDiffLineFragment fragment : fragments) {
            fragment.setStartLine1(fragment.getStartLine1() + startLine);
            fragment.setEndLine1(fragment.getEndLine1() + startLine);
            result.add(fragment);
        }
        return result;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.editor;
        if (editor == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(8);
        }
        return editor;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            InEditorDiffRenderer.$$$reportNull$$$0(9);
        }
        return project;
    }

    public void adjustChangeLine(int changeLine, int diffLines) {
        if (CollectionUtils.isNotEmpty(this.diffComponents)) {
            for (InlineDiffSingleChangeComponent change : this.diffComponents) {
                int startLine1 = change.getChange().getStartLine1();
                int endLine1 = change.getChange().getEndLine1();
                if (changeLine < startLine1) {
                    int newStartLine1 = startLine1 + diffLines;
                    int newEndLine1 = endLine1 + diffLines;
                    change.getChange().setStartLine1(newStartLine1);
                    change.getChange().setEndLine1(newEndLine1);
                    continue;
                }
                if (changeLine > endLine1) continue;
                int newEndLine1 = endLine1 + diffLines;
                change.getChange().setEndLine1(newEndLine1);
            }
        }
    }

    public void acceptAll() {
        for (int i = this.diffComponents.size() - 1; i >= 0; --i) {
            InlineDiffSingleChangeComponent change = this.diffComponents.get(i);
            change.accept(false);
        }
        this.diffComponents.clear();
        this.removeChatAskApplyDiffCache();
    }

    public void rejectAll() {
        for (InlineDiffSingleChangeComponent change : this.diffComponents) {
            change.reject(false);
        }
        this.diffComponents.clear();
        this.clear();
        this.removeChatAskApplyDiffCache();
    }

    public boolean hasChanges() {
        return CollectionUtils.isNotEmpty(this.diffComponents);
    }

    public void acceptCurrentShowDiff() {
        if (CollectionUtils.isNotEmpty(this.diffComponents)) {
            for (InlineDiffSingleChangeComponent change : this.diffComponents) {
                if (!change.isShowActionPanel()) continue;
                change.accept(true);
                this.showFirstDiffActionPanel();
                break;
            }
        }
    }

    public void rejectCurrentShowDiff() {
        if (CollectionUtils.isNotEmpty(this.diffComponents)) {
            for (InlineDiffSingleChangeComponent change : this.diffComponents) {
                if (!change.isShowActionPanel()) continue;
                change.reject(true);
                this.showFirstDiffActionPanel();
                break;
            }
        }
    }

    private void removeChatAskApplyDiffCache() {
        VirtualFile file;
        if (this.inlineDiffsActionTab != null && (file = FileDocumentManager.getInstance().getFile(this.editor.getDocument())) != null) {
            ChatAskApplyDiffHandler.removeFilePathFromCache(this.project, file.getPath());
        }
    }

    private static /* synthetic */ Document lambda$create$2(VirtualFile vfile) {
        return FileDocumentManager.getInstance().getDocument(vfile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDocument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/ui/ineditordiff/InEditorDiffRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/ineditordiff/InEditorDiffRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleDocumentChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InlineDiffLineFragment
    implements LineFragment {
        private int startLine1;
        private int endLine1;
        private int startLine2;
        private int endLine2;
        private List<DiffFragment> innerFragments;
        private int startOffset1;
        private int endOffset1;
        private int startOffset2;
        private int endOffset2;

        public InlineDiffLineFragment(LineFragment lineFragment) {
            this.startLine1 = lineFragment.getStartLine1();
            this.endLine1 = lineFragment.getEndLine1();
            this.startLine2 = lineFragment.getStartLine2();
            this.endLine2 = lineFragment.getEndLine2();
            this.innerFragments = lineFragment.getInnerFragments();
            this.startOffset1 = lineFragment.getStartOffset1();
            this.endOffset1 = lineFragment.getEndOffset1();
            this.startOffset2 = lineFragment.getStartOffset2();
            this.endOffset2 = lineFragment.getEndOffset2();
        }

        public InlineDiffLineFragment(int startLine1, int endLine1, int startLine2, int endLine2, List<DiffFragment> innerFragments, int startOffset1, int endOffset1, int startOffset2, int endOffset2) {
            this.startLine1 = startLine1;
            this.endLine1 = endLine1;
            this.startLine2 = startLine2;
            this.endLine2 = endLine2;
            this.innerFragments = innerFragments;
            this.startOffset1 = startOffset1;
            this.endOffset1 = endOffset1;
            this.startOffset2 = startOffset2;
            this.endOffset2 = endOffset2;
        }

        public int getStartLine1() {
            return this.startLine1;
        }

        public int getEndLine1() {
            return this.endLine1;
        }

        public int getStartLine2() {
            return this.startLine2;
        }

        public int getEndLine2() {
            return this.endLine2;
        }

        @Nullable
        public List<DiffFragment> getInnerFragments() {
            return this.innerFragments;
        }

        public int getStartOffset1() {
            return this.startOffset1;
        }

        public int getEndOffset1() {
            return this.endOffset1;
        }

        public int getStartOffset2() {
            return this.startOffset2;
        }

        public int getEndOffset2() {
            return this.endOffset2;
        }

        public void setStartLine1(int startLine1) {
            this.startLine1 = startLine1;
        }

        public void setEndLine1(int endLine1) {
            this.endLine1 = endLine1;
        }

        public void setStartLine2(int startLine2) {
            this.startLine2 = startLine2;
        }

        public void setEndLine2(int endLine2) {
            this.endLine2 = endLine2;
        }

        public void setInnerFragments(List<DiffFragment> innerFragments) {
            this.innerFragments = innerFragments;
        }

        public void setStartOffset1(int startOffset1) {
            this.startOffset1 = startOffset1;
        }

        public void setEndOffset1(int endOffset1) {
            this.endOffset1 = endOffset1;
        }

        public void setStartOffset2(int startOffset2) {
            this.startOffset2 = startOffset2;
        }

        public void setEndOffset2(int endOffset2) {
            this.endOffset2 = endOffset2;
        }
    }
}

