/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.ineditordiff;

import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.enums.TextChangeTypeEnum;
import com.alibabacloud.intellij.qoder.service.model.BaseTextChangeSourceMetric;
import com.alibabacloud.intellij.qoder.service.model.TextChangeContext;
import com.alibabacloud.intellij.qoder.ui.diff.ComponentInlayAlignment;
import com.alibabacloud.intellij.qoder.ui.diff.ComponentInlayRenderer;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.BackgroundType;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.ComponentInlayKt;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.DiffTextAttributes;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InEditorDiffRenderer;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InlayProperties;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InlineDiffActionPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.DiffOperationNotifier;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Pair;
import kotlin.TuplesKt;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InlineDiffSingleChangeComponent
implements Disposable {
    private final InEditorDiffRenderer.InlineDiffLineFragment change;
    private int totalChangeCounts;
    private int currentChangeIndex;
    private final String requestId;
    private final String sessionId;
    private final Editor editor;
    private final Project project;
    private final String newText;
    private final FileType fileType;
    private InlineDiffActionPanel actionButtonPanel;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean init = new AtomicBoolean(false);
    private MouseAdapter panelMouseListener;
    private final InlineDiffChangeCallback changeCallback;
    private List<RangeHighlighter> highlighters;
    private Inlay<ComponentInlayRenderer> inlay;
    private static final Logger log = Logger.getInstance(InlineDiffSingleChangeComponent.class);
    private Long addedLines;
    private Long addedChars;
    private Long deletedLines;
    private String source;

    public InlineDiffSingleChangeComponent(Editor editor, Project project, String requestId, String sessionId, String newText, InEditorDiffRenderer.InlineDiffLineFragment change, int totalChangeCounts, int currentChangeIndex, FileType fileType, InlineDiffChangeCallback changeCallback, String source) {
        this.change = change;
        this.editor = editor;
        this.requestId = requestId;
        this.sessionId = sessionId;
        this.project = project;
        this.newText = newText;
        this.totalChangeCounts = totalChangeCounts;
        this.currentChangeIndex = currentChangeIndex;
        this.fileType = fileType;
        this.changeCallback = changeCallback;
        this.source = source;
        this.initRender();
        this.initLinesCnt();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        messageBusConnection.subscribe(DiffOperationNotifier.DIFF_OPERATION_NOTIFICATION, this::operate);
    }

    private void operate(InlineDiffSingleChangeComponent component) {
        if (component != this && this.requestId.equals(component.requestId) && StringUtils.equals((CharSequence)EditorUtil.getEditorFilePath(this.editor), (CharSequence)EditorUtil.getEditorFilePath(component.editor))) {
            if (component.getCurrentChangeIndex() < this.currentChangeIndex) {
                --this.currentChangeIndex;
            }
            --this.totalChangeCounts;
            if (null != this.actionButtonPanel && null != this.actionButtonPanel.getNumberLabel()) {
                this.actionButtonPanel.getNumberLabel().setText(this.currentChangeIndex + " / " + this.totalChangeCounts);
                this.actionButtonPanel.revalidate();
                this.actionButtonPanel.repaint();
            }
        }
    }

    private void initRender() {
        if (this.init.get()) {
            return;
        }
        if (this.disposed.get()) {
            return;
        }
        if (this.init.compareAndSet(false, true)) {
            int deletedRangeLength = this.change.getEndLine1() - this.change.getStartLine1();
            int insertedRangeLength = this.change.getEndLine2() - this.change.getStartLine2();
            if (deletedRangeLength > 0 && insertedRangeLength > 0) {
                this.renderModifiedCodeRangeUsingInsertStyle(this.change, this.newText);
            } else if (insertedRangeLength > 0) {
                this.inlay = this.renderInsertCodeInlay(this.change, this.newText);
            } else if (deletedRangeLength > 0) {
                this.highlighters = this.renderDeletedCodeRange(this.change);
            } else {
                log.warn("Unexpected change, both deleted and inserted ranges are empty");
            }
            if (this.inlay != null) {
                this.inlay.update();
            }
            String text = this.currentChangeIndex + " / " + this.totalChangeCounts;
            this.actionButtonPanel = new InlineDiffActionPanel(8, text, this, this.editor);
            this.editor.getContentComponent().add((Component)this.actionButtonPanel, 0);
        }
    }

    private void initLinesCnt() {
        this.addedLines = this.change.getEndLine2() - this.change.getStartLine2();
        if (this.addedLines < 0L) {
            this.addedLines = 0L;
        }
        this.deletedLines = this.change.getEndLine1() - this.change.getStartLine1();
    }

    public void ready(final List<InlineDiffSingleChangeComponent> allDiffComponents) {
        if (this.inlay != null) {
            ((Component)((ComponentInlayRenderer)this.inlay.getRenderer()).getComponent()).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Rectangle targetBounds = InlineDiffSingleChangeComponent.this.getTargetBounds();
                    Point mousePosition = new Point(e.getPoint().x, e.getPoint().y + targetBounds.y);
                    InEditorDiffRenderer.showDiffBlockWhenMouseMove(mousePosition, allDiffComponents, InlineDiffSingleChangeComponent.this.editor);
                }
            });
        }
    }

    private void renderModifiedCodeRangeUsingInsertStyle(LineFragment change, String newText) {
        List<RangeHighlighter> highlighters = this.renderDeletedCodeRange(change);
        Inlay renderInsertCodeInlay = this.renderInsertCodeInlay(change, newText);
        this.highlighters = highlighters;
        this.inlay = renderInsertCodeInlay;
    }

    private List<RangeHighlighter> renderDeletedCodeRange(LineFragment change) {
        DiffDrawUtil.LineHighlighterBuilder lineHighlighterBuilder = new DiffDrawUtil.LineHighlighterBuilder(this.editor, change.getStartLine1(), change.getEndLine1(), TextDiffType.DELETED).withHideWithoutLineNumbers(true).withExcludedInGutter(true).withHideStripeMarkers(true);
        return lineHighlighterBuilder.done();
    }

    private Inlay renderInsertCodeInlay(LineFragment change, String newText) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document newDocument = editorFactory.createDocument((CharSequence)newText);
        String insertedText = DiffUtil.getLinesContent((Document)newDocument, (int)change.getStartLine2(), (int)change.getEndLine2()).toString();
        EditorTextField textField = new EditorTextField(insertedText, this.project, this.fileType);
        textField.setOneLineMode(false);
        textField.addSettingsProvider(innerEditor -> {
            innerEditor.setViewer(true);
            DiffTextAttributes attributes = new DiffTextAttributes(BackgroundType.DEFAULT, TextDiffType.INSERTED, (Editor)innerEditor);
            innerEditor.setBackgroundColor(attributes.getBackgroundColor());
            innerEditor.getColorsScheme().setFontPreferences(this.editor.getColorsScheme().getFontPreferences());
            innerEditor.getSettings().setLineCursorWidth(this.editor.getSettings().getLineCursorWidth());
            InEditorDiffRenderer renderer = (InEditorDiffRenderer)this.editor.getUserData(InEditorDiffRenderer.INLINE_DIFF_RENDERER_KEY);
            if (renderer != null) {
                innerEditor.putUserData(InEditorDiffRenderer.INLINE_DIFF_RENDERER_KEY, (Object)renderer);
            }
        });
        textField.setFontInheritedFromLAF(false);
        int inlayLine = change.getStartLine1();
        Pair inlayLineAndAbove = change.getEndLine1() != this.editor.getDocument().getLineCount() ? TuplesKt.to((Object)inlayLine, (Object)true) : (change.getStartLine1() != 0 ? TuplesKt.to((Object)(inlayLine - 1), (Object)false) : TuplesKt.to((Object)0, (Object)false));
        inlayLine = ((Number)inlayLineAndAbove.component1()).intValue();
        int inlayLineStartOffset = this.editor.getDocument().getLineStartOffset(inlayLine);
        boolean isAbove = (Boolean)inlayLineAndAbove.component2();
        InlayProperties inlayProperties = new InlayProperties().showAbove(isAbove);
        inlayProperties.priority(10);
        ComponentInlayRenderer<EditorTextField> insertCodeInlayRenderer = new ComponentInlayRenderer<EditorTextField>(textField, ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH);
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        int inlayHeight = Math.max(this.editor.getLineHeight() * (change.getEndLine2() - change.getStartLine2()), 0);
        insertCodeInlayRenderer.setInlaySize$cosy_intellij(new Dimension(visibleArea.width, inlayHeight));
        Inlay<ComponentInlayRenderer<EditorTextField>> rendererInlay = ComponentInlayKt.addComponentInlay(this.editor, inlayLineStartOffset, inlayProperties, insertCodeInlayRenderer);
        if (rendererInlay == null) {
            throw new IllegalStateException("Cannot create inlay");
        }
        return rendererInlay;
    }

    public Rectangle getTargetBounds() {
        Rectangle highlighterBounds = this.getHighlighterBounds();
        Rectangle inlayBounds = this.getInlayBounds();
        int startY = 0;
        if (highlighterBounds != null) {
            startY = highlighterBounds.y;
        }
        if (inlayBounds != null) {
            startY = inlayBounds.y;
        }
        int height = 0;
        if (inlayBounds != null) {
            height += inlayBounds.height;
        }
        if (highlighterBounds != null) {
            height += highlighterBounds.height;
        }
        int width = this.editor.getScrollingModel().getVisibleArea().width;
        return new Rectangle(0, startY, width, height);
    }

    private void showPanelAt(Rectangle targetBounds) {
        if (this.actionButtonPanel == null) {
            return;
        }
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        int visibleWidth = visibleArea.width;
        int panelWidth = this.actionButtonPanel.getPreferredSize().width;
        int panelHeight = this.actionButtonPanel.getPreferredSize().height;
        int y = targetBounds.y + targetBounds.height + 8;
        int x = visibleWidth - panelWidth - 8;
        this.actionButtonPanel.setBounds(x -= ((EditorImpl)this.editor).getScrollPane().getVerticalScrollBar().getWidth(), y, panelWidth, panelHeight);
        this.actionButtonPanel.setVisible(true);
    }

    public int getDistanceTo(Point point) {
        Rectangle targetBounds = this.getTargetBounds();
        int pointY = point.y;
        int bottomY = targetBounds.y + targetBounds.height;
        return Math.abs(pointY - bottomY);
    }

    public boolean isPositionIn(int lastDiffBlockBottom, int nextDiffBlockTop, Point point) {
        Rectangle targetBounds = this.getTargetBounds();
        int actionPanelHeight = this.actionButtonPanel.getPreferredSize().height;
        int beginY = Math.min(lastDiffBlockBottom, targetBounds.y);
        int endY = Math.max(nextDiffBlockTop, targetBounds.y + targetBounds.height + actionPanelHeight + 8);
        return point.y >= beginY && point.y <= endY;
    }

    public void showActionPanel() {
        Rectangle targetBounds = this.getTargetBounds();
        this.showPanelAt(targetBounds);
    }

    public void hideActionPanel() {
        if (this.actionButtonPanel != null) {
            this.actionButtonPanel.setVisible(false);
        }
    }

    public void accept(boolean callback) {
        Document document = this.editor.getDocument();
        AtomicLong addedCharsAtom = new AtomicLong();
        CommandProcessor.getInstance().executeCommand(this.project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                addedCharsAtom.set(this.applyChangeToDocument(this.change, document, this.newText));
                FileDocumentManager.getInstance().saveDocument(document);
            }
            catch (Exception e) {
                log.error("acceptChange failed", (Throwable)e);
            }
        }), "\u63a5\u53d7Diff\u53d8\u66f4", null);
        this.dispose();
        this.addedChars = addedCharsAtom.get();
        this.telemetryTextChangeForInlineEdit(this.project, EditorUtil.getEditorFilePath(this.editor), this.source, this.addedLines, this.addedChars);
        this.telemetryInlineEditAcceptRate(true, this.source);
        if (callback) {
            this.changeCallback.onAccept(this);
        }
    }

    protected void reject(boolean callback) {
        this.dispose();
        this.telemetryInlineEditAcceptRate(false, this.source);
        if (callback) {
            this.changeCallback.onReject(this);
        }
    }

    public void dispose() {
        if (this.disposed.get()) {
            return;
        }
        if (this.disposed.compareAndSet(false, true)) {
            if (this.actionButtonPanel != null) {
                this.actionButtonPanel.dispose();
            }
            this.editor.getContentComponent().remove(this.actionButtonPanel);
            this.editor.getContentComponent().removeMouseListener(this.panelMouseListener);
            this.panelMouseListener = null;
            this.actionButtonPanel = null;
            if (this.inlay != null) {
                Disposer.dispose(this.inlay);
            }
            if (CollectionUtils.isNotEmpty(this.highlighters)) {
                this.highlighters.forEach(rangeHighlighter -> {
                    rangeHighlighter.dispose();
                    this.editor.getMarkupModel().removeHighlighter(rangeHighlighter);
                });
            }
        }
    }

    private Rectangle getHighlighterBounds() {
        if (CollectionUtils.isEmpty(this.highlighters)) {
            return null;
        }
        RangeHighlighter highlighter = this.highlighters.get(0);
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        int yStart = this.editor.visualPositionToXY((VisualPosition)this.editor.offsetToVisualPosition((int)startOffset)).y;
        int yEnd = this.editor.visualPositionToXY((VisualPosition)this.editor.offsetToVisualPosition((int)endOffset)).y + this.editor.getLineHeight();
        return new Rectangle(0, yStart, this.editor.getScrollingModel().getVisibleArea().width, yEnd - yStart);
    }

    private Rectangle getInlayBounds() {
        if (this.inlay == null) {
            return null;
        }
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        Rectangle inlayBounds = this.inlay.getBounds();
        if (inlayBounds == null) {
            return null;
        }
        inlayBounds.width = visibleArea.width;
        return inlayBounds;
    }

    private long applyChangeToDocument(LineFragment change, Document document, String newText) {
        boolean isInsert = change.getEndLine2() - change.getStartLine2() > 0;
        boolean isDelete = change.getEndLine1() - change.getStartLine1() > 0;
        long addedChars = 0L;
        String textToInsert = "";
        if (isInsert && newText != null) {
            String[] lines = newText.split("\n");
            StringBuilder builder = new StringBuilder();
            for (int i = change.getStartLine2(); i < change.getEndLine2() && i < lines.length; ++i) {
                builder.append(lines[i]);
                builder.append("\n");
            }
            textToInsert = builder.toString();
        }
        if (isInsert && isDelete) {
            int startOffset = this.getInsertOffset(document, change.getStartLine1());
            int endOffset = change.getEndLine1() < document.getLineCount() ? document.getLineStartOffset(change.getEndLine1()) : document.getTextLength();
            document.replaceString(startOffset, endOffset, (CharSequence)textToInsert);
            addedChars = Math.max(textToInsert.length() - (endOffset - startOffset), 0);
        } else {
            if (isDelete) {
                int startOffset = this.getInsertOffset(document, change.getStartLine1());
                int endOffset = change.getEndLine1() < document.getLineCount() ? document.getLineStartOffset(change.getEndLine1()) : document.getTextLength();
                document.deleteString(startOffset, endOffset);
            }
            if (isInsert) {
                int insertOffset = this.getInsertOffset(document, change.getStartLine1());
                document.insertString(insertOffset, (CharSequence)textToInsert);
                addedChars = textToInsert.length();
            }
        }
        return addedChars;
    }

    public boolean isShowActionPanel() {
        return this.actionButtonPanel != null && this.actionButtonPanel.isVisible();
    }

    public void telemetryTextChangeForInlineEdit(Project project, String filepath, String source, long addedLines, long addedChars) {
        TelemetryService.getInstance().telemetryTextChange(TextChangeContext.builder().project(project).filePath(EditorUtil.getEditorFilePath(this.editor)).addedText(null).startLineNumber(null).accepted(true).language(LanguageUtil.getLanguageByFilePath(filepath)).source(StringUtils.isNotBlank((CharSequence)source) ? source : "inline_edit").changeType(TextChangeTypeEnum.INSERT.getType()).nonLingmaPasted(false).sceneType(FileUtil.detectSceneType(filepath).getKey()).chatTask(ChatTaskEnum.FREE_INPUT.getName()).developerAcceptedInfo(new BaseTextChangeSourceMetric(0L, 0L)).inlineEditAcceptedInfo(new BaseTextChangeSourceMetric(addedChars, addedLines)).build());
    }

    public void telemetryInlineEditAcceptRate(boolean accept, String source) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", this.sessionId);
        data.put("requestId", this.requestId);
        data.put("session_type", SessionTypeEnum.INLINE.getTelemetryType());
        data.put("accept", String.valueOf(accept));
        data.put("addedLines", String.valueOf(this.addedLines));
        data.put("deletedLines", String.valueOf(this.deletedLines));
        TrackEventTypeEnum eventType = "chat_ask_apply".equals(source) ? TrackEventTypeEnum.CHAT_ASK_APPLY_EDIT_OPERATION : TrackEventTypeEnum.INLINE_EDIT_OPERATION;
        TelemetryService.getInstance().telemetry(this.project, eventType, this.requestId, data);
    }

    private int getInsertOffset(Document document, int startLine) {
        if (document.getLineCount() <= startLine && document.getLineCount() > 0) {
            WriteAction.run(() -> document.insertString(document.getLineEndOffset(document.getLineCount() - 1), (CharSequence)"\n"));
        }
        return document.getLineStartOffset(Math.min(startLine, Math.max(0, document.getLineCount() - 1)));
    }

    @Generated
    public InEditorDiffRenderer.InlineDiffLineFragment getChange() {
        return this.change;
    }

    @Generated
    public int getTotalChangeCounts() {
        return this.totalChangeCounts;
    }

    @Generated
    public void setTotalChangeCounts(int totalChangeCounts) {
        this.totalChangeCounts = totalChangeCounts;
    }

    @Generated
    public int getCurrentChangeIndex() {
        return this.currentChangeIndex;
    }

    @Generated
    public void setCurrentChangeIndex(int currentChangeIndex) {
        this.currentChangeIndex = currentChangeIndex;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public Long getAddedLines() {
        return this.addedLines;
    }

    @Generated
    public Long getAddedChars() {
        return this.addedChars;
    }

    @Generated
    public Long getDeletedLines() {
        return this.deletedLines;
    }

    public static interface InlineDiffChangeCallback {
        public void onAccept(InlineDiffSingleChangeComponent var1);

        public void onReject(InlineDiffSingleChangeComponent var1);
    }
}

