/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.ineditordiff;

import com.alibabacloud.intellij.qoder.ui.ineditordiff.InEditorDiffRenderer;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InlineDiffsActionTab
implements Disposable {
    private Editor editor;
    private InEditorDiffRenderer inEditorDiffRenderer;
    private JPanel operationBar;
    private AtomicBoolean tabDispose = new AtomicBoolean(false);

    public InlineDiffsActionTab(Editor editor, InEditorDiffRenderer inEditorDiffRenderer) {
        this.editor = editor;
        this.inEditorDiffRenderer = inEditorDiffRenderer;
        this.operationBar = new JPanel();
        this.operationBar.setLayout(new BorderLayout());
        this.operationBar.add((Component)this.getBottomPanel(), "South");
        editor.getComponent().add((Component)this.operationBar, "South");
        editor.getComponent().revalidate();
        editor.getComponent().repaint();
    }

    private JPanel getBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(null);
        jPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        jPanel.setPreferredSize(new Dimension(-1, 40));
        JButton rejectBtn = new JButton(CosyBundle.message("inline.tab.diff.action.reject", new Object[0]));
        rejectBtn.setCursor(new Cursor(12));
        rejectBtn.addActionListener(e -> {
            this.dispose();
            this.editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
            this.inEditorDiffRenderer.rejectAll();
        });
        jPanel.add(rejectBtn);
        ColorButton acceptButton = new ColorButton();
        acceptButton.setText(CosyBundle.message("inline.tab.diff.action.accept", new Object[0]));
        acceptButton.putClientProperty((Object)"JButton.backgroundColor", (Object)UIManager.getColor("Button.default.startBackground"));
        acceptButton.putClientProperty((Object)"JButton.borderColor", (Object)UIManager.getColor("Button.default.startBorderColor"));
        acceptButton.setForeground(ColorUtil.getItemSelectionForeground());
        acceptButton.setCursor(new Cursor(12));
        acceptButton.addActionListener(e -> {
            this.dispose();
            this.editor.getContentComponent().setCursor(Cursor.getPredefinedCursor(0));
            this.inEditorDiffRenderer.acceptAll();
        });
        jPanel.add((Component)acceptButton);
        return jPanel;
    }

    public boolean isDispose() {
        return this.tabDispose.get();
    }

    public void dispose() {
        if (this.tabDispose.get()) {
            return;
        }
        if (this.operationBar != null) {
            this.editor.getComponent().remove(this.operationBar);
            this.editor.getComponent().revalidate();
            this.editor.getComponent().repaint();
            this.tabDispose.set(true);
        }
    }
}

