/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.ineditordiff;

import com.alibabacloud.intellij.qoder.ui.ineditordiff.DiffAlgorithmResult;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.ISequence;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.OffsetRange;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.SequenceDiff;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public class JGitDiffAlgorithmAdapter {
    public DiffAlgorithmResult compute(ISequence sequence1, ISequence sequence2) {
        if (sequence1.length() == 0 && sequence2.length() == 0) {
            return DiffAlgorithmResult.trivial(sequence1, sequence2);
        }
        String text1 = this.convertSequenceToString(sequence1);
        String text2 = this.convertSequenceToString(sequence2);
        RawText rawText1 = new RawText(text1.getBytes());
        RawText rawText2 = new RawText(text2.getBytes());
        HistogramDiff diffAlgorithm = new HistogramDiff();
        EditList editList = diffAlgorithm.diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)rawText1, (Sequence)rawText2);
        List<SequenceDiff> diffs = this.convertEditsToSequenceDiffs(editList, sequence1, sequence2);
        return new DiffAlgorithmResult(diffs, false);
    }

    private String convertSequenceToString(ISequence sequence) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            sb.append(sequence.getElement(i).toString()).append("\n");
        }
        return sb.toString();
    }

    private List<SequenceDiff> convertEditsToSequenceDiffs(EditList editList, ISequence sequence1, ISequence sequence2) {
        ArrayList<SequenceDiff> diffs = new ArrayList<SequenceDiff>();
        for (Edit edit : editList) {
            OffsetRange range1 = new OffsetRange(edit.getBeginA(), edit.getEndA());
            OffsetRange range2 = new OffsetRange(edit.getBeginB(), edit.getEndB());
            diffs.add(new SequenceDiff(range1, range2));
        }
        return diffs;
    }
}

