/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.ineditordiff;

import com.alibabacloud.intellij.qoder.ui.ineditordiff.Array2D;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.DiffAlgorithmResult;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.ISequence;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.ITimeout;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.OffsetRange;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.SequenceDiff;
import java.util.ArrayList;
import java.util.List;

public class PrefixDiffingAlgorithm {
    private boolean ignoreEmptyLines = false;

    public PrefixDiffingAlgorithm() {
        this(true);
    }

    public PrefixDiffingAlgorithm(boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public DiffAlgorithmResult compute(ISequence sequence1, ISequence sequence2, ITimeout timeout) {
        int col;
        if (sequence1.length() == 0 && sequence2.length() == 0) {
            return DiffAlgorithmResult.trivial(sequence1, sequence2);
        }
        Array2D<Double> costMatrix = new Array2D<Double>(2 * sequence1.length() + 1, sequence2.length() + 1);
        Array2D<Boolean> pathMatrix = new Array2D<Boolean>(2 * sequence1.length() + 1, sequence2.length() + 1);
        for (col = 0; col <= sequence2.length(); ++col) {
            costMatrix.set(0, col, Double.valueOf(col));
            pathMatrix.set(0, col, col > 0);
        }
        for (int row = 0; row <= 2 * sequence1.length(); ++row) {
            costMatrix.set(row, 0, (double)(row + 1) / 2.0);
            pathMatrix.set(row, 0, false);
        }
        for (col = 1; col <= sequence2.length(); ++col) {
            for (int row = 1; row <= 2 * sequence1.length(); ++row) {
                double horizontalMove;
                if (!timeout.isValid()) {
                    return DiffAlgorithmResult.trivialTimedOut(sequence1, sequence2);
                }
                if (row % 2 == 0) {
                    double horizontalMove2;
                    double verticalMove = (Double)costMatrix.get(row, col - 1) + 1.0;
                    if (verticalMove < (horizontalMove2 = ((Double)costMatrix.get(row - 1, col)).doubleValue())) {
                        costMatrix.set(row, col, verticalMove);
                        pathMatrix.set(row, col, true);
                        continue;
                    }
                    costMatrix.set(row, col, horizontalMove2);
                    pathMatrix.set(row, col, false);
                    continue;
                }
                boolean match = this.elementsEqual(sequence1.getElement(Math.floorDiv(row, 2)), sequence2.getElement(col - 1));
                double diagonalMove = match ? (Double)costMatrix.get(row - 1, col - 1) : 2.147483647E9;
                if (diagonalMove < (horizontalMove = (Double)costMatrix.get(row - 1, col) + 0.4)) {
                    costMatrix.set(row, col, diagonalMove);
                    pathMatrix.set(row, col, true);
                    continue;
                }
                costMatrix.set(row, col, horizontalMove);
                pathMatrix.set(row, col, false);
            }
        }
        int backtrackRow = 2 * sequence1.length();
        int backtrackCol = sequence2.length();
        ArrayList<SequenceDiff> result = new ArrayList<SequenceDiff>();
        PendingRange pendingRange = null;
        while (backtrackRow > 0 || backtrackCol > 0) {
            if (backtrackRow <= 0) {
                if (pendingRange == null) {
                    pendingRange = new PendingRange(0, backtrackCol);
                }
                --backtrackCol;
                continue;
            }
            if (backtrackCol <= 0) {
                if (pendingRange == null) {
                    pendingRange = new PendingRange(Math.floorDiv(backtrackRow, 2), 0);
                }
                --backtrackRow;
                continue;
            }
            if (((Boolean)pathMatrix.get(backtrackRow, backtrackCol)).booleanValue()) {
                if (backtrackRow % 2 == 0) {
                    if (pendingRange == null) {
                        pendingRange = new PendingRange(Math.floorDiv(backtrackRow, 2), backtrackCol);
                    }
                    --backtrackCol;
                    continue;
                }
                if (pendingRange != null) {
                    if (pendingRange.x != Math.floorDiv(backtrackRow, 2) + 1 || pendingRange.y != backtrackCol) {
                        this.addDiffIfNotEmpty(result, new OffsetRange(Math.floorDiv(backtrackRow, 2) + 1, pendingRange.x), new OffsetRange(backtrackCol, pendingRange.y), sequence1, sequence2);
                    }
                    pendingRange = null;
                }
                --backtrackRow;
                --backtrackCol;
                continue;
            }
            if (pendingRange == null) {
                pendingRange = new PendingRange(Math.floorDiv(backtrackRow, 2), backtrackCol);
            }
            --backtrackRow;
        }
        if (pendingRange != null && (pendingRange.x > 0 || pendingRange.y > 0)) {
            this.addDiffIfNotEmpty(result, new OffsetRange(0, pendingRange.x), new OffsetRange(0, pendingRange.y), sequence1, sequence2);
        }
        result.sort((a, b) -> Integer.compare(a.getRange1().getStart(), b.getRange1().getStart()));
        return new DiffAlgorithmResult(result, false);
    }

    private boolean elementsEqual(Object element1, Object element2) {
        if (this.ignoreEmptyLines && this.isEmptyLine(element1) && this.isEmptyLine(element2)) {
            return true;
        }
        return element1.equals(element2);
    }

    private boolean isEmptyLine(Object element) {
        if (element == null) {
            return true;
        }
        String str = element.toString().trim();
        return str.isEmpty();
    }

    private void addDiffIfNotEmpty(List<SequenceDiff> result, OffsetRange range1, OffsetRange range2, ISequence sequence1, ISequence sequence2) {
        if (!this.ignoreEmptyLines) {
            result.add(new SequenceDiff(range1, range2));
            return;
        }
        boolean onlyEmptyLines1 = true;
        for (int i = range1.getStart(); i < range1.getEnd(); ++i) {
            if (this.isEmptyLine(sequence1.getElement(i))) continue;
            onlyEmptyLines1 = false;
            break;
        }
        boolean onlyEmptyLines2 = true;
        for (int i = range2.getStart(); i < range2.getEnd(); ++i) {
            if (this.isEmptyLine(sequence2.getElement(i))) continue;
            onlyEmptyLines2 = false;
            break;
        }
        if (!onlyEmptyLines1 || !onlyEmptyLines2) {
            result.add(new SequenceDiff(range1, range2));
        }
    }

    private static class PendingRange {
        int x;
        int y;

        public PendingRange(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

