/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.notifications;

import com.alibabacloud.intellij.qoder.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.qoder.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.qoder.service.ConfigService;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ActionUtil;
import com.alibabacloud.intellij.qoder.util.AuthStatusUtil;
import com.alibabacloud.intellij.qoder.util.CosyBrowserUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrantAuthorNotification {
    static Map<String, Boolean> showNeedLoginMap = new ConcurrentHashMap<String, Boolean>();
    static Map<String, Boolean> showEnableLocalMap = new ConcurrentHashMap<String, Boolean>();

    public static void notifyStartup(@Nullable Project project) {
        Notification notification;
        if (CosyPersistentSetting.getInstance().getState() == null) {
            return;
        }
        if (CosyPersistentSetting.getInstance().getState().isShowCheckReportUsage() && !CosyPersistentSetting.getInstance().getState().isAllowReportUsage() && (notification = NotificationFactory.createInfoStickyNotification(I18NConstant.TRACE_NOTIFY_TITLE, I18NConstant.TRACE_NOTIFY_CONTENT)) != null) {
            notification.addAction((AnAction)new AllowNotificationAction(I18NConstant.TRACE_NOTIFY_AGREE));
            notification.addAction((AnAction)new ForbiddenNotificationAction(I18NConstant.TRACE_NOTIFY_DISAGREE));
            notification.notify(project);
        }
    }

    public static void notifyNeedLoginDirectly(@Nullable Project project) {
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.LOGIN_MSG_REQUIRE_LOGIN);
        if (notification != null) {
            notification.addAction((AnAction)new GotoLoginNotificationAction(CosyBundle.message("notifications.action.button.login", new Object[0])));
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyNeedWhitelistDirectly(@Nullable Project project, AuthStatus authStatus) {
        Notification notification;
        if (authStatus == null) {
            return;
        }
        String message = String.format(CosyBundle.message("notifications.auth.whitelist.not.apply", new Object[0]), authStatus.getName());
        if (StringUtils.isNotBlank((CharSequence)authStatus.getOrgId())) {
            message = String.format(AuthStatusUtil.getNoAccessMessageForOrgMember("notifications.auth.org.whitelist.not.apply"), authStatus.getName(), authStatus.getOrgName());
        }
        if ((notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message)) != null) {
            List<AuthOrgItem> orgItems;
            if (StringUtils.isBlank((CharSequence)authStatus.getOrgId())) {
                notification.addAction((AnAction)new GotoUrlNotificationAction(CosyBundle.message("notifications.action.button.learn", new Object[0]), QoderUrls.EXPR_APPLY_URL.getRealUrl()));
            }
            if (!(orgItems = LoginUtil.getOrgItems(project, LoginUtil.getAuthStatusCacheFirst(project))).isEmpty()) {
                notification.addAction((AnAction)new SwitchIdentifyNotificationAction(CosyBundle.message("notifications.action.button.switch.identify", new Object[0])));
            }
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyNetworkErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.network.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new GotoUrlNotificationAction(CosyBundle.message("notifications.action.button.learn", new Object[0]), QoderUrls.NETWORK_ERROR_URL.getRealUrl()));
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyIpBannedErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.ip.whitelist.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyAppDisabledErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.app.disabled.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyRequireLicenseDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.require.license.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyNeedLogin(@Nullable Project project, boolean forceCheck) {
        String projectName = project.getName();
        if (!forceCheck) {
            if (showNeedLoginMap.containsKey(projectName)) {
                return;
            }
            String string = projectName.intern();
            synchronized (string) {
                if (showNeedLoginMap.containsKey(projectName)) {
                    return;
                }
                showNeedLoginMap.put(projectName, true);
            }
        }
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        AuthStatus authStatus = UserAuthService.getInstance().getState(project);
        if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.NETWORK_ERROR.getValue()) {
            GrantAuthorNotification.notifyNetworkErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.IP_BANNED_ERROR.getValue() && StringUtils.isNotBlank((CharSequence)authStatus.getOrgName())) {
            GrantAuthorNotification.notifyIpBannedErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.APP_DISABLED_ERROR.getValue()) {
            GrantAuthorNotification.notifyAppDisabledErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            GrantAuthorNotification.notifyNeedLoginDirectly(project);
        } else if (authStatus != null && authStatus.getWhitelist() != null && authStatus.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NOT_WHITELIST.getValue()) {
                GrantAuthorNotification.notifyNeedWhitelistDirectly(project, authStatus);
            } else if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
                GrantAuthorNotification.notifyRequireLicenseDirectly(project, authStatus);
            }
        }
    }

    public static void notifyError(@Nullable Project project) {
        NotificationFactory.showErrorNotification(project, I18NConstant.ERROR_NOTIFY_TITLE, I18NConstant.ERROR_NOTIFY_CONTENT);
    }

    public static void notifyUninstall(@Nullable Project project) {
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.TRACE_NOTIFY_TITLE, I18NConstant.UNINSTALL_NOTIFY_CONTENT);
        if (notification != null) {
            notification.addAction((AnAction)new OpenQuestionnaireNotificationAction(I18NConstant.UNINSTALL_NOTIFY_AGREE));
            notification.addAction((AnAction)new NotOpenQuestionnaireNotificationAction(I18NConstant.UNINSTALL_NOTIFY_DISAGREE));
            notification.notify(project);
        }
    }

    public static void notifySwitchIdentityDirectly(@Nullable Project project, @NotNull String message) {
        Notification notification;
        if (message == null) {
            GrantAuthorNotification.$$$reportNull$$$0(0);
        }
        if ((notification = NotificationFactory.createInfoStickyNotification(message)) != null) {
            notification.notify(project);
        }
    }

    private static Boolean checkBeforeSignImprovementPlan(Project project) {
        if (!Cosy.INSTANCE.checkCosy(project, false)) {
            ApplicationManager.getApplication().invokeLater(() -> NotificationFactory.showWarnNotification(project, I18NConstant.COSY_RESTARTING));
            return false;
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        if (!authStatus.isAllow()) {
            if (AuthStatusUtil.isNotLogin(authStatus)) {
                UserAuthService.getInstance().requireLogin(project);
            }
            return false;
        }
        return true;
    }

    public static void notifyNeedSignImprovementDirectly(@Nullable Project project) {
        Notification notification = NotificationFactory.createInfoStickyNotification(CosyBundle.message("sign.improvement.plan.title", new Object[0]), CosyBundle.message("sign.improvement.plan.message", new Object[0]));
        if (notification != null) {
            notification.addAction((AnAction)new AgreeImprovmentPlanNotificationAction(CosyBundle.message("sign.improvement.plan.agree", new Object[0])));
            notification.addAction((AnAction)new DisAgreeImprovmentPlanNotificationAction(CosyBundle.message("sign.improvement.plan.disagree", new Object[0])));
            notification.notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification", "notifySwitchIdentityDirectly"));
    }

    static class DisAgreeImprovmentPlanNotificationAction
    extends NotificationAction {
        public DisAgreeImprovmentPlanNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                DisAgreeImprovmentPlanNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                DisAgreeImprovmentPlanNotificationAction.$$$reportNull$$$0(1);
            }
            if (!GrantAuthorNotification.checkBeforeSignImprovementPlan(anActionEvent.getProject()).booleanValue()) {
                return;
            }
            ThreadUtil.execute(() -> {
                Cosy.INSTANCE.getLanguageService(anActionEvent.getProject()).disagreeImprovementPlan();
                notification.expire();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$DisAgreeImprovmentPlanNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AgreeImprovmentPlanNotificationAction
    extends NotificationAction {
        public AgreeImprovmentPlanNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                AgreeImprovmentPlanNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                AgreeImprovmentPlanNotificationAction.$$$reportNull$$$0(1);
            }
            if (!GrantAuthorNotification.checkBeforeSignImprovementPlan(anActionEvent.getProject()).booleanValue()) {
                return;
            }
            ThreadUtil.execute(() -> {
                Cosy.INSTANCE.getLanguageService(anActionEvent.getProject()).agreeImprovementPlan();
                notification.expire();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$AgreeImprovmentPlanNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NotWantEnableLocalServiceNotificationAction
    extends NotificationAction {
        public NotWantEnableLocalServiceNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                NotWantEnableLocalServiceNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                NotWantEnableLocalServiceNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$NotWantEnableLocalServiceNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class EnableLocalServiceNotificationAction
    extends NotificationAction {
        public EnableLocalServiceNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                EnableLocalServiceNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                EnableLocalServiceNotificationAction.$$$reportNull$$$0(1);
            }
            ConfigService.getInstance().configLocalCompletionSwitch(anActionEvent.getProject(), true);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$EnableLocalServiceNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DismissLoginNotificationAction
    extends NotificationAction {
        public DismissLoginNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                DismissLoginNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                DismissLoginNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$DismissLoginNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SwitchIdentifyNotificationAction
    extends NotificationAction {
        String url;

        public SwitchIdentifyNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
            this.url = this.url;
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            Project project;
            if (anActionEvent == null) {
                SwitchIdentifyNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                SwitchIdentifyNotificationAction.$$$reportNull$$$0(1);
            }
            if ((project = anActionEvent.getProject()) == null) {
                return;
            }
            InputEvent inputEvent = anActionEvent.getInputEvent();
            ActionTriggerHelper.triggerSelectionAction(project, ActionUtil.getActionIdWithAddPrefix("SwitchIdentityAction"), TriggerPlaceEnum.TOOL_WINDOW.getName(), inputEvent == null ? null : inputEvent.getComponent(), inputEvent, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$SwitchIdentifyNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GotoUrlNotificationAction
    extends NotificationAction {
        String url;

        public GotoUrlNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text, String url) {
            super(text);
            this.url = url;
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                GotoUrlNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                GotoUrlNotificationAction.$$$reportNull$$$0(1);
            }
            BrowserUtil.browse((String)this.url);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$GotoUrlNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GotoLoginNotificationAction
    extends NotificationAction {
        public GotoLoginNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                GotoLoginNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                GotoLoginNotificationAction.$$$reportNull$$$0(1);
            }
            UserAuthService.getInstance().login(anActionEvent.getProject(), null);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$GotoLoginNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ForbiddenNotificationAction
    extends NotificationAction {
        public ForbiddenNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                ForbiddenNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ForbiddenNotificationAction.$$$reportNull$$$0(1);
            }
            if (CosyPersistentSetting.getInstance().getState() != null) {
                CosyPersistentSetting.getInstance().getState().setAllowReportUsage(false);
                CosyPersistentSetting.getInstance().getState().setShowCheckReportUsage(false);
                CosyPersistentSetting.getInstance().getState().getParameter().setAllowReportUsage(false);
                Cosy.INSTANCE.updateConfig(CosyPersistentSetting.getInstance().getState().getParameter());
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$ForbiddenNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AllowNotificationAction
    extends NotificationAction {
        public AllowNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                AllowNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                AllowNotificationAction.$$$reportNull$$$0(1);
            }
            if (CosyPersistentSetting.getInstance().getState() != null) {
                CosyPersistentSetting.getInstance().getState().setAllowReportUsage(true);
                CosyPersistentSetting.getInstance().getState().setShowCheckReportUsage(false);
                CosyPersistentSetting.getInstance().getState().getParameter().setAllowReportUsage(true);
                Cosy.INSTANCE.updateConfig(CosyPersistentSetting.getInstance().getState().getParameter());
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$AllowNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NotOpenQuestionnaireNotificationAction
    extends NotificationAction {
        public NotOpenQuestionnaireNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                NotOpenQuestionnaireNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                NotOpenQuestionnaireNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$NotOpenQuestionnaireNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenQuestionnaireNotificationAction
    extends NotificationAction {
        public OpenQuestionnaireNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                OpenQuestionnaireNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                OpenQuestionnaireNotificationAction.$$$reportNull$$$0(1);
            }
            CosyBrowserUtil.browse(QoderUrls.MESSAGE_FEEDBACK_URL);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/qoder/ui/notifications/GrantAuthorNotification$OpenQuestionnaireNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

