/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search;

import com.alibabacloud.intellij.qoder.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.common.VpcFeature;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.IdeSeriesType;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.GetProfileUrlParams;
import com.alibabacloud.intellij.qoder.editor.InlineDiffManager;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.search.util.BackgroundAdaptUtil;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.service.handler.ChatAskApplyDiffHandler;
import com.alibabacloud.intellij.qoder.ui.chat.AIAssistantPanel;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatAgentPanel;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.qoder.ui.chat.ChatContentPanel;
import com.alibabacloud.intellij.qoder.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.component.FixedHeightLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.TabLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.profiler.ProfilerDisplayItemPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.ChatHistoryPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.McpToolHrefNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.OpenChatHistoryNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.OpenMemoryRecordPageNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderCreateNewChatNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderProfilerReloadNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderSessionRecoverNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderTabChangeNotifier;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.JCefUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefMessageRouterHandler;
import org.jetbrains.annotations.NotNull;

public class QoderToolWindowPanel {
    private static final Logger log = Logger.getInstance(QoderToolWindowPanel.class);
    private static final int MIN_TOOLWINDOW_WIDTH = 470;
    private static final int LOGOUT_POPUP_LABEL_FIX_WIDTH = 122;
    private static final int TAB_DEFAULT_MARGIN = 32;
    private static final int TAB_MIN_MAX_MARGIN = 8;
    public static final String CHAT_TAB = "chat";
    public static final String SEARCH_TAB = "search";
    public static final String AI_DEVELOPER_TAB = "AiDeveloper";
    public static final String AI_ASSISTANT_TAB = "AiAssistantAgent";
    private static final int HEADER_HEIGHT = 40;
    private JPanel mainPanel;
    private JPanel headerPanel;
    private JPanel contentPanel;
    private JPanel tabPanel;
    private JPanel infoPanel;
    private JPanel headerContentPanel;
    private BaseChatPanel currentChatPanel;
    private GenerateContentForm generateContentForm;
    private ChatContentPanel chatContentPanel;
    private AIAssistantPanel aiAssistantPanel;
    private ChatHistoryPanel chatHistoryPanel;
    JLabel chatTabBtn;
    JLabel aiDeveloperTabBtn;
    JLabel aiAssistantTabBtn;
    JLabel createNewChatBtn;
    JPanel userInfoPanel;
    JLabel userAvatarLabel;
    JLabel popupIconLabel;
    JLabel loginBtn;
    Box loggedBox;
    JBPopup userInfoPopup;
    JPanel popupPanel;
    ProfilerDisplayItemPanel profilerDisplayItemPanel;
    private Box.Filler tabMarginFilter1;
    private Project project;
    private MessageBusConnection messageBusConnection;
    private Boolean hideUserName;
    private String userName;
    private JBCefBrowser jbCefBrowser;
    private String sessionType;

    public QoderToolWindowPanel(@NotNull Project project) {
        if (project == null) {
            QoderToolWindowPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.hideUserName = false;
        this.project = project;
        this.headerPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)0, (int)0, (int)1, (int)0));
        this.headerContentPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        BackgroundAdaptUtil.monitorUserInfoPanelBackgroundColor();
    }

    public void delayInit() {
        log.info("start to init chat panel");
        this.setupTabPanel(this.project);
        this.updateUiTexts();
        this.setupPanelResizable();
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::notifyChangeAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.messageBusConnection.subscribe(QoderTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION, this::changeTab);
        this.messageBusConnection.subscribe(QoderSessionRecoverNotifier.SESSION_RECOVER_NOTIFICATION, this::recoverSession);
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(OpenChatHistoryNotifier.OPEN_CHAT_HISTORY_NOTIFIER, this::openChatHistory);
        this.messageBusConnection.subscribe(QoderCreateNewChatNotifier.CREATE_NEW_CHAT_NOTIFICATION, this::createNewChat);
        this.messageBusConnection.subscribe(QoderProfilerReloadNotifier.PROFILER_RELOAD_NOTIFIER_TOPIC, this::reloadProfiler);
        this.messageBusConnection.subscribe(OpenMemoryRecordPageNotifier.OPEN_MEMORY_RECORD_PAGE_NOTIFIER, this::openMemoryRecordPage);
        this.messageBusConnection.subscribe(McpToolHrefNotifier.MCP_TOOL_HREF_NOTIFICATION, this::openMcpTool);
        log.info("start to get auth status");
        ThreadUtil.invokeLater(() -> this.notifyLoginAuth(LoginUtil.getAuthStatus(this.project)));
    }

    private void initComponentsForVpc(Box container) {
        boolean showDeveloper;
        boolean showChat;
        this.generateContentForm = new GenerateContentForm(this.project);
        this.chatContentPanel = new ChatContentPanel(this.project);
        this.chatTabBtn = new TabLabel(CosyBundle.message("toolwindow.main.tab.title.chat", new Object[0]), 40);
        this.setupTabColor(this.chatTabBtn, CHAT_TAB);
        this.aiDeveloperTabBtn = new TabLabel(CosyBundle.message("toolwindow.main.tab.title.aideveloper", new Object[0]), 40);
        this.setupTabColor(this.aiDeveloperTabBtn, AI_DEVELOPER_TAB);
        this.tabMarginFilter1 = new Box.Filler(new Dimension(32, 0), new Dimension(32, 0), new Dimension(32, Short.MAX_VALUE));
        this.chatTabBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QoderToolWindowPanel.this.switchChatPanel(QoderToolWindowPanel.this.generateContentForm);
            }
        });
        this.aiDeveloperTabBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QoderToolWindowPanel.this.switchChatPanel(QoderToolWindowPanel.this.chatContentPanel);
            }
        });
        boolean bl = showChat = !CosyConfig.containsFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), VpcFeature.FEATURE_AI_CHAT_HIDE.getFeature());
        if (showChat) {
            container.add(this.chatTabBtn);
            container.add(this.tabMarginFilter1);
        }
        if (showDeveloper = CosyConfig.containsFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), VpcFeature.FEATURE_AI_DEVELOPER.getFeature())) {
            container.add(this.aiDeveloperTabBtn);
        }
        this.switchChatPanel(showChat ? this.generateContentForm : this.chatContentPanel);
    }

    private void initComponentsForCloud(Box container) {
        this.aiAssistantPanel = new AIAssistantPanel(this.project);
        this.aiAssistantTabBtn = new TabLabel(CosyBundle.message("toolwindow.main.tab.title.aiassistant", new Object[0]), 40);
        this.setupTabColor(this.aiAssistantTabBtn, AI_ASSISTANT_TAB);
        this.aiAssistantTabBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QoderToolWindowPanel.this.clearBrowserContent();
                QoderToolWindowPanel.this.switchChatPanel(QoderToolWindowPanel.this.aiAssistantPanel);
            }
        });
        container.add(this.aiAssistantTabBtn);
        this.switchChatPanel(this.aiAssistantPanel);
    }

    private void setupTabPanel(@NotNull Project project) {
        if (project == null) {
            QoderToolWindowPanel.$$$reportNull$$$0(1);
        }
        this.chatHistoryPanel = new ChatHistoryPanel(project, this);
        Box container = Box.createHorizontalBox();
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.initComponentsForVpc(container);
        } else {
            this.initComponentsForCloud(container);
        }
        this.tabPanel.add((Component)container, "Center");
    }

    private void recoverSession(ChatSession chatSession) {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.switchChatPanel(this.getPanelBySessionType(chatSession.getSessionType()));
        } else {
            this.switchChatPanel(this.aiAssistantPanel);
        }
        this.currentChatPanel.recoverSession(chatSession);
        SwingUtilities.invokeLater(() -> this.currentChatPanel.moveScrollToBottom(this.currentChatPanel instanceof BaseChatAgentPanel));
    }

    public BaseChatPanel getPanelBySessionType(String sessionType) {
        if (SessionTypeEnum.CHAT.getType().equals(sessionType)) {
            return this.generateContentForm;
        }
        if (SessionTypeEnum.DEVELOPER.getType().equals(sessionType)) {
            return this.chatContentPanel;
        }
        return this.aiAssistantPanel;
    }

    private BaseChatPanel getPanelBySessionTab(String sessionTab) {
        if (null == sessionTab) {
            sessionTab = QoderToolWindowPanel.getDefaultSessionTab();
        }
        switch (sessionTab) {
            case "chat": {
                return this.generateContentForm;
            }
            case "AiDeveloper": {
                return this.chatContentPanel;
            }
        }
        return this.aiAssistantPanel;
    }

    public void switchChatPanel(BaseChatPanel panel) {
        if (null == panel) {
            log.warn("ignore invalid null panel");
        } else {
            this.currentChatPanel = panel;
            this.sessionType = this.currentChatPanel.getSessionTypeEnum().getType();
            ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
            if (userData != null) {
                userData.setTabType(this.currentChatPanel.getSessionTab());
            }
            this.setCreateNewChatBtnToolTip(this.currentChatPanel);
            this.contentPanel.removeAll();
            this.contentPanel.add((Component)this.currentChatPanel.getBasePanel(), "Center");
            this.currentChatPanel.switchPanel(this);
            this.removeProfilePage();
            this.contentPanel.invalidate();
            this.contentPanel.validate();
            this.contentPanel.repaint();
            if (this.project != null) {
                InlineDiffManager.Companion.getInstance().closeAllEditor(this.project);
                ChatAskApplyDiffHandler.disposeAll(this.project);
            }
        }
    }

    private void removeProfilePage() {
        if (this.jbCefBrowser != null) {
            this.contentPanel.remove(this.jbCefBrowser.getComponent());
        }
    }

    private void setupToolbar() {
        this.setupNotLoggedInToolbar();
        this.setupLoggedInToolbar();
        this.changeLoginState(QoderToolWindowPanel.getAuthStatusFromCache());
    }

    private void changeLoginState(AuthStatus status) {
        if (status == null) {
            status = LoginUtil.getAuthStatus(this.project);
        } else {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
        if (status.getStatus() != null && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            this.infoPanel.removeAll();
            this.infoPanel.add((Component)this.loggedBox, "Center");
            this.updateUserInfo(status);
            this.buildUserInfoPopupPanel(status);
        } else {
            this.infoPanel.removeAll();
            this.switchChatPanel(this.getPanelBySessionTab(QoderToolWindowPanel.getDefaultSessionTab()));
        }
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
        log.info("end to change status in main panel");
        this.reloadProfiler();
        log.info("end to reload profile in main panel");
    }

    private void setupNotLoggedInToolbar() {
        this.loginBtn = new JLabel(CosyBundle.message("main.toolbar.btn.login", new Object[0]));
        this.loginBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.loginBtn.setFont(this.loginBtn.getFont().deriveFont(14.0f));
        this.loginBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserAuthService.getInstance().login(QoderToolWindowPanel.this.project, QoderToolWindowPanel.this.loginBtn);
            }
        });
    }

    private void setupLoggedInToolbar() {
        this.buildUserInfoPopupPanel(QoderToolWindowPanel.getAuthStatusFromCache());
        this.loggedBox = Box.createHorizontalBox();
        this.createNewChatBtn = new JLabel(QoderIcons.NewIcon);
        this.createNewChatBtn.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.setCreateNewChatBtnToolTip(this.currentChatPanel);
        this.createNewChatBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.createNewChatBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QoderToolWindowPanel.this.createNewChat(new Point(QoderToolWindowPanel.this.createNewChatBtn.getLocationOnScreen().x, QoderToolWindowPanel.this.createNewChatBtn.getLocationOnScreen().y + QoderToolWindowPanel.this.createNewChatBtn.getHeight() + 10));
            }
        });
        this.userInfoPanel = new JPanel(new FlowLayout(0, 8, 0));
        this.userInfoPanel.setOpaque(false);
        this.userAvatarLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                if (QoderToolWindowPanel.this.hideUserName.booleanValue()) {
                    QoderToolWindowPanel.this.userAvatarLabel.setText(null);
                } else {
                    QoderToolWindowPanel.this.userAvatarLabel.setText(QoderToolWindowPanel.this.userName);
                }
                return super.getPreferredSize();
            }
        };
        this.setAvatarAndName(QoderToolWindowPanel.getAuthStatusFromCache());
        this.userAvatarLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.popupIconLabel = new FixedHeightLabel(QoderIcons.ArrowdownIcon, 40);
        this.userInfoPanel.add(this.userAvatarLabel);
        this.userInfoPanel.add(this.popupIconLabel);
        this.addUserInfoPopupEvent(this.userAvatarLabel);
        this.addUserInfoPopupEvent(this.popupIconLabel);
        this.userInfoPanel.setCursor(Cursor.getPredefinedCursor(12));
        JLabel sepLabel = new JLabel(" ");
        sepLabel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)0, (int)0, (int)0, (int)1));
        this.loggedBox.add(this.createNewChatBtn);
        this.loggedBox.add(Box.createHorizontalStrut(12));
        this.loggedBox.add(sepLabel);
        this.loggedBox.add(Box.createHorizontalStrut(12));
        this.loggedBox.add(this.userInfoPanel);
    }

    public static AuthStatus getAuthStatusFromCache() {
        AuthStatus authStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        return null == authStatus ? AuthStatus.NOT_LOGIN : authStatus;
    }

    private void createNewChat(Point location) {
        this.clearBrowserContent();
        this.currentChatPanel.createNewTask(this, location);
        this.reportAndUpdateRequestId();
    }

    public void clearBrowserContent() {
        if (null != this.jbCefBrowser) {
            this.jbCefBrowser.loadHTML("<html><body style='background-color: " + this.getBackgroundColorHex() + ";'></body></html>");
        }
    }

    private String getBackgroundColorHex() {
        try {
            Color bgColor = ColorUtil.getToolWindowBackgroundColor();
            return String.format("#%02x%02x%02x", bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        }
        catch (Exception e) {
            log.warn("getBackgroundColorHex failed");
            return "#ffffff";
        }
    }

    private void reportAndUpdateRequestId() {
        String sessionId = this.currentChatPanel.getInitInput().getChatContext().getSessionId();
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_NEW_SESSION_CLICK, ChatSessionUtil.getRequestId(this.sessionType), sessionId, SessionTypeEnum.getByType(this.sessionType).getTelemetryType());
        ChatSessionUtil.updateRequestId(this.sessionType);
    }

    public void createNewChatDirectly() {
        this.currentChatPanel.createNewTaskDirectly(this);
        this.reportAndUpdateRequestId();
    }

    private void setAvatarAndName(AuthStatus status) {
        if (status == null) {
            status = LoginUtil.getAuthStatusCacheFirst(this.project);
        }
        if (status == null) {
            return;
        }
        Object userName = status.getName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = "Anonymous";
        }
        if (((String)userName).length() > 20) {
            userName = ((String)userName).substring(0, 20) + "...";
        }
        this.userName = userName;
        this.userAvatarLabel.setText((String)userName);
        Icon icon = LoginUtil.getProfilerIcon(this.project, status);
        this.userAvatarLabel.setIcon(icon);
    }

    private void addUserInfoPopupEvent(JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QoderToolWindowPanel.this.profilerDisplayItemPanel.refreshOrganizations();
                if (QoderToolWindowPanel.this.userInfoPopup != null && QoderToolWindowPanel.this.userInfoPopup.isVisible()) {
                    QoderToolWindowPanel.this.userInfoPopup.cancel();
                }
                QoderToolWindowPanel.this.userInfoPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)QoderToolWindowPanel.this.popupPanel, null).setFocusable(true).setRequestFocus(true).setResizable(false).setCancelOnClickOutside(true).createPopup();
                Point point = QoderToolWindowPanel.this.userInfoPanel.getLocationOnScreen();
                Dimension size = QoderToolWindowPanel.this.userInfoPopup.getContent().getPreferredSize();
                QoderToolWindowPanel.this.userInfoPopup.showInScreenCoordinates((Component)QoderToolWindowPanel.this.userInfoPanel, new Point(point.x + QoderToolWindowPanel.this.userInfoPanel.getWidth() - size.width, point.y + QoderToolWindowPanel.this.userInfoPanel.getHeight()));
            }
        });
    }

    private void buildUserInfoPopupPanel(AuthStatus authStatus) {
        this.popupPanel = new JPanel();
        this.popupPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        this.popupPanel.setBorder(JBUI.Borders.empty((int)8));
        this.popupPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.displayProfileEntry(authStatus);
        this.displayPluginSettingEntry();
        final JLabel logoutPopupLabel = new JLabel(CosyBundle.message("settings.login.panel.btn.logout", new Object[0]), QoderIcons.LogoutGreyIcon, 10){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 122;
                return size;
            }
        };
        logoutPopupLabel.setFont(logoutPopupLabel.getFont().deriveFont(14.0f));
        logoutPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        logoutPopupLabel.setForeground(ColorUtil.getTextForegroundColor());
        logoutPopupLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)4, (int)6, (int)0));
        logoutPopupLabel.setCursor(Cursor.getPredefinedCursor(12));
        logoutPopupLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QoderToolWindowPanel.this.userInfoPopup != null && QoderToolWindowPanel.this.userInfoPopup.isVisible()) {
                    QoderToolWindowPanel.this.userInfoPopup.cancel();
                }
                if (null != QoderToolWindowPanel.this.currentChatPanel) {
                    QoderToolWindowPanel.this.currentChatPanel.stopSessionChat();
                }
                ActionManager actionManager = ActionManager.getInstance();
                AnAction action = actionManager.getAction(com.alibabacloud.intellij.qoder.util.ActionUtil.getActionId("CosyAuthLogoutAction"));
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)QoderToolWindowPanel.this.mainPanel);
                DataContext simpleCtx = SimpleDataContext.getSimpleContext((String)CommonDataKeys.PROJECT.getName(), (Object)QoderToolWindowPanel.this.project, (DataContext)dataContext);
                ActionUtil.invokeAction((AnAction)action, (DataContext)simpleCtx, (String)"popup", null, null);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                logoutPopupLabel.setOpaque(true);
                logoutPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                logoutPopupLabel.setForeground(ColorUtil.getPopupMenuSelectionForeground());
                QoderToolWindowPanel.this.profilerDisplayItemPanel.cancelPopup();
                logoutPopupLabel.invalidate();
                logoutPopupLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                logoutPopupLabel.setOpaque(false);
                logoutPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                logoutPopupLabel.setForeground(ColorUtil.getLabelForegroundColor());
                logoutPopupLabel.invalidate();
                logoutPopupLabel.repaint();
            }
        });
        this.popupPanel.add(logoutPopupLabel);
        this.displayUserIdentity(authStatus);
        if (this.userInfoPopup != null && this.userInfoPopup.isVisible()) {
            this.userInfoPopup.cancel();
        }
    }

    private void displayProfileEntry(AuthStatus authStatus) {
        final JLabel profileLabel = new JLabel(CosyBundle.message("settings.login.panel.btn.profile", new Object[0]), QoderIcons.smileIcon, 10){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 122;
                return size;
            }
        };
        profileLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        profileLabel.setForeground(ColorUtil.getTextForegroundColor());
        profileLabel.setFont(profileLabel.getFont().deriveFont(14.0f));
        profileLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)4, (int)6, (int)0));
        profileLabel.setCursor(Cursor.getPredefinedCursor(12));
        profileLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QoderToolWindowPanel.this.userInfoPopup != null && QoderToolWindowPanel.this.userInfoPopup.isVisible()) {
                    QoderToolWindowPanel.this.userInfoPopup.cancel();
                }
                QoderToolWindowPanel.this.openProfilePage(null, false);
                this.mouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                profileLabel.setOpaque(true);
                profileLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                profileLabel.setForeground(ColorUtil.getPopupMenuSelectionForeground());
                QoderToolWindowPanel.this.profilerDisplayItemPanel.cancelPopup();
                profileLabel.invalidate();
                profileLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                profileLabel.setOpaque(false);
                profileLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                profileLabel.setForeground(ColorUtil.getLabelForegroundColor());
                profileLabel.invalidate();
                profileLabel.repaint();
            }
        });
        this.popupPanel.add(profileLabel);
    }

    private void displayPluginSettingEntry() {
        final JLabel pluginSettingLabel = new JLabel(CosyBundle.message("settings.login.panel.btn.plugin", new Object[0]), QoderIcons.Plugin20GreyIcon, 10){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 132;
                return size;
            }
        };
        pluginSettingLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        pluginSettingLabel.setForeground(ColorUtil.getTextForegroundColor());
        pluginSettingLabel.setFont(pluginSettingLabel.getFont().deriveFont(14.0f));
        pluginSettingLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)4, (int)6, (int)0));
        pluginSettingLabel.setCursor(Cursor.getPredefinedCursor(12));
        pluginSettingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingUtilities.invokeLater(() -> ShowSettingsUtil.getInstance().showSettingsDialog(QoderToolWindowPanel.this.project, CosyConfigurable.class));
                QoderToolWindowPanel.this.userInfoPopup.cancel();
                this.mouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                pluginSettingLabel.setOpaque(true);
                pluginSettingLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                pluginSettingLabel.setForeground(ColorUtil.getPopupMenuSelectionForeground());
                pluginSettingLabel.invalidate();
                pluginSettingLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                pluginSettingLabel.setOpaque(false);
                pluginSettingLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                pluginSettingLabel.setForeground(ColorUtil.getLabelForegroundColor());
                pluginSettingLabel.invalidate();
                pluginSettingLabel.repaint();
            }
        });
        this.popupPanel.add(pluginSettingLabel);
    }

    private void openMemoryRecordPage(String memoryId) {
        this.openProfilePage(memoryId, false);
    }

    private void openMcpTool() {
        this.openProfilePage(null, true);
    }

    private void openProfilePage(String memoryId, boolean openMcpView) {
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            ApplicationManager.getApplication().invokeLater(() -> NotificationFactory.showWarnNotification(this.project, I18NConstant.COSY_RESTARTING));
            return;
        }
        this.initProfilePage(memoryId, openMcpView);
        if (this.jbCefBrowser == null) {
            return;
        }
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)this.jbCefBrowser.getComponent(), "Center");
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            ((TabLabel)this.aiDeveloperTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
            ((TabLabel)this.chatTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
        } else {
            ((TabLabel)this.aiAssistantTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private void initProfilePage(String memoryId, boolean openMcpView) {
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            return;
        }
        String url = this.getProfilerUrl(memoryId, openMcpView);
        log.debug("url is " + url);
        if (StringUtils.isBlank((CharSequence)url)) {
            NotificationFactory.showToast((JComponent)this.userAvatarLabel, MessageType.ERROR, CosyBundle.message("profile.get.url.error", new Object[0]));
            return;
        }
        if (!JBCefApp.isSupported()) {
            BrowserUtil.browse((String)url);
            return;
        }
        if (this.jbCefBrowser == null) {
            this.jbCefBrowser = this.createJBCefBrowser();
        }
        ThreadUtil.invokeLater(() -> this.jbCefBrowser.loadURL(url));
    }

    private JBCefBrowser createJBCefBrowser() {
        JBCefBrowser jbCefBrowser = JCefUtil.getJBCefBrowser(this.project);
        this.addJcefHandler(jbCefBrowser);
        return jbCefBrowser;
    }

    private void addJcefHandler(JBCefBrowser jcefBrowser) {
        jcefBrowser.getJBCefClient().getCefClient().addMessageRouter(CefMessageRouter.create((CefMessageRouterHandler)new com.alibabacloud.intellij.qoder.handle.CefMessageRouterHandler(this.project, this)));
    }

    private String getProfilerUrl(String memoryId, boolean openMcpView) {
        GetProfileUrlParams getProfileUrlParams = QoderToolWindowPanel.getGetProfileUrlParams(memoryId, openMcpView);
        log.debug("getProfileUrlParams is " + getProfileUrlParams);
        return Cosy.INSTANCE.getLanguageService(this.project).getProfileUrl(getProfileUrlParams);
    }

    public static GetProfileUrlParams getGetProfileUrlParams(String memoryId, boolean openMcpView) {
        CosySetting setting;
        Color textColor = ColorUtil.getTextForegroundColor();
        Color auxiliaryColor = ColorUtil.getAuxiliaryForegroundColor();
        Color backgroundColor = ColorUtil.getToolWindowBackgroundColor();
        Color cardBgColor = ColorUtil.getChatCardBackgroundColor();
        Color selectionBackgroundColor = ColorUtil.getItemSelectionBackground();
        Color activeBackgroundColor = ColorUtil.getEditorBackgroundColor();
        Color focusBorderColor = JBUI.CurrentTheme.Focus.focusColor();
        Color inputBgColor = ColorUtil.getEditorBackgroundColor();
        Color scrollbarBgColor = ColorUtil.getToolWindowBackgroundColor();
        Color scrollbarThumbBgColor = ColorUtil.getScrollbarThumbBgColor();
        Color textLinkColor = ColorUtil.getLinkForegroundColor();
        Color widgetBorderColor = ColorUtil.getPopupBorderColor();
        Color widgetShadowColor = ColorUtil.getPopupTranslucentbackgroudColor();
        Color dividerColor = ColorUtil.getEditorBackgroundColor();
        Color tabColor = ColorUtil.getTextForegroundColor();
        Color themeColor = ColorUtil.getTabbedUnderlineColor();
        Color buttonBg = ColorUtil.getItemSelectionBackground();
        Color buttonTextColor = ColorUtil.getItemSelectionForeground();
        Color buttonHoverColor = ColorUtil.getItemSelectionBackground();
        Color editorBackgroundColor = ColorUtil.getToolWindowBackgroundColor();
        Color popupBgColor = ColorUtil.getPopupBackgroudColor();
        Color popupBorderColor = ColorUtil.getPopupBorderColor();
        Color tooltipBgColor = ColorUtil.getTooltipBackgroudColor();
        Color tooltipBorderColor = ColorUtil.getTooltipBorderColor();
        Color tooltipFontColor = ColorUtil.getTooltipFontColor();
        String textColorStr = String.format("%02x%02x%02x", textColor.getRed(), textColor.getGreen(), textColor.getBlue());
        String auxiliaryColorStr = String.format("%02x%02x%02x", auxiliaryColor.getRed(), auxiliaryColor.getGreen(), auxiliaryColor.getBlue());
        String cardBackgroundColorStr = String.format("%02x%02x%02x", cardBgColor.getRed(), cardBgColor.getGreen(), cardBgColor.getBlue());
        String backgroundColorStr = String.format("%02x%02x%02x", backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
        String selectionBackgroundColorStr = String.format("%02x%02x%02x", selectionBackgroundColor.getRed(), selectionBackgroundColor.getGreen(), selectionBackgroundColor.getBlue());
        String activeBackgroundColorStr = String.format("%02x%02x%02x", activeBackgroundColor.getRed(), activeBackgroundColor.getGreen(), activeBackgroundColor.getBlue());
        String focusBorderColorStr = String.format("%02x%02x%02x", focusBorderColor.getRed(), focusBorderColor.getGreen(), focusBorderColor.getBlue());
        String inputBgColorStr = String.format("%02x%02x%02x", inputBgColor.getRed(), inputBgColor.getGreen(), inputBgColor.getBlue());
        String scrollbarBgColorStr = String.format("%02x%02x%02x", scrollbarBgColor.getRed(), scrollbarBgColor.getGreen(), scrollbarBgColor.getBlue());
        String scrollbarThumbBgColorStr = String.format("%02x%02x%02x", scrollbarThumbBgColor.getRed(), scrollbarThumbBgColor.getGreen(), scrollbarThumbBgColor.getBlue());
        String textLinkColorStr = String.format("%02x%02x%02x", textLinkColor.getRed(), textLinkColor.getGreen(), textLinkColor.getBlue());
        String widgetBorderColorStr = String.format("%02x%02x%02x", widgetBorderColor.getRed(), widgetBorderColor.getGreen(), widgetBorderColor.getBlue());
        String widgetShadowColorStr = String.format("%02x%02x%02x", widgetShadowColor.getRed(), widgetShadowColor.getGreen(), widgetShadowColor.getBlue());
        String dividerColorStr = String.format("%02x%02x%02x", dividerColor.getRed(), dividerColor.getGreen(), dividerColor.getBlue());
        String tabColorStr = String.format("%02x%02x%02x", tabColor.getRed(), tabColor.getGreen(), tabColor.getBlue());
        String themeColorStr = String.format("%02x%02x%02x", themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue());
        String buttonBgStr = String.format("%02x%02x%02x", buttonBg.getRed(), buttonBg.getGreen(), buttonBg.getBlue());
        String buttonTextColorStr = String.format("%02x%02x%02x", buttonTextColor.getRed(), buttonTextColor.getGreen(), buttonTextColor.getBlue());
        String buttonHoverColorStr = String.format("%02x%02x%02x", buttonHoverColor.getRed(), buttonHoverColor.getGreen(), buttonHoverColor.getBlue());
        String editorBackgroundColorStr = String.format("%02x%02x%02x", editorBackgroundColor.getRed(), editorBackgroundColor.getGreen(), editorBackgroundColor.getBlue());
        String popupBgColorStr = String.format("%02x%02x%02x", popupBgColor.getRed(), popupBgColor.getGreen(), popupBgColor.getBlue());
        String popupBorderColorStr = String.format("%02x%02x%02x", popupBorderColor.getRed(), popupBorderColor.getGreen(), popupBorderColor.getBlue());
        String tooltipBgColorStr = String.format("%02x%02x%02x", tooltipBgColor.getRed(), tooltipBgColor.getGreen(), tooltipBgColor.getBlue());
        String tooltipBorderColorStr = String.format("%02x%02x%02x", tooltipBorderColor.getRed(), tooltipBorderColor.getGreen(), tooltipBorderColor.getBlue());
        String tooltipFontColorStr = String.format("%02x%02x%02x", tooltipFontColor.getRed(), tooltipFontColor.getGreen(), tooltipFontColor.getBlue());
        GetProfileUrlParams getProfileUrlParams = new GetProfileUrlParams();
        getProfileUrlParams.setFontColor(textColorStr);
        getProfileUrlParams.setFontColorGray(auxiliaryColorStr);
        getProfileUrlParams.setIdeType(IdeSeriesType.JETBRAINS.getName());
        getProfileUrlParams.setCardBg(cardBackgroundColorStr);
        getProfileUrlParams.setBg(backgroundColorStr);
        getProfileUrlParams.setActiveBg(activeBackgroundColorStr);
        getProfileUrlParams.setSelectBg(selectionBackgroundColorStr);
        getProfileUrlParams.setFocusBorder(focusBorderColorStr);
        getProfileUrlParams.setInputBg(inputBgColorStr);
        getProfileUrlParams.setScrollbarBg(scrollbarBgColorStr);
        getProfileUrlParams.setScrollbarThumbBg(scrollbarThumbBgColorStr);
        getProfileUrlParams.setTextLinkColor(textLinkColorStr);
        getProfileUrlParams.setWidgetBorder(widgetBorderColorStr);
        getProfileUrlParams.setWidgetShadow(widgetShadowColorStr);
        getProfileUrlParams.setDividerColor(dividerColorStr);
        getProfileUrlParams.setTabColor(tabColorStr);
        getProfileUrlParams.setThemeColor(themeColorStr);
        getProfileUrlParams.setButtonBg(buttonBgStr);
        getProfileUrlParams.setButtonTextColor(buttonTextColorStr);
        getProfileUrlParams.setButtonHoverColor(buttonHoverColorStr);
        getProfileUrlParams.setEditorBackground(editorBackgroundColorStr);
        if (StringUtils.isNotBlank((CharSequence)memoryId)) {
            getProfileUrlParams.setMemoryId(memoryId);
        }
        if (openMcpView) {
            getProfileUrlParams.setMcpListView(Boolean.TRUE.toString());
        }
        Locale locale = (setting = CosyPersistentSetting.getInstance().getState()) == null ? CosySetting.getDefaultDisplayLanguage() : new Locale(setting.getDisplayLanguage());
        getProfileUrlParams.setLocale(locale.getLanguage());
        getProfileUrlParams.setProduct(CosyConfig.getFeature(BuildFeature.PRODUCT.getKey(), "lingma"));
        getProfileUrlParams.setPopupBgColor(popupBgColorStr);
        getProfileUrlParams.setPopupBorderColor(popupBorderColorStr);
        getProfileUrlParams.setTooltipBgColor(tooltipBgColorStr);
        getProfileUrlParams.setTooltipBorderColor(tooltipBorderColorStr);
        getProfileUrlParams.setTooltipFontColor(tooltipFontColorStr);
        return getProfileUrlParams;
    }

    private void displayUserIdentity(AuthStatus status) {
        if (status == null) {
            status = LoginUtil.getAuthStatus(this.project);
        }
        if (status.getStatus() == null || AuthStateEnum.LOGIN.getValue() != status.getStatus().intValue()) {
            return;
        }
        this.popupPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        JSeparator divider = new JSeparator();
        divider.setMaximumSize(new Dimension(122, 1));
        divider.setForeground(ColorUtil.getEditorBackgroundColor());
        this.popupPanel.add(divider);
        this.popupPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        if (this.profilerDisplayItemPanel != null) {
            Disposer.dispose((Disposable)this.profilerDisplayItemPanel);
        }
        this.profilerDisplayItemPanel = new ProfilerDisplayItemPanel(this.project, status);
        this.popupPanel.add(this.profilerDisplayItemPanel);
    }

    private void reloadProfiler() {
        if (!JBCefApp.isSupported()) {
            return;
        }
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            return;
        }
        String url = this.getProfilerUrl(null, false);
        log.info("reload profiler url:" + url);
        if (null == this.jbCefBrowser) {
            this.jbCefBrowser = this.createJBCefBrowser();
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.jbCefBrowser.getCefBrowser().loadURL(url);
        } else {
            this.jbCefBrowser.getCefBrowser().loadURL("");
        }
    }

    private void updateUserInfo(AuthStatus status) {
        this.setAvatarAndName(status);
        this.userAvatarLabel.revalidate();
        this.userAvatarLabel.repaint();
    }

    private void setupTabColor(final JLabel label, final String tabName) {
        label.setBackground(ColorUtil.getTabbedBgColor());
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String currentTab;
                label.setOpaque(true);
                label.setForeground(ColorUtil.getTabbedUnderlineColor());
                ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
                String string = currentTab = null == userData || null == userData.getTabType() ? QoderToolWindowPanel.getDefaultSessionTab() : userData.getTabType();
                if (!tabName.equals(currentTab)) {
                    ((TabLabel)label).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
                }
                label.invalidate();
                label.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                String currentTab;
                label.setOpaque(false);
                label.setForeground(null);
                ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
                String string = currentTab = null == userData || null == userData.getTabType() ? QoderToolWindowPanel.getDefaultSessionTab() : userData.getTabType();
                if (!tabName.equals(currentTab)) {
                    ((TabLabel)label).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
                }
                label.invalidate();
                label.repaint();
            }
        });
    }

    private void notifyLoginAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void notifyChangeAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void notifyLogoutAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void changeTab(String tabName) {
        this.switchChatPanel(this.getPanelBySessionTab(tabName));
    }

    private void setCreateNewChatBtnToolTip(BaseChatPanel panel) {
        if (this.createNewChatBtn != null) {
            this.createNewChatBtn.setToolTipText(panel.getNewChatText());
        }
    }

    private void updateUiTexts() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow != null) {
            toolWindow.setStripeTitle(CosyBundle.message("toolwindow.stripe.Code_Search", new Object[0]));
            toolWindow.setTitle(" ");
            toolWindow.setTitle("");
        }
        this.setupToolbar();
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.chatTabBtn.setText(CosyBundle.message("toolwindow.main.tab.title.chat", new Object[0]));
            this.aiDeveloperTabBtn.setText(CosyBundle.message("toolwindow.main.tab.title.aideveloper", new Object[0]));
        } else {
            this.aiAssistantTabBtn.setText(CosyBundle.message("toolwindow.main.tab.title.aiassistant", new Object[0]));
        }
        this.loginBtn.setText(CosyBundle.message("main.toolbar.btn.login", new Object[0]));
        this.setCreateNewChatBtnToolTip(this.currentChatPanel);
        if (Cosy.INSTANCE.getLanguageService(this.project) != null) {
            Cosy.INSTANCE.getLanguageService(this.project).updateProfile(QoderToolWindowPanel.getGetProfileUrlParams(null, false));
        }
    }

    private void setupPanelResizable() {
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                QoderToolWindowPanel.this.checkMainPanelSize(e.getComponent());
            }
        });
        this.checkMainPanelSize(this.mainPanel);
    }

    private void checkMainPanelSize(Component component) {
        this.hideUserName = component != null && component.getSize().width < 470 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            if (component != null && component.getSize().width < 350) {
                this.tabMarginFilter1.setPreferredSize(new Dimension(8, this.tabMarginFilter1.getHeight()));
            } else {
                this.tabMarginFilter1.setPreferredSize(new Dimension(32, this.tabMarginFilter1.getHeight()));
            }
            this.tabMarginFilter1.revalidate();
        }
        this.tabPanel.revalidate();
        this.tabPanel.repaint();
        this.userInfoPanel.revalidate();
        this.userInfoPanel.repaint();
    }

    private void openChatHistory() {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            ((TabLabel)this.chatTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
            ((TabLabel)this.aiDeveloperTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
        } else {
            ((TabLabel)this.aiAssistantTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
        }
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)this.chatHistoryPanel, "Center");
        this.chatHistoryPanel.fetchHistories();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        TelemetryService.getInstance().telemetry(this.project, TrackEventTypeEnum.CHAT_HISTORY_CLICK, null, null);
    }

    @NotNull
    public static String getDefaultSessionTab() {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            if (!CosyConfig.containsFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), VpcFeature.FEATURE_AI_CHAT_HIDE.getFeature())) {
                return CHAT_TAB;
            }
            if (CosyConfig.containsFeature(BuildFeature.VPC_ENABLED_FEATURES.getKey(), VpcFeature.FEATURE_AI_DEVELOPER.getFeature())) {
                return AI_DEVELOPER_TAB;
            }
            return CHAT_TAB;
        }
        return AI_ASSISTANT_TAB;
    }

    public static SessionTypeEnum getBySessionTab(String sessionTab) {
        if (sessionTab == null) {
            sessionTab = QoderToolWindowPanel.getDefaultSessionTab();
        }
        if (CHAT_TAB.equals(sessionTab)) {
            return SessionTypeEnum.CHAT;
        }
        if (AI_DEVELOPER_TAB.equals(sessionTab)) {
            return SessionTypeEnum.DEVELOPER;
        }
        return SessionTypeEnum.ASSISTANT;
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public JPanel getHeaderPanel() {
        return this.headerPanel;
    }

    @Generated
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Generated
    public JPanel getTabPanel() {
        return this.tabPanel;
    }

    @Generated
    public JPanel getInfoPanel() {
        return this.infoPanel;
    }

    @Generated
    public JPanel getHeaderContentPanel() {
        return this.headerContentPanel;
    }

    @Generated
    public BaseChatPanel getCurrentChatPanel() {
        return this.currentChatPanel;
    }

    @Generated
    public GenerateContentForm getGenerateContentForm() {
        return this.generateContentForm;
    }

    @Generated
    public ChatContentPanel getChatContentPanel() {
        return this.chatContentPanel;
    }

    @Generated
    public AIAssistantPanel getAiAssistantPanel() {
        return this.aiAssistantPanel;
    }

    @Generated
    public ChatHistoryPanel getChatHistoryPanel() {
        return this.chatHistoryPanel;
    }

    @Generated
    public JLabel getChatTabBtn() {
        return this.chatTabBtn;
    }

    @Generated
    public JLabel getAiDeveloperTabBtn() {
        return this.aiDeveloperTabBtn;
    }

    @Generated
    public JLabel getAiAssistantTabBtn() {
        return this.aiAssistantTabBtn;
    }

    @Generated
    public JLabel getCreateNewChatBtn() {
        return this.createNewChatBtn;
    }

    @Generated
    public JPanel getUserInfoPanel() {
        return this.userInfoPanel;
    }

    @Generated
    public JLabel getUserAvatarLabel() {
        return this.userAvatarLabel;
    }

    @Generated
    public JLabel getPopupIconLabel() {
        return this.popupIconLabel;
    }

    @Generated
    public JLabel getLoginBtn() {
        return this.loginBtn;
    }

    @Generated
    public Box getLoggedBox() {
        return this.loggedBox;
    }

    @Generated
    public JBPopup getUserInfoPopup() {
        return this.userInfoPopup;
    }

    @Generated
    public JPanel getPopupPanel() {
        return this.popupPanel;
    }

    @Generated
    public ProfilerDisplayItemPanel getProfilerDisplayItemPanel() {
        return this.profilerDisplayItemPanel;
    }

    @Generated
    public Box.Filler getTabMarginFilter1() {
        return this.tabMarginFilter1;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public Boolean getHideUserName() {
        return this.hideUserName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public JBCefBrowser getJbCefBrowser() {
        return this.jbCefBrowser;
    }

    @Generated
    public String getSessionType() {
        return this.sessionType;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.mainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        this.headerPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, "North");
        this.headerContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, "Center");
        this.tabPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "West");
        this.infoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "East");
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/search/QoderToolWindowPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupTabPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LoginPopupItem {
        private String label;
        private Icon icon;
        private String type;
        private String actionId;

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public Icon getIcon() {
            return this.icon;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getActionId() {
            return this.actionId;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginPopupItem)) {
                return false;
            }
            LoginPopupItem other = (LoginPopupItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            Icon this$icon = this.getIcon();
            Icon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$actionId = this.getActionId();
            String other$actionId = other.getActionId();
            return !(this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginPopupItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            Icon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $actionId = this.getActionId();
            result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QoderToolWindowPanel.LoginPopupItem(label=" + this.getLabel() + ", icon=" + this.getIcon() + ", type=" + this.getType() + ", actionId=" + this.getActionId() + ")";
        }

        @Generated
        public LoginPopupItem(String label, Icon icon, String type, String actionId) {
            this.label = label;
            this.icon = icon;
            this.type = type;
            this.actionId = actionId;
        }

        @Generated
        public LoginPopupItem() {
        }
    }
}

