/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search;

import com.alibabacloud.intellij.qoder.constants.ShortcutConstants;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.qoder.search.asyn.Debouncer;
import com.alibabacloud.intellij.qoder.search.asyn.TrackThreadService;
import com.alibabacloud.intellij.qoder.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.qoder.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchCodeResult;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.search.result.SearchValue;
import com.alibabacloud.intellij.qoder.search.util.BackgroundAdaptUtil;
import com.alibabacloud.intellij.qoder.search.util.CosyServiceUtil;
import com.alibabacloud.intellij.qoder.search.util.PopUtil;
import com.alibabacloud.intellij.qoder.service.CosyService;
import com.alibabacloud.intellij.qoder.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.CosyCodeTableCell;
import com.alibabacloud.intellij.qoder.ui.search.CosyLoadingPanel;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.PromptCell;
import com.alibabacloud.intellij.qoder.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.qoder.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.qoder.ui.search.SwingManager;
import com.alibabacloud.intellij.qoder.ui.search.component.WelcomeBgPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchKeyword;
import com.alibabacloud.intellij.qoder.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.TextFieldActionEnum;
import com.alibabacloud.intellij.qoder.ui.search.form.CosyEmptyForm;
import com.alibabacloud.intellij.qoder.ui.search.form.CosyEndCell;
import com.alibabacloud.intellij.qoder.ui.search.form.DocumentPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.renderer.SearchValueListCellRenderer;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnySearchNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AsynchronousSearchNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.FilterSelectionNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QaActionNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderTabChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.SearchCodeCellActionNotifier;
import com.alibabacloud.intellij.qoder.ui.search.track.ReportStatistic;
import com.alibabacloud.intellij.qoder.util.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SearchMainPanel {
    private static final Logger log = Logger.getInstance(SearchMainPanel.class);
    private JPanel mainPanel;
    private JPanel headPanel;
    private JPanel contentPanel;
    private SearchBar searchField;
    private JLabel lengthLimitLabel;
    private WelcomeBgPanel welcomePanel;
    private SearchResultPanel searchResultPanel;
    private MessageBusConnection messageBusConnection;
    private Project project;
    private List<SearchValue> suggestValueList;
    private JBList<SearchValue> jList;
    private JBPopup jbPopup;
    private ListWithFilter listComponent;
    private JScrollBar hsb;
    private boolean isPromoteView;
    private PopupChooserBuilder chooserBuilder;
    private int codePage;
    private int qaPage;
    private Debouncer debouncer;
    private List<SearchCodeResult> searchCodeResults;
    private List<CodeDocOverviewDetail> codeDocOverviewDetailList;
    private int numCodeSearchHit;
    private int numQASearchHit;
    private static final int MAX_RESULT_NUM = 50;
    private Boolean isScroll;
    private String suggestRequestId;
    private Long suggestStartTime;
    private String searchRequestId;
    private Long searchStartTime;
    private String qaSearchRequestId;
    private Long qaSearchStartTime;
    private TrackThreadService trackThreadService;
    private boolean suggestTimeout;
    private boolean suggestNoNet;
    private PromptCell promptCell;
    private CosyLoadingPanel cosyLoadingPanel;
    private CosyService cosyService;
    private JComponent codeEmptyComponent;
    private JComponent qaEmptyComponent;
    GenerateContentForm generateContentForm;

    public SearchMainPanel(Project project) {
        this.$$$setupUI$$$();
        this.suggestStartTime = 0L;
        this.searchStartTime = 0L;
        this.qaSearchStartTime = 0L;
        this.suggestTimeout = false;
        this.suggestNoNet = false;
        this.qaPage = 0;
        this.codePage = 0;
        this.project = project;
        this.suggestValueList = new ArrayList<SearchValue>();
        this.searchCodeResults = new ArrayList<SearchCodeResult>();
        this.codeDocOverviewDetailList = new ArrayList<CodeDocOverviewDetail>();
        this.debouncer = new Debouncer();
        this.trackThreadService = new TrackThreadService();
        this.cosyLoadingPanel = new CosyLoadingPanel();
        this.promptCell = new PromptCell(project);
        this.lengthLimitLabel.setVisible(false);
        this.cosyService = new CosyServiceImpl();
        this.searchField.initComponents(project);
        this.codeEmptyComponent = new CosyEmptyForm(project).getComponent();
        this.qaEmptyComponent = new CosyEmptyForm(project).getComponent();
        this.searchResultPanel = new SearchResultPanel(project);
        this.welcomePanel = new WelcomeBgPanel();
        this.contentPanel.add((Component)this.welcomePanel, "Center");
        this.searchResultPanel.getSnippetCntLabel().setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.searchResultPanel.getDocCntLabel().setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        SwingManager.INSTANCE.registerComponent(project, "MAIN_PANEL_KEY", this.mainPanel);
        this.listenMessageBus();
        this.monitorScrollPane();
        this.monitorSearchField();
        this.suggestInitialize();
    }

    private void monitorSearchField() {
        this.searchField.addTextFieldKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                String searchText;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtils.isBlank((CharSequence)(searchText = SearchMainPanel.this.searchField.getText()))) {
                    return;
                }
                if (e.getKeyCode() == 10 && TextFieldActionEnum.SEARCH_ACTION.getName().equals(SearchMainPanel.this.searchField.getActionType()) && (!PopUtil.isPopUsable(SearchMainPanel.this.jbPopup) || SearchMainPanel.this.jList.getSelectedIndex() < 0)) {
                    SearchMainPanel.this.lengthLimitLabel.setVisible(false);
                    SearchValue selectedValue = new SearchValue(null, searchText, SearchValueTypeEnum.NLP.getType());
                    SearchContext context = new SearchContext(OperationEnum.ADD.text, SearchActionTypeEnum.SEARCH_BAR_TRIGGER.getType(), SearchMainPanel.this.searchField.getTextFieldRewriteIndex());
                    ((AnySearchNotifier)SearchMainPanel.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, selectedValue);
                    return;
                }
                if (!PopUtil.isPopUsable(SearchMainPanel.this.jbPopup)) {
                    return;
                }
                if (!PopUtil.isNotNullJList(SearchMainPanel.this.jList)) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = ShortcutConstants.UP_SHORTCUTS.contains(stroke) ? 38 : (ShortcutConstants.DOWN_SHORTCUTS.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ScrollingUtil.moveDown(SearchMainPanel.this.jList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ScrollingUtil.moveUp(SearchMainPanel.this.jList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ScrollingUtil.movePageUp(SearchMainPanel.this.jList);
                        break;
                    }
                    case 34: {
                        ScrollingUtil.movePageDown(SearchMainPanel.this.jList);
                        break;
                    }
                    case 10: {
                        SearchMainPanel.this.lengthLimitLabel.setVisible(false);
                        SearchValue selectedValue = (SearchValue)SearchMainPanel.this.jList.getSelectedValue();
                        String operation = OperationEnum.ADD.text;
                        if (SearchMainPanel.this.searchField.isTextFieldRewrite()) {
                            operation = OperationEnum.EDIT.text;
                        }
                        SearchMainPanel.this.postTrackInfo(TrackEventTypeEnum.CODE_SUGGEST_SEARCH.getName(), "key_enter", SearchMainPanel.this.jList.getSelectedIndex());
                        SearchContext context = new SearchContext(operation, SearchActionTypeEnum.SEARCH_BAR_TRIGGER.getType(), SearchMainPanel.this.searchField.getTextFieldRewriteIndex());
                        ((AnySearchNotifier)SearchMainPanel.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, selectedValue);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/qoder/ui/search/SearchMainPanel$1", "keyPressed"));
            }
        });
        this.searchField.addTextFieldDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (TextFieldActionEnum.SEARCH_ACTION.getName().equals(SearchMainPanel.this.searchField.getActionType())) {
                    SearchMainPanel.this.triggerSuggestComplete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/qoder/ui/search/SearchMainPanel$2", "textChanged"));
            }
        });
        this.searchField.addActionSelectListener(selectedValue -> SwingUtilities.invokeLater(() -> {
            this.searchField.clearSearchKeyword();
            this.searchField.setTextFocus(false);
        }));
    }

    private void triggerSuggestComplete() {
        this.lengthLimitLabel.setVisible(this.searchField.getText().length() >= 300);
        if (CollectionUtils.isNotEmpty(this.suggestValueList)) {
            this.suggestValueList.clear();
        }
        if (StringUtils.isBlank((CharSequence)this.searchField.getText()) || I18NConstant.SEARCH_DEFAULT_TIP.equals(this.searchField.getText())) {
            if (this.jbPopup != null) {
                this.jbPopup.cancel();
            }
            this.debouncer.shutdown();
            return;
        }
        this.dynamicChangeJbPop(this.searchField.getText());
        this.debouncer.debounce(() -> new Task.Backgroundable(this.project, I18NConstant.SUGGEST_TIP){
            private boolean success;
            final String searchText;
            {
                this.success = false;
                this.searchText = SearchMainPanel.this.searchField.getText();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                RecommendResult recommendResult;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((recommendResult = SearchMainPanel.this.cosyService.suggestCode(SearchMainPanel.this.project, this.searchText)) == null) {
                    SearchMainPanel.this.suggestTimeout = true;
                } else {
                    SearchMainPanel.this.suggestRequestId = recommendResult.getRequestId();
                    if (StringUtils.isNotBlank((CharSequence)recommendResult.getErrMsg()) && "Failed to call remote for searching es".equalsIgnoreCase(recommendResult.getErrMsg())) {
                        SearchMainPanel.this.suggestNoNet = true;
                    }
                }
                SearchMainPanel.this.suggestValueList = CosyServiceUtil.parseSuggestResult(recommendResult, this.searchText);
                List<SearchValue> existSearchList = SearchMainPanel.this.searchField.getSearchValueList();
                Iterator<SearchValue> iterator = SearchMainPanel.this.suggestValueList.iterator();
                block0: while (iterator.hasNext()) {
                    SearchValue item = iterator.next();
                    for (SearchValue existItem : existSearchList) {
                        if (!existItem.equals(item)) continue;
                        iterator.remove();
                        continue block0;
                    }
                }
                this.success = true;
            }

            public void onFinished() {
                if (this.success) {
                    SearchMainPanel.this.suggestStartTime = System.currentTimeMillis();
                    SearchMainPanel.this.suggestComplete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/search/SearchMainPanel$3", "run"));
            }
        }.queue(), 500L, TimeUnit.MILLISECONDS);
    }

    private void suggestInitialize() {
        this.chooserBuilder = (PopupChooserBuilder)JBPopupFactory.getInstance().createPopupChooserBuilder(this.suggestValueList);
        this.jList = (JBList)this.chooserBuilder.getChooserComponent();
        this.chooserBuilder.setRequestFocus(false);
        this.chooserBuilder.setMovable(false);
        this.chooserBuilder.setRenderer((ListCellRenderer)new SearchValueListCellRenderer(this.searchField, this));
        this.jList.getEmptyText().setText(I18NConstant.NO_API_RESULT);
        this.chooserBuilder.setVisibleRowCount(11);
        this.chooserBuilder.setItemChosenCallback((Consumer)new Consumer<Object>(){

            public void consume(Object object) {
                SearchMainPanel.this.postTrackInfo(TrackEventTypeEnum.CODE_SUGGEST_SEARCH.getName(), "mouse_select", SearchMainPanel.this.jList.getSelectedIndex());
                if (object instanceof SearchValue) {
                    SearchValue searchValue = (SearchValue)object;
                    String operation = OperationEnum.ADD.text;
                    if (SearchMainPanel.this.searchField.isTextFieldRewrite()) {
                        operation = OperationEnum.EDIT.text;
                    }
                    SearchContext context = new SearchContext(operation, SearchActionTypeEnum.SEARCH_BAR_TRIGGER.getType(), SearchMainPanel.this.searchField.getTextFieldRewriteIndex());
                    ((AnySearchNotifier)SearchMainPanel.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
                }
            }
        });
    }

    private void suggestComplete() {
        if (!this.searchField.isFocusOwner() || StringUtils.isBlank((CharSequence)this.searchField.getText())) {
            return;
        }
        if (PopUtil.isPopUsable(this.jbPopup)) {
            this.jList.setModel((ListModel)new CollectionListModel(this.suggestValueList));
            this.jList.setSelectedIndex(0);
            ScrollingUtil.ensureIndexIsVisible(this.jList, (int)0, (int)1);
            this.jList.getEmptyText().setText(I18NConstant.NO_API_RESULT);
            this.updateTips();
            this.adjustJbPopSize();
            return;
        }
        if (this.jbPopup != null) {
            this.jbPopup.cancel();
        }
        this.jList.setModel((ListModel)new CollectionListModel(this.suggestValueList));
        this.jbPopup = this.chooserBuilder.createPopup();
        this.jList.setSelectedIndex(0);
        this.jList.getEmptyText().setText(I18NConstant.NO_API_RESULT);
        this.listComponent = (ListWithFilter)((JPanel)this.jbPopup.getContent().getComponent(0)).getComponent(0);
        this.listComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.hsb = this.listComponent.getScrollPane().getHorizontalScrollBar();
        this.updateTips();
        this.adjustJbPopSize();
        this.jbPopup.showUnderneathOf((Component)((Object)this.searchField));
    }

    private void dynamicChangeJbPop(String text) {
        if (!this.searchField.isFocusOwner()) {
            return;
        }
        SearchValue searchValue = new SearchValue(null, text, SearchValueTypeEnum.NLP.getType());
        if (!PopUtil.isPopUsable(this.jbPopup)) {
            return;
        }
        this.jList.setModel((ListModel)new CollectionListModel(new Object[]{searchValue}));
        this.jList.setSelectedIndex(0);
        ScrollingUtil.ensureIndexIsVisible(this.jList, (int)0, (int)1);
        this.adjustJbPopSize();
    }

    private void adjustJbPopSize() {
        int width = Math.max(this.searchField.getSize().width, this.searchField.getPreferredSize().width);
        Dimension dimension = new Dimension(width, this.listComponent.getPreferredSize().height);
        dimension.height += this.hsb.getPreferredSize().height;
        this.jbPopup.setSize(dimension);
    }

    public void clearJBComponent() {
        this.suggestValueList = Collections.emptyList();
        this.jList.setModel((ListModel)new CollectionListModel(this.suggestValueList));
        this.jList.setSelectedIndex(0);
        this.jList.getEmptyText().setText(I18NConstant.NO_API_RESULT);
        if (this.jbPopup != null) {
            this.jbPopup.cancel();
        }
        this.debouncer.shutdown();
    }

    public void initializeSearchField() {
        this.searchField.setText(null);
        if (this.searchField.isFocusOwner()) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent((Component)((Object)this.searchField), 1005));
        } else {
            this.searchField.setForeground(Color.GRAY);
        }
    }

    private void updateTips() {
        if (this.suggestTimeout) {
            this.jList.getEmptyText().setText(I18NConstant.TIMEOUT_MESSAGE);
            this.suggestTimeout = false;
        }
        if (this.suggestNoNet) {
            this.suggestNoNet = false;
            this.jList.getEmptyText().setText(I18NConstant.NO_NET);
        }
    }

    private void listenMessageBus() {
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AnySearchNotifier.ANY_SEARCH_NOTIFICATION, this::anySearch);
        this.messageBusConnection.subscribe(AsynchronousSearchNotifier.ASYNCHRONOUS_SEARCH_NOTIFICATION, this::asynchronousSearch);
        this.messageBusConnection.subscribe(FilterSelectionNotifier.FILTER_SELECTION_NOTIFICATION, this::selectFilter);
        this.messageBusConnection.subscribe(SearchCodeCellActionNotifier.SEARCH_CODE_CLICK, this::searchCodeClick);
        this.messageBusConnection.subscribe(QaActionNotifier.SEARCH_QA_CLICK, this::qaSearchClick);
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        BackgroundAdaptUtil.monitorBackgroundColor(this);
    }

    private void anyGenerate(SearchContext context, GenerateInput input, String requestId) {
        if (input.getChatContext() == null) {
            log.warn("generate context is null");
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow != null) {
            if (!toolWindow.isVisible()) {
                SearchToolWindowFactory.showToolWindow(this.project);
            }
            Content content = toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME);
        }
    }

    private void anySearch(SearchContext context, SearchValue searchValue) {
        if (context == null && searchValue == null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.searchField.getTextField(), 1004));
            return;
        }
        if (context == null) {
            log.warn("search context is null");
            return;
        }
        if (!TextFieldActionEnum.SEARCH_ACTION.getName().equals(this.searchField.getActionType())) {
            this.searchField.setActionType(TextFieldActionEnum.SEARCH_ACTION.getName());
        }
        ((QoderTabChangeNotifier)this.project.getMessageBus().syncPublisher(QoderTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION)).changeTab("search");
        this.contentPanel.removeAll();
        this.searchResultPanel.setSearchQA(false);
        this.searchResultPanel.setSearchCode(false);
        this.searchResultPanel.getDocumentPane().removeAll();
        this.searchResultPanel.getCodeSnippetPanel().removeAll();
        this.clearJBComponent();
        this.modifySearchKeywords(context, searchValue);
        List<SearchValue> searchValues = this.searchField.getSearchValueList();
        if (CollectionUtils.isEmpty(searchValues)) {
            this.searchField.toggleClearButton(false);
            this.contentPanel.add((Component)this.welcomePanel, "Center");
            this.contentPanel.repaint();
            return;
        }
        this.searchField.toggleClearButton(true);
        this.qaPage = 0;
        this.codePage = 0;
        if (!OperationEnum.ADD.text.equals(context.getOperation()) || searchValues.size() == 1) {
            this.searchResultPanel.getSnippetResultFilterButton().resetSourceFilterPopupMenu();
            this.searchResultPanel.getDocResultFilterButton().resetSourceFilterPopupMenu();
        }
        JTabbedPane jbTabbedPanel = this.searchResultPanel.getContentTabPane();
        int selectIndex = jbTabbedPanel.getSelectedIndex();
        this.asynchronousSearch(context, selectIndex);
    }

    private void selectFilter(SearchContext context) {
        if (context.getSnippetSources() == null || context.getDocSources() == null) {
            log.warn("Empty filter selection event. Do nothing.");
            return;
        }
        this.contentPanel.removeAll();
        this.searchResultPanel.setSearchQA(false);
        this.searchResultPanel.setSearchCode(false);
        this.searchResultPanel.getDocumentPane().removeAll();
        this.searchResultPanel.getCodeSnippetPanel().removeAll();
        this.codePage = 0;
        this.qaPage = 0;
        this.clearJBComponent();
        JTabbedPane jbTabbedPanel = this.searchResultPanel.getContentTabPane();
        int selectIndex = jbTabbedPanel.getSelectedIndex();
        this.asynchronousSearch(context, selectIndex);
    }

    public void asynchronousSearch(final SearchContext context, final int selectIndex) {
        this.contentPanel.add(this.searchResultPanel.getComponent(), "Center");
        List<SearchValue> searchValues = this.searchField.getSearchValueList();
        final Set<SearchValue> keywordList = SearchUtil.getSearchAPIKeyword(searchValues);
        final String query = SearchUtil.getSearchNLPKeyword(searchValues);
        new Task.Backgroundable(this.project, I18NConstant.SEARCH_TIP){
            private boolean success;
            {
                super(project, title);
                this.success = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (selectIndex == 0) {
                    SearchMainPanel.this.searchResultPanel.getCodeSnippetPanel().removeAll();
                    SearchMainPanel.this.searchResultPanel.getCodeSnippetPanel().setLayout(new BorderLayout());
                    SearchMainPanel.this.searchResultPanel.getCodeSnippetPanel().add(SearchMainPanel.this.cosyLoadingPanel.getComponent(), "Center");
                    SearchMainPanel.this.runCodeSearch(query, keywordList, context);
                } else {
                    SearchMainPanel.this.searchResultPanel.getDocumentPane().removeAll();
                    SearchMainPanel.this.searchResultPanel.getDocumentPane().setLayout(new BorderLayout());
                    SearchMainPanel.this.searchResultPanel.getDocumentPane().add(SearchMainPanel.this.cosyLoadingPanel.getComponent(), "Center");
                    SearchMainPanel.this.runQASearch(query, keywordList, context);
                }
                this.success = true;
            }

            public void onFinished() {
                if (this.success) {
                    if (selectIndex == 0) {
                        SearchMainPanel.this.searchResultPanel.setSearchCode(true);
                        SearchMainPanel.this.finishCodeSearch();
                    } else {
                        SearchMainPanel.this.searchResultPanel.setSearchQA(true);
                        SearchMainPanel.this.finishQASearch();
                    }
                    SearchMainPanel.this.contentPanel.repaint();
                    SearchMainPanel.this.contentPanel.revalidate();
                    SearchMainPanel.this.searchField.requestTextFieldFocus();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/search/SearchMainPanel$5", "run"));
            }
        }.queue();
    }

    private void runCodeSearch(String query, Set<SearchValue> keywordList, SearchContext context) {
        RecommendResult recommendResult = this.cosyService.searchCode(this.project, query, keywordList, this.codePage, context.getActionType(), this.searchRequestId, context.getSnippetSources());
        if (recommendResult != null) {
            this.searchRequestId = recommendResult.getRequestId();
        }
        this.searchCodeResults = CosyServiceUtil.parseSearchCode(recommendResult, keywordList);
        this.numCodeSearchHit = recommendResult == null || recommendResult.getTotalHits() == null ? 0 : recommendResult.getTotalHits();
        this.searchResultPanel.getSnippetCntLabel().setText(SearchMainPanel.formatTotalHits(recommendResult));
    }

    private void runQASearch(String query, Set<SearchValue> keywordList, SearchContext context) {
        RecommendResult recommendResult = this.cosyService.searchQA(this.project, query, keywordList, this.qaPage, context.getActionType(), this.qaSearchRequestId, context.getDocSources());
        if (recommendResult != null) {
            this.qaSearchRequestId = recommendResult.getRequestId();
        }
        this.codeDocOverviewDetailList = CosyServiceUtil.parseQAList(query, recommendResult, keywordList);
        this.numQASearchHit = recommendResult == null || recommendResult.getTotalHits() == null ? 0 : recommendResult.getTotalHits();
        this.searchResultPanel.getDocCntLabel().setText(SearchMainPanel.formatTotalHits(recommendResult));
    }

    private void finishQASearch() {
        this.qaSearchStartTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(this.codeDocOverviewDetailList)) {
            this.searchResultPanel.getDocumentPane().removeAll();
            this.searchResultPanel.getDocumentPane().add((Component)this.qaEmptyComponent, "Center");
            return;
        }
        ((DocumentPanel)this.searchResultPanel.getDocumentPane()).updateQAData(this.project, this.codeDocOverviewDetailList);
    }

    private void finishCodeSearch() {
        this.searchStartTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(this.searchCodeResults)) {
            this.searchResultPanel.getCodeSnippetPanel().removeAll();
            this.searchResultPanel.getCodeSnippetPanel().add((Component)this.codeEmptyComponent, "Center");
            return;
        }
        ((DocumentPanel)this.searchResultPanel.getCodeSnippetPanel()).updateCodeData(this.project, this.searchCodeResults);
    }

    private void modifySearchKeywords(SearchContext context, SearchValue searchValue) {
        if (OperationEnum.DELETE.text.equals(context.getOperation())) {
            if (searchValue != null) {
                this.searchField.removeSearchValue(searchValue);
            }
        } else if (OperationEnum.EDIT.text.equals(context.getOperation())) {
            if (SearchValueTypeEnum.NLP.getType().equals(searchValue.getType()) && this.searchField.hasOtherSearchValue(searchValue)) {
                this.searchField.clearSearchKeyword();
                this.searchField.addKeyword(new SearchKeyword(searchValue, this.project));
            } else {
                this.searchField.addKeyword(new SearchKeyword(searchValue, this.project), context.getRewriteIndex());
            }
        } else if (OperationEnum.CLEAR_ALL.text.equals(context.getOperation())) {
            this.searchField.clearSearchKeyword();
            this.lengthLimitLabel.setVisible(false);
        } else {
            if (OperationEnum.CLEAR_AND_ADD.text.equals(context.getOperation()) || SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
                this.searchField.clearSearchKeyword();
            }
            this.searchField.addKeyword(new SearchKeyword(searchValue, this.project));
        }
        this.searchField.updateSearchValueIndex();
        this.searchField.revalidate();
    }

    public JPanel getContent() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.searchField = new SearchBar();
        this.searchField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SearchMainPanel.this.jbPopup != null && SearchMainPanel.this.jbPopup.isVisible() && !SearchMainPanel.this.jbPopup.isDisposed()) {
                    Point p = SearchMainPanel.this.searchField.getLocationOnScreen();
                    Point newPoint = new Point(p.x, p.y + SearchMainPanel.this.searchField.getPreferredSize().height);
                    SearchMainPanel.this.jbPopup.setLocation(newPoint);
                }
            }
        });
    }

    public void monitorScrollPane() {
        final JScrollPane doc2Panel = this.searchResultPanel.getCodeScrollPanel();
        doc2Panel.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sBar = doc2Panel.getVerticalScrollBar();
                List<SearchValue> searchValues = SearchMainPanel.this.searchField.getSearchValueList();
                final List<String> sources = SearchMainPanel.this.searchResultPanel.getSnippetResultFilterButton().getSourceFilters();
                final Set<SearchValue> searchValueList = SearchUtil.getSearchAPIKeyword(searchValues);
                final String query = SearchUtil.getSearchNLPKeyword(searchValues);
                if (sBar.getValue() + sBar.getHeight() == sBar.getMaximum() && sBar.getValue() > 0) {
                    7 var7_7 = this;
                    synchronized (var7_7) {
                        if (SearchMainPanel.this.codePage > 5 || SearchMainPanel.this.codePage == -1) {
                            return;
                        }
                        ++SearchMainPanel.this.codePage;
                        SwingWorker<List<SearchCodeResult>, Void> scrollWorker = new SwingWorker<List<SearchCodeResult>, Void>(){

                            @Override
                            protected List<SearchCodeResult> doInBackground() {
                                RecommendResult recommendResult = SearchMainPanel.this.cosyService.searchCode(SearchMainPanel.this.project, query, searchValueList, SearchMainPanel.this.codePage, SearchActionTypeEnum.MOUSE_SCROLL_TRIGGER.getType(), SearchMainPanel.this.searchRequestId, sources);
                                List<SearchCodeResult> scrollSearchCodeResults = CosyServiceUtil.parseSearchCode(recommendResult, searchValueList);
                                SearchMainPanel.this.searchCodeResults.addAll(scrollSearchCodeResults);
                                if (scrollSearchCodeResults.size() < 10) {
                                    SearchMainPanel.this.codePage = -1;
                                }
                                return scrollSearchCodeResults;
                            }

                            @Override
                            protected void done() {
                                List scrollSearchCodeResults = (List)this.get();
                                for (SearchCodeResult searchCodeResult : scrollSearchCodeResults) {
                                    SearchMainPanel.this.searchResultPanel.getCodeSnippetPanel().add(new CosyCodeTableCell(searchCodeResult, SearchMainPanel.this.project).getComponent());
                                }
                                if (SearchMainPanel.this.codePage > 5 || SearchMainPanel.this.codePage == -1) {
                                    SearchMainPanel.this.searchResultPanel.getCodeSnippetPanel().add(new CosyEndCell().getComponent());
                                }
                                SearchMainPanel.this.contentPanel.repaint();
                                SearchMainPanel.this.contentPanel.revalidate();
                            }
                        };
                        scrollWorker.execute();
                    }
                }
            }
        });
        final JScrollPane qasScrollPane = this.searchResultPanel.getQaScrollPane();
        qasScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sBar = qasScrollPane.getVerticalScrollBar();
                List<SearchValue> searchValues = SearchMainPanel.this.searchField.getSearchValueList();
                final List<String> sources = SearchMainPanel.this.searchResultPanel.getDocResultFilterButton().getSourceFilters();
                final Set<SearchValue> searchValueList = SearchUtil.getSearchAPIKeyword(searchValues);
                final String query = SearchUtil.getSearchNLPKeyword(searchValues);
                if (sBar.getValue() + sBar.getHeight() == sBar.getMaximum() && sBar.getValue() > 0) {
                    8 var7_7 = this;
                    synchronized (var7_7) {
                        if (SearchMainPanel.this.qaPage > 5 || SearchMainPanel.this.qaPage == -1) {
                            return;
                        }
                        ++SearchMainPanel.this.qaPage;
                        SwingWorker<List<CodeDocOverviewDetail>, Void> scrollWorker = new SwingWorker<List<CodeDocOverviewDetail>, Void>(){

                            @Override
                            protected List<CodeDocOverviewDetail> doInBackground() throws Exception {
                                RecommendResult recommendResult = SearchMainPanel.this.cosyService.searchQA(SearchMainPanel.this.project, query, searchValueList, SearchMainPanel.this.qaPage, SearchActionTypeEnum.MOUSE_SCROLL_TRIGGER.getType(), SearchMainPanel.this.qaSearchRequestId, sources);
                                List<CodeDocOverviewDetail> scrollSearchCodeResults = CosyServiceUtil.parseQAList(query, recommendResult, searchValueList);
                                SearchMainPanel.this.codeDocOverviewDetailList.addAll(scrollSearchCodeResults);
                                if (scrollSearchCodeResults.size() < 10) {
                                    SearchMainPanel.this.qaPage = -1;
                                }
                                return scrollSearchCodeResults;
                            }

                            @Override
                            protected void done() {
                                List scrollSearchCodeResults = (List)this.get();
                                for (CodeDocOverviewDetail codeDocOverviewDetail : scrollSearchCodeResults) {
                                    ((DocumentPanel)SearchMainPanel.this.searchResultPanel.getDocumentPane()).addDocument(codeDocOverviewDetail, SearchMainPanel.this.project);
                                }
                                if (SearchMainPanel.this.qaPage > 5 || SearchMainPanel.this.qaPage == -1) {
                                    SearchMainPanel.this.searchResultPanel.getDocumentPane().add(new CosyEndCell().getComponent());
                                }
                                SearchMainPanel.this.contentPanel.repaint();
                                SearchMainPanel.this.contentPanel.revalidate();
                            }
                        };
                        scrollWorker.execute();
                    }
                }
            }
        });
    }

    public void postTrackInfo(String eventType, String actionType, int acceptRank) {
        if (eventType.equals(TrackEventTypeEnum.CODE_SNIPPET_SEARCH.getName()) || eventType.equals(TrackEventTypeEnum.CODE_SNIPPET_NLP_SEARCH.getName())) {
            String requestId = this.searchRequestId;
            long cost = System.currentTimeMillis() - this.searchStartTime;
            int pageNumber = this.codePage;
            int resultNumber = this.searchCodeResults.size();
            ReportStatistic reportStatistic = new ReportStatistic(cost, eventType, requestId, resultNumber, acceptRank, pageNumber, actionType);
            this.trackThreadService.execute(this.project, reportStatistic);
        } else if (eventType.equals(TrackEventTypeEnum.CODE_SUGGEST_SEARCH.getName())) {
            String requestId = this.suggestRequestId;
            long cost = System.currentTimeMillis() - this.suggestStartTime;
            int pageNumber = 0;
            int resultNumber = this.jList.getModel().getSize();
            ReportStatistic reportStatistic = new ReportStatistic(cost, eventType, requestId, resultNumber, acceptRank, pageNumber, actionType);
            this.trackThreadService.execute(this.project, reportStatistic);
        } else if (eventType.equals(TrackEventTypeEnum.CODE_DOC_SEARCH.getName()) || eventType.equals(TrackEventTypeEnum.CODE_DOC_NLP_SEARCH.getName())) {
            String requestId = this.qaSearchRequestId;
            long cost = System.currentTimeMillis() - this.qaSearchStartTime;
            int pageNumber = this.qaPage;
            int resultNumber = this.codeDocOverviewDetailList.size();
            ReportStatistic reportStatistic = new ReportStatistic(cost, eventType, requestId, resultNumber, acceptRank, pageNumber, actionType);
            this.trackThreadService.execute(this.project, reportStatistic);
        }
    }

    private void searchCodeClick(SearchCodeResult searchCodeResult, String action) {
        SearchToolWindowFactory.showToolWindow(this.project);
        int acceptRank = this.searchCodeResults.indexOf(searchCodeResult);
        List<SearchValue> searchValues = this.searchField.getSearchValueList();
        String query = SearchUtil.getSearchNLPKeyword(searchValues);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            this.postTrackInfo(TrackEventTypeEnum.CODE_SNIPPET_NLP_SEARCH.getName(), action, acceptRank);
        } else {
            this.postTrackInfo(TrackEventTypeEnum.CODE_SNIPPET_SEARCH.getName(), action, acceptRank);
        }
    }

    private void qaSearchClick(CodeDocOverviewDetail codeDocOverviewDetail, String action) {
        int acceptRank = this.codeDocOverviewDetailList.indexOf(codeDocOverviewDetail);
        List<SearchValue> searchValues = this.searchField.getSearchValueList();
        String query = SearchUtil.getSearchNLPKeyword(searchValues);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            this.postTrackInfo(TrackEventTypeEnum.CODE_DOC_NLP_SEARCH.getName(), action, acceptRank);
        } else {
            this.postTrackInfo(TrackEventTypeEnum.CODE_DOC_SEARCH.getName(), action, acceptRank);
        }
    }

    private void updateUiTexts() {
        this.welcomePanel.updateUI();
        this.searchResultPanel.getDocCntLabel().setText(SearchMainPanel.formatTotalHits(this.numCodeSearchHit));
        this.searchResultPanel.getSnippetCntLabel().setText(SearchMainPanel.formatTotalHits(this.numQASearchHit));
        this.cosyLoadingPanel.updateUiTexts();
    }

    public ListWithFilter getListComponent() {
        return this.listComponent;
    }

    private static String formatTotalHits(RecommendResult recommendResult) {
        if (recommendResult == null || recommendResult.getTotalHits() == null) {
            return "";
        }
        return I18NConstant.RESULT_CNT_TIPS.replace("{%d}", String.valueOf(Math.min(recommendResult.getTotalHits(), 50)));
    }

    private static String formatTotalHits(int numTotalHits) {
        return I18NConstant.RESULT_CNT_TIPS.replace("{%d}", String.valueOf(Math.min(numTotalHits, 50)));
    }

    @Generated
    public void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    @Generated
    public void setHeadPanel(JPanel headPanel) {
        this.headPanel = headPanel;
    }

    @Generated
    public void setContentPanel(JPanel contentPanel) {
        this.contentPanel = contentPanel;
    }

    @Generated
    public void setSearchField(SearchBar searchField) {
        this.searchField = searchField;
    }

    @Generated
    public void setLengthLimitLabel(JLabel lengthLimitLabel) {
        this.lengthLimitLabel = lengthLimitLabel;
    }

    @Generated
    public void setWelcomePanel(WelcomeBgPanel welcomePanel) {
        this.welcomePanel = welcomePanel;
    }

    @Generated
    public void setSearchResultPanel(SearchResultPanel searchResultPanel) {
        this.searchResultPanel = searchResultPanel;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setSuggestValueList(List<SearchValue> suggestValueList) {
        this.suggestValueList = suggestValueList;
    }

    @Generated
    public void setJList(JBList<SearchValue> jList) {
        this.jList = jList;
    }

    @Generated
    public void setJbPopup(JBPopup jbPopup) {
        this.jbPopup = jbPopup;
    }

    @Generated
    public void setListComponent(ListWithFilter listComponent) {
        this.listComponent = listComponent;
    }

    @Generated
    public void setHsb(JScrollBar hsb) {
        this.hsb = hsb;
    }

    @Generated
    public void setPromoteView(boolean isPromoteView) {
        this.isPromoteView = isPromoteView;
    }

    @Generated
    public void setChooserBuilder(PopupChooserBuilder chooserBuilder) {
        this.chooserBuilder = chooserBuilder;
    }

    @Generated
    public void setCodePage(int codePage) {
        this.codePage = codePage;
    }

    @Generated
    public void setQaPage(int qaPage) {
        this.qaPage = qaPage;
    }

    @Generated
    public void setDebouncer(Debouncer debouncer) {
        this.debouncer = debouncer;
    }

    @Generated
    public void setSearchCodeResults(List<SearchCodeResult> searchCodeResults) {
        this.searchCodeResults = searchCodeResults;
    }

    @Generated
    public void setCodeDocOverviewDetailList(List<CodeDocOverviewDetail> codeDocOverviewDetailList) {
        this.codeDocOverviewDetailList = codeDocOverviewDetailList;
    }

    @Generated
    public void setNumCodeSearchHit(int numCodeSearchHit) {
        this.numCodeSearchHit = numCodeSearchHit;
    }

    @Generated
    public void setNumQASearchHit(int numQASearchHit) {
        this.numQASearchHit = numQASearchHit;
    }

    @Generated
    public void setIsScroll(Boolean isScroll) {
        this.isScroll = isScroll;
    }

    @Generated
    public void setSuggestRequestId(String suggestRequestId) {
        this.suggestRequestId = suggestRequestId;
    }

    @Generated
    public void setSuggestStartTime(Long suggestStartTime) {
        this.suggestStartTime = suggestStartTime;
    }

    @Generated
    public void setSearchRequestId(String searchRequestId) {
        this.searchRequestId = searchRequestId;
    }

    @Generated
    public void setSearchStartTime(Long searchStartTime) {
        this.searchStartTime = searchStartTime;
    }

    @Generated
    public void setQaSearchRequestId(String qaSearchRequestId) {
        this.qaSearchRequestId = qaSearchRequestId;
    }

    @Generated
    public void setQaSearchStartTime(Long qaSearchStartTime) {
        this.qaSearchStartTime = qaSearchStartTime;
    }

    @Generated
    public void setTrackThreadService(TrackThreadService trackThreadService) {
        this.trackThreadService = trackThreadService;
    }

    @Generated
    public void setSuggestTimeout(boolean suggestTimeout) {
        this.suggestTimeout = suggestTimeout;
    }

    @Generated
    public void setSuggestNoNet(boolean suggestNoNet) {
        this.suggestNoNet = suggestNoNet;
    }

    @Generated
    public void setPromptCell(PromptCell promptCell) {
        this.promptCell = promptCell;
    }

    @Generated
    public void setCosyLoadingPanel(CosyLoadingPanel cosyLoadingPanel) {
        this.cosyLoadingPanel = cosyLoadingPanel;
    }

    @Generated
    public void setCosyService(CosyService cosyService) {
        this.cosyService = cosyService;
    }

    @Generated
    public void setCodeEmptyComponent(JComponent codeEmptyComponent) {
        this.codeEmptyComponent = codeEmptyComponent;
    }

    @Generated
    public void setQaEmptyComponent(JComponent qaEmptyComponent) {
        this.qaEmptyComponent = qaEmptyComponent;
    }

    @Generated
    public void setGenerateContentForm(GenerateContentForm generateContentForm) {
        this.generateContentForm = generateContentForm;
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public JPanel getHeadPanel() {
        return this.headPanel;
    }

    @Generated
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Generated
    public SearchBar getSearchField() {
        return this.searchField;
    }

    @Generated
    public JLabel getLengthLimitLabel() {
        return this.lengthLimitLabel;
    }

    @Generated
    public WelcomeBgPanel getWelcomePanel() {
        return this.welcomePanel;
    }

    @Generated
    public SearchResultPanel getSearchResultPanel() {
        return this.searchResultPanel;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public List<SearchValue> getSuggestValueList() {
        return this.suggestValueList;
    }

    @Generated
    public JBList<SearchValue> getJList() {
        return this.jList;
    }

    @Generated
    public JBPopup getJbPopup() {
        return this.jbPopup;
    }

    @Generated
    public JScrollBar getHsb() {
        return this.hsb;
    }

    @Generated
    public boolean isPromoteView() {
        return this.isPromoteView;
    }

    @Generated
    public PopupChooserBuilder getChooserBuilder() {
        return this.chooserBuilder;
    }

    @Generated
    public int getCodePage() {
        return this.codePage;
    }

    @Generated
    public int getQaPage() {
        return this.qaPage;
    }

    @Generated
    public Debouncer getDebouncer() {
        return this.debouncer;
    }

    @Generated
    public List<SearchCodeResult> getSearchCodeResults() {
        return this.searchCodeResults;
    }

    @Generated
    public List<CodeDocOverviewDetail> getCodeDocOverviewDetailList() {
        return this.codeDocOverviewDetailList;
    }

    @Generated
    public int getNumCodeSearchHit() {
        return this.numCodeSearchHit;
    }

    @Generated
    public int getNumQASearchHit() {
        return this.numQASearchHit;
    }

    @Generated
    public Boolean getIsScroll() {
        return this.isScroll;
    }

    @Generated
    public String getSuggestRequestId() {
        return this.suggestRequestId;
    }

    @Generated
    public Long getSuggestStartTime() {
        return this.suggestStartTime;
    }

    @Generated
    public String getSearchRequestId() {
        return this.searchRequestId;
    }

    @Generated
    public Long getSearchStartTime() {
        return this.searchStartTime;
    }

    @Generated
    public String getQaSearchRequestId() {
        return this.qaSearchRequestId;
    }

    @Generated
    public Long getQaSearchStartTime() {
        return this.qaSearchStartTime;
    }

    @Generated
    public TrackThreadService getTrackThreadService() {
        return this.trackThreadService;
    }

    @Generated
    public boolean isSuggestTimeout() {
        return this.suggestTimeout;
    }

    @Generated
    public boolean isSuggestNoNet() {
        return this.suggestNoNet;
    }

    @Generated
    public PromptCell getPromptCell() {
        return this.promptCell;
    }

    @Generated
    public CosyLoadingPanel getCosyLoadingPanel() {
        return this.cosyLoadingPanel;
    }

    @Generated
    public CosyService getCosyService() {
        return this.cosyService;
    }

    @Generated
    public JComponent getCodeEmptyComponent() {
        return this.codeEmptyComponent;
    }

    @Generated
    public JComponent getQaEmptyComponent() {
        return this.qaEmptyComponent;
    }

    @Generated
    public GenerateContentForm getGenerateContentForm() {
        return this.generateContentForm;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 10));
        this.headPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(10, 10, 0, 10), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(false);
        jPanel3.add((Component)jPanel2, "North");
        SearchBar searchBar = this.searchField;
        jPanel2.add((Component)((Object)searchBar), new GridConstraints(0, 0, 1, 2, 8, 1, 0, 0, null, null, null));
        this.lengthLimitLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messageBundle").getString("search.field.limit"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

