/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.qoder.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.shared.cache.CacheManager;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.Source;
import com.alibabacloud.intellij.qoder.ui.search.model.SourceList;
import com.alibabacloud.intellij.qoder.ui.search.topic.FilterSelectionNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import lombok.Generated;

public class SearchResultFilterButton
extends JButton {
    private static Logger logger = Logger.getInstance(SearchResultFilterButton.class);
    private Project project;
    private JPopupMenu sourceFilterPopupMenu;
    private List<String> sourceFilters;
    private Integer buttonIndex;
    private boolean popupShown;
    private MessageBusConnection messageBusConnection;
    private static final String LOCAL_SOURCE_CONFIG_FILE_PATH = "/search/CosySources.json";
    private static final String REMOTE_SOURCE_CONFIG_URL_PATH = "https://codeup-algo.oss-cn-hangzhou.aliyuncs.com/biz/cosy-search/CosySources.json";

    public SearchResultFilterButton(Project project, Integer buttonIndex) {
        this.project = project;
        this.buttonIndex = buttonIndex;
        this.resetSourceFilterPopupMenu();
        this.setText(I18NConstant.SOURCE_FILTER_BUTTON_TEXT);
        this.addActionListener(e -> {
            if (this.popupShown) {
                this.sourceFilterPopupMenu.setVisible(false);
                this.popupShown = false;
            } else {
                this.sourceFilterPopupMenu.show(this, this.getWidth() - this.sourceFilterPopupMenu.getPreferredSize().width, this.getY() + this.getHeight());
                this.popupShown = true;
            }
        });
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
    }

    public void resetSourceFilterPopupMenu() {
        PopupActionListener actionListener = new PopupActionListener();
        this.sourceFilterPopupMenu = new SourceFilterPopupMenu("Source Filter");
        try {
            SourceList sources = this.initSourceConfig();
            if (sources == null || sources.getSnippetSources() == null || sources.getDocSources() == null) {
                logger.error("Failed to reset source menu.");
                return;
            }
            Locale locale = Locale.getDefault();
            List<Source> sourceList = this.buttonIndex == 0 ? sources.getSnippetSources() : sources.getDocSources();
            ArrayList<String> sourceIndexes = new ArrayList<String>();
            for (Source source : sourceList) {
                String label = Locale.CHINESE.getDisplayLanguage().equals(locale.getDisplayLanguage()) ? source.getSourceCn() : source.getSourceEn();
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(label, true);
                item.setName(source.getSourceIdx());
                this.sourceFilterPopupMenu.add(this.customizeCheckBoxMenuItem(item, actionListener));
                sourceIndexes.add(source.getSourceIdx());
            }
            if (this.buttonIndex == 0) {
                SearchResultPanel.defaultSnippetSources = sourceIndexes;
            } else {
                SearchResultPanel.defaultDocSources = sourceIndexes;
            }
            this.sourceFilters = sourceIndexes;
        }
        catch (Exception e) {
            logger.error("Failed to setup source filter menu, because: " + e.getMessage());
            logger.error((Throwable)e);
        }
    }

    public SourceList initSourceConfig() throws IOException {
        Optional optionalSourceMenuConfig = CacheManager.getCosySourceMenuConfigCache().get("SOURCE_MENU_CONFIG_CACHE");
        String sourceJson = null;
        if (optionalSourceMenuConfig.isEmpty()) {
            try {
                InputStream is = SearchResultFilterButton.class.getResourceAsStream(LOCAL_SOURCE_CONFIG_FILE_PATH);
                if (is == null) {
                    logger.error("Failed to load local sources config.");
                    return null;
                }
                sourceJson = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                logger.debug("sourceJson is " + sourceJson);
            }
            catch (Exception e) {
                logger.warn("Failed to load cosy sources config online, use local sources config..");
            }
            CacheManager.getCosySourceMenuConfigCache().set(sourceJson);
        } else {
            sourceJson = (String)optionalSourceMenuConfig.get();
        }
        return (SourceList)JSON.parseObject((String)sourceJson, SourceList.class);
    }

    private JCheckBoxMenuItem customizeCheckBoxMenuItem(JCheckBoxMenuItem item, ActionListener actionListener) {
        item.addActionListener(actionListener);
        item.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", Boolean.TRUE);
        item.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        return item;
    }

    private void updateUiTexts() {
        this.setText(I18NConstant.SOURCE_FILTER_BUTTON_TEXT);
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public JPopupMenu getSourceFilterPopupMenu() {
        return this.sourceFilterPopupMenu;
    }

    @Generated
    public List<String> getSourceFilters() {
        return this.sourceFilters;
    }

    @Generated
    public Integer getButtonIndex() {
        return this.buttonIndex;
    }

    @Generated
    public boolean isPopupShown() {
        return this.popupShown;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setSourceFilterPopupMenu(JPopupMenu sourceFilterPopupMenu) {
        this.sourceFilterPopupMenu = sourceFilterPopupMenu;
    }

    @Generated
    public void setSourceFilters(List<String> sourceFilters) {
        this.sourceFilters = sourceFilters;
    }

    @Generated
    public void setButtonIndex(Integer buttonIndex) {
        this.buttonIndex = buttonIndex;
    }

    @Generated
    public void setPopupShown(boolean popupShown) {
        this.popupShown = popupShown;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    static class SourceFilterPopupMenu
    extends JPopupMenu {
        public SourceFilterPopupMenu(String title) {
            super(title);
        }
    }

    class PopupActionListener
    implements ActionListener {
        PopupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchResultFilterButton.this.sourceFilterPopupMenu.show(SearchResultFilterButton.this, SearchResultFilterButton.this.getWidth() - SearchResultFilterButton.this.sourceFilterPopupMenu.getPreferredSize().width, SearchResultFilterButton.this.getY() + SearchResultFilterButton.this.getHeight());
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length == 0) {
                logger.info("No menus are opened or menu items selected");
            }
            for (MenuElement menuElement : path) {
                Component c = menuElement.getComponent();
                if (!(c instanceof SourceFilterPopupMenu)) continue;
                SourceFilterPopupMenu menu = (SourceFilterPopupMenu)c;
                Component[] components = menu.getComponents();
                ArrayList<String> selectedSources = new ArrayList<String>();
                for (Component component : components) {
                    if (!(component instanceof JCheckBoxMenuItem)) continue;
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)component;
                    if (SearchResultFilterButton.this.sourceFilters.size() == 1 && item.getText().equals(actionEvent.getActionCommand()) && !item.getState()) {
                        item.setState(true);
                        return;
                    }
                    if (!item.getState()) continue;
                    selectedSources.add(item.getName());
                }
                SearchResultFilterButton.this.sourceFilters = selectedSources;
                SearchContext context = new SearchContext(OperationEnum.FILTER.text, SearchActionTypeEnum.SOURCE_FILTER_TRIGGER.getType());
                if (SearchResultFilterButton.this.buttonIndex == 0) {
                    context.setSnippetSources(SearchResultFilterButton.this.sourceFilters);
                } else {
                    context.setDocSources(SearchResultFilterButton.this.sourceFilters);
                }
                ((FilterSelectionNotifier)SearchResultFilterButton.this.getProject().getMessageBus().syncPublisher(FilterSelectionNotifier.FILTER_SELECTION_NOTIFICATION)).selectFilter(context);
            }
        }
    }
}

