/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search;

import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SwingManager {
    public static final String MAIN_PANEL_KEY = "MAIN_PANEL_KEY";
    public static final String RESULT_BASE_PANEL_KEY = "RESULT_BASE_PANEL_KEY";
    public static final String CHAT_MAIN_VERTICAL_SCROLLBAR_KEY = "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY";
    public static final String AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY = "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY";
    public static final String AI_CODE_AGENT_MAIN_VERTICAL_SCROLLBAR_KEY = "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY";
    public static final String INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY = "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY";
    public static final SwingManager INSTANCE = new SwingManager();
    Map<String, Map<String, Component>> components = new ConcurrentHashMap<String, Map<String, Component>>();

    private SwingManager() {
    }

    public void registerComponent(Project project, String key, Component component) {
        if (key == null || component == null) {
            return;
        }
        String projectName = project.getProjectFilePath();
        this.components.computeIfAbsent(projectName, k -> new ConcurrentHashMap()).put(key, component);
    }

    public Component getComponent(Project project, String key) {
        return this.getComponent(project, key, null);
    }

    public Component getComponent(Project project, String key, Component defaultComponent) {
        String projectName = project.getProjectFilePath();
        Map<String, Component> map = this.components.get(projectName);
        Component result = null;
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = defaultComponent;
        }
        return result;
    }
}

