/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class AvatarLabel
extends JLabel {
    private static final Logger LOG = Logger.getInstance(AvatarLabel.class);
    private static final ConcurrentMap<String, Icon> iconMap = new ConcurrentHashMap<String, Icon>();
    private static final int HEIGHT_OFFSET = 2;
    private static final int ICON_MARGIN = 8;
    private static final Color[] COLORS = new Color[]{new Color(14974292), new Color(16753975), new Color(16172370), new Color(12181068), new Color(4828518), new Color(4442821), new Color(9589982), new Color(14845106), new Color(5404656), new Color(2793451)};
    boolean hideName = false;
    int size;
    AuthStatus status;
    String avatarText;
    FontMetrics avatarMetrics;
    Font avatarFont;
    Rectangle2D avatarBounds;
    String userName;
    Color avatarColor;
    volatile Icon avatarIcon;

    public AvatarLabel(AuthStatus status, int size) {
        this.size = size;
        this.setStatus(status);
        this.avatarFont = JBUI.Fonts.label().deriveFont(12.0f).asBold();
        this.avatarMetrics = FontUtil.fontMetrics(this, this.avatarFont);
    }

    public void setStatus(AuthStatus status) {
        this.status = status;
        this.userName = status != null && status.getName() != null && !status.getName().isEmpty() ? status.getName() : "Anonymous";
        this.avatarText = this.userName.substring(0, 1);
        if (this.userName.length() > 20) {
            this.userName = this.userName.substring(0, 20) + "...";
        }
        this.avatarColor = COLORS[this.avatarText.charAt(0) % COLORS.length];
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = SwingUtilities.computeStringWidth(fm, this.userName);
        this.avatarBounds = new Rectangle2D.Double(0.0, 0.0, width, fm.getHeight());
        this.loadAvatarIcon(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadAvatarIcon(AuthStatus status) {
        if (status == null) {
            AvatarLabel avatarLabel = this;
            synchronized (avatarLabel) {
                this.avatarIcon = null;
            }
            return false;
        }
        if (StringUtils.isBlank((CharSequence)status.getAvatarUrl())) {
            AvatarLabel avatarLabel = this;
            synchronized (avatarLabel) {
                this.avatarIcon = null;
            }
            return false;
        }
        this.avatarIcon = (Icon)iconMap.get(status.getAvatarUrl());
        if (this.avatarIcon != null) {
            return true;
        }
        ThreadUtil.execute(() -> {
            block5: {
                try {
                    BufferedImage image = ImageIO.read(new URL(status.getAvatarUrl()));
                    if (image == null) break block5;
                    AvatarLabel avatarLabel = this;
                    synchronized (avatarLabel) {
                        this.avatarIcon = new ImageIcon(image);
                        iconMap.put(status.getAvatarUrl(), this.avatarIcon);
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.revalidate();
                        this.repaint();
                    });
                }
                catch (Exception e) {
                    LOG.warn("load avatar url error:" + status.getAvatarUrl(), (Throwable)e);
                }
            }
        });
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.size;
        int height = this.size;
        if (!this.hideName) {
            width += 8 + (int)this.avatarBounds.getWidth() + 36;
            height = Math.max(this.size, (int)this.avatarBounds.getHeight());
        }
        return new Dimension(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(this.avatarColor);
        boolean drawAvatar = false;
        AvatarLabel avatarLabel = this;
        synchronized (avatarLabel) {
            drawAvatar = this.avatarIcon != null;
        }
        if (this.getVerticalAlignment() == 1) {
            if (drawAvatar) {
                this.drawAvatarIcon(g2d, 0, 0);
            } else {
                g2d.fillOval(0, 0, this.size, this.size);
                g2d.setFont(this.avatarFont);
                g2d.setColor((Color)new JBColor(Color.WHITE, Color.WHITE));
                Rectangle2D textRect = this.avatarMetrics.getStringBounds(this.avatarText, g2d);
                g2d.drawString(this.avatarText, (int)(((double)this.size - textRect.getWidth()) / 2.0), (int)(((double)this.size - textRect.getHeight()) / 2.0) + (int)textRect.getHeight() - 2);
            }
            if (!this.hideName) {
                g2d.setColor(this.getForeground());
                g2d.setFont(this.getFont());
                g2d.drawString(this.userName, this.size + 8, (int)this.avatarBounds.getHeight() - 2);
            }
        } else if (this.getVerticalAlignment() == 0) {
            Dimension labelSize = this.getSize();
            if (drawAvatar) {
                this.drawAvatarIcon(g2d, 0, (labelSize.height - this.size) / 2);
            } else {
                g2d.fillOval(0, (labelSize.height - this.size) / 2, this.size, this.size);
                g2d.setFont(this.avatarFont);
                g2d.setColor((Color)new JBColor(Color.WHITE, Color.WHITE));
                Rectangle2D textRect = this.avatarMetrics.getStringBounds(this.avatarText, g2d);
                g2d.drawString(this.avatarText, (int)(((double)this.size - textRect.getWidth()) / 2.0), (int)(((double)labelSize.height - textRect.getHeight()) / 2.0) + (int)textRect.getHeight() - 2);
            }
            if (!this.hideName) {
                g2d.setColor(this.getForeground());
                g2d.setFont(this.getFont());
                g2d.drawString(this.userName, this.size + 8, (labelSize.height - (int)this.avatarBounds.getHeight()) / 2 + (int)this.avatarBounds.getHeight() - 3);
            }
        }
        this.paintChildren(g2d);
        g2d.dispose();
    }

    private void drawAvatarIcon(Graphics2D g, int x, int y) {
        int avatarSize = Math.min(this.avatarIcon.getIconWidth(), this.avatarIcon.getIconHeight());
        BufferedImage bufferedImage = new BufferedImage(avatarSize, avatarSize, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setClip(new Ellipse2D.Float(0.0f, 0.0f, avatarSize, avatarSize));
        g2d.setColor((Color)new JBColor(0xD3D3D3, 0xD3D3D3));
        g2d.fillOval(0, 0, avatarSize, avatarSize);
        this.avatarIcon.paintIcon(this, g2d, -(this.avatarIcon.getIconWidth() - avatarSize) / 2, -(this.avatarIcon.getIconHeight() - avatarSize) / 2);
        g2d.dispose();
        g.drawImage(bufferedImage, x, y, this.size, this.size, this);
    }

    @Generated
    public boolean isHideName() {
        return this.hideName;
    }

    @Generated
    public void setHideName(boolean hideName) {
        this.hideName = hideName;
    }
}

