/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatQueueParams;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ChatQueuedPanel
extends JPanel {
    private final JTextArea textArea;
    private final ChatQueueParams queuedInfo;

    public ChatQueuedPanel(Project project, ChatQueueParams queuedInfo) {
        this.queuedInfo = queuedInfo;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        final JLabel icon = new JLabel(CommonIcons.infoIcon);
        icon.setAlignmentY(0.0f);
        this.textArea = new JTextArea(this.getText(queuedInfo.getWaitTime())){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Insets insets = ChatQueuedPanel.this.getInsets();
                int maxWith = ChatQueuedPanel.this.getWidth() - icon.getWidth() - insets.left - insets.right;
                if (dim.width > maxWith) {
                    dim.width = maxWith;
                }
                return dim;
            }
        };
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(icon.getFont().deriveFont(0, 13.0f));
        this.textArea.setAlignmentY(0.0f);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dim = ChatQueuedPanel.this.textArea.getSize();
                Insets insets = ChatQueuedPanel.this.getInsets();
                int maxWith = ChatQueuedPanel.this.getWidth() - icon.getWidth() - insets.left - insets.right;
                if (dim.width > maxWith) {
                    dim.width = maxWith;
                }
                ChatQueuedPanel.this.textArea.setSize(dim);
                ChatQueuedPanel.this.revalidate();
                ChatQueuedPanel.this.repaint();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(icon);
        box.add(Box.createHorizontalStrut(4));
        box.add(this.textArea);
        SwingUtil.foreachChildComponent(box, cp -> {
            cp.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        });
        this.add(box);
        this.add(Box.createVerticalStrut(12));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
    }

    private void updateUiTexts() {
        this.textArea.setText(this.getText(this.queuedInfo.getWaitTime()));
    }

    private String getText(Long seconds) {
        if (null == seconds) {
            return "";
        }
        if (seconds < 60L) {
            return CosyBundle.message("chat.queued.text.within.minute", new Object[0]);
        }
        if (seconds < 600L) {
            return CosyBundle.message("chat.queued.text.one.to.ten.minute", seconds / 60L + 1L);
        }
        return CosyBundle.message("chat.queued.text.more.than.ten.minute", new Object[0]);
    }
}

