/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.Code2HtmlConverter;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.EscapeHtmlConverter;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.PrismCode2HtmlConverter;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatCopyContext;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.KeyboardUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.alibabacloud.intellij.qoder.util.SchemaColorUtil;
import com.alibabacloud.intellij.qoder.util.ThemeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import org.apache.commons.lang3.StringUtils;

public class CodeTextPane
extends JTextPane
implements RefreshColorComponent {
    private static final Logger LOG = Logger.getInstance(CodeTextPane.class);
    private static Code2HtmlConverter converter = new PrismCode2HtmlConverter();
    private static Code2HtmlConverter htmlConverter = new EscapeHtmlConverter();
    private static final String DEFAULT_LANGUAGE = "markdown";
    private String language;
    private String template;
    private String chatTask;
    private String requestId;
    private String sessionId;
    private String originText;
    private Icon icon;
    private KeyboardUtil.KeyboardTypingRecord keyboardTypingRecord = new KeyboardUtil.KeyboardTypingRecord();

    public CodeTextPane(final Project project, String content, String language, final String chatTask, final String requestId, final String sessionId) {
        this.originText = content;
        this.template = ThemeUtil.loadCodeGeneralTemplate();
        this.template = SchemaColorUtil.applySchemaColor(this.template);
        this.chatTask = chatTask;
        this.requestId = requestId;
        this.sessionId = sessionId;
        this.setEditable(false);
        this.setFocusable(true);
        this.setContentType("text/html");
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        language = StringUtils.isBlank((CharSequence)language) ? this.getDefaultLanguage() : language.trim();
        this.language = language;
        this.setText(content);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String selectedText;
                LOG.debug("Key released: " + e.getKeyCode() + ", " + e.isControlDown() + ", " + e.isMetaDown());
                CodeTextPane.this.keyboardTypingRecord.record(e.getKeyCode());
                boolean doCopy = false;
                if (e.getKeyCode() == 67 && (e.isControlDown() || e.isMetaDown())) {
                    doCopy = true;
                }
                if (!doCopy && CodeTextPane.this.keyboardTypingRecord.contains(67) && CodeTextPane.this.keyboardTypingRecord.containsAny(17, 157)) {
                    doCopy = true;
                }
                if (doCopy && StringUtils.isNotEmpty((CharSequence)(selectedText = CodeTextPane.this.getSelectedText()))) {
                    LOG.info("Copied to clipboard: " + selectedText);
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_COPY_MANUAL, requestId, sessionId, chatTask, selectedText);
                    CosyCacheKeys.KEY_COPY_PASTE.set((UserDataHolder)ApplicationManager.getApplication(), (Object)ChatCopyContext.builder().text(selectedText).chatTask(chatTask).build());
                }
            }
        };
        this.addKeyListener(keyAdapter);
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
    }

    private String buildText(String text, String language) {
        if (StringUtils.isBlank((CharSequence)this.template)) {
            return text;
        }
        language = language.toLowerCase(Locale.ROOT);
        text = StringUtils.stripEnd((String)text, (String)"\n\t ");
        String html = null;
        try {
            html = converter.convert(text, language);
        }
        catch (Throwable e) {
            LOG.warn("convert error " + e);
            html = htmlConverter.convert(text, language);
        }
        if (html == null) {
            html = StringUtil.escapeXmlEntities((String)text);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = editorColorsScheme.getFont(EditorFontType.PLAIN);
        String fontFamily = font.getFamily();
        Color editorColor = ColorUtil.getEditorBackgroundColor();
        String editorBackgroundColor = String.format("#%02x%02x%02x", editorColor.getRed(), editorColor.getGreen(), editorColor.getBlue());
        return this.template.replace("{{fontFamily}}", fontFamily).replace("{{content}}", html).replace("{{language}}", language).replace("{{background}}", editorBackgroundColor);
    }

    @Override
    public Color getSelectionColor() {
        return CosyColor.MARK_DOWN_CODE_SELECT_BG_COLOR;
    }

    @Override
    public void setText(String text) {
        this.originText = text;
        text = this.buildText(text, this.language);
        this.removeAll();
        super.setText(text);
    }

    @Override
    public String getText() {
        return this.originText;
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this.icon = icon;
            super.setText("");
            this.insertIcon(icon);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    private String getDefaultLanguage() {
        Editor editor;
        String result = null;
        Project project = ProjectUtil.guessCurrentProject((JComponent)this);
        if (project != null && (editor = EditorUtil.getSelectedEditorSafely(project)) != null) {
            result = PsiUtils.getLanguageByCurrentFile(editor);
        }
        if (StringUtils.isBlank(result)) {
            result = PsiUtils.getLanguageByIDE();
        }
        if (result == null) {
            result = DEFAULT_LANGUAGE;
        }
        return result;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (StringUtils.isNotBlank((CharSequence)language)) {
            this.language = language.trim();
        }
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.template = ThemeUtil.loadCodeGeneralTemplate();
        this.template = SchemaColorUtil.applySchemaColor(this.template);
        this.setText(this.getText());
        this.setIcon(this.getIcon());
        this.invalidate();
        this.repaint();
    }
}

