/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import lombok.Generated;

public class DisplayIcon
extends JLabel {
    public static final int HOVER_BG_STYLE = 0;
    public static final int HOVER_SILENT_STYLE = 1;
    Color background;
    int style;
    boolean virtualEnabled = true;

    public DisplayIcon(Icon icon) {
        this(icon, 0);
    }

    public DisplayIcon(Icon icon, final int style) {
        super(icon, 0);
        this.style = style;
        this.background = this.getBackground();
        this.setBorder((Border)JBUI.Borders.empty());
        this.setPreferredSize(new Dimension(20, 20));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DisplayIcon.this.isEnabled() && DisplayIcon.this.virtualEnabled && style == 0) {
                    DisplayIcon.this.setOpaque(true);
                    DisplayIcon.this.setBackground(ColorUtil.getButtonHoverBackgroundColor());
                    DisplayIcon.this.invalidate();
                    DisplayIcon.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (DisplayIcon.this.isEnabled() && DisplayIcon.this.virtualEnabled && style == 0) {
                    DisplayIcon.this.setOpaque(false);
                    DisplayIcon.this.setBackground(DisplayIcon.this.background);
                    DisplayIcon.this.invalidate();
                    DisplayIcon.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (DisplayIcon.this.isEnabled() && DisplayIcon.this.virtualEnabled && style == 0) {
                    DisplayIcon.this.setOpaque(true);
                    DisplayIcon.this.setBackground(ColorUtil.getItemSelectionBackground());
                    DisplayIcon.this.invalidate();
                    DisplayIcon.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DisplayIcon.this.isEnabled() && DisplayIcon.this.virtualEnabled && style == 0) {
                    DisplayIcon.this.setOpaque(false);
                    DisplayIcon.this.setBackground(DisplayIcon.this.background);
                    DisplayIcon.this.invalidate();
                    DisplayIcon.this.repaint();
                }
            }
        });
        if (this.isEnabled() || this.virtualEnabled) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setVirtualEnabled(boolean enabled) {
        this.virtualEnabled = enabled;
        if (enabled) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void selected() {
        this.setEnabled(false);
        this.setOpaque(true);
        this.setBackground(ColorUtil.getButtonHoverBackgroundColor());
        this.invalidate();
        this.repaint();
    }

    public void unSelected() {
        this.setEnabled(false);
        this.setOpaque(false);
        this.setBackground(this.background);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.background = bg;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        if (this.isOpaque()) {
            Dimension arcs = new Dimension(8, 8);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setPaint(this.getBackground());
            graphics.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
        }
        int iconX = (width - this.getIcon().getIconWidth()) / 2;
        int iconY = (height - this.getIcon().getIconHeight()) / 2;
        this.getIcon().paintIcon(this, graphics, iconX, iconY);
        graphics.dispose();
    }

    @Generated
    public boolean isVirtualEnabled() {
        return this.virtualEnabled;
    }
}

