/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.qoder.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.qoder.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.search.result.SearchValue;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.ChatQuestionManager;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnySearchNotifier;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class LinkButton
extends JButton {
    private Project project;

    public LinkButton(final SearchValue searchValue) {
        super(searchValue.getNiceName());
        this.setToolTipText(searchValue.getPack());
        this.initialize();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchContext context = new SearchContext(OperationEnum.ADD.text, SearchActionTypeEnum.RECOMMEND_BAR_TRIGGER.getType());
                ((AnySearchNotifier)LinkButton.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
            }
        });
    }

    public LinkButton(final String nlpSearchWord) {
        super(nlpSearchWord);
        this.initialize();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchValue searchValue = new SearchValue(null, nlpSearchWord, SearchValueTypeEnum.NLP.getType());
                SearchContext context = new SearchContext(OperationEnum.ADD.text, SearchActionTypeEnum.RECOMMEND_BAR_TRIGGER.getType());
                ((AnySearchNotifier)LinkButton.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
            }
        });
    }

    public LinkButton(ChatQuestionManager.ChatQuestion question) {
        super(question.getQuestion());
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(question.getActionId());
        this.initialize();
        this.addActionListener(e -> {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
            Editor selectedEditor = editorManager.getSelectedTextEditor();
            if (selectedEditor == null) {
                NotificationFactory.showWarnNotification(this.project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            } else {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)selectedEditor.getComponent());
                AnActionEvent event = new AnActionEvent(null, dataContext, TriggerPlaceEnum.TOOL_WINDOW.getName(), new Presentation(), actionManager, 0);
                action.actionPerformed(event);
            }
        });
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
        this.setForeground((Color)new JBColor(new Color(68, 68, 68), new Color(255, 255, 255)));
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

