/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.search.parser.HtmlBlock;
import com.alibabacloud.intellij.qoder.search.parser.HtmlParseContext;
import com.alibabacloud.intellij.qoder.search.parser.HtmlParser;
import com.alibabacloud.intellij.qoder.search.parser.HtmlParserFactory;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MarkdownPanel
extends JPanel {
    private static final String SOFT_PLACEHOLDER = "&[0-9a-z]{2,8};|&#[0-9]{1,7};";
    private final Project project;
    private final String html;
    private final JComponent component;

    public MarkdownPanel(Project project, JComponent component, String html) {
        this.project = project;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 2));
        this.html = html;
        this.component = component;
        this.layoutHtml();
    }

    public void layoutHtml() {
        HtmlParser parser = HtmlParserFactory.getHtmlParser("universal");
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        HtmlParseContext context = new HtmlParseContext(color);
        List<HtmlBlock> blocks = parser.parseHtml(context, this.html);
        this.initComponents(blocks);
    }

    private void addContent(final String content) {
        HtmlPanel htmlPanel = new HtmlPanel(){

            @NotNull
            protected String getBody() {
                String string = content;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/ui/search/component/MarkdownPanel$1", "getBody"));
            }
        };
        htmlPanel.setBody(content);
        String htmlContent = htmlPanel.getText().replaceAll(SOFT_PLACEHOLDER, "");
        htmlPanel.setText(htmlContent);
        htmlPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.add((Component)htmlPanel);
    }

    private void addCode(String content) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)content.trim());
        EditorTextField editorTextField = new EditorTextField(document, this.project, (FileType)JavaFileType.INSTANCE, true, false);
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (color == null) {
            editorTextField.setBackground(editorColorsScheme.getDefaultBackground());
        } else {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(Constants.PLUGIN_NAME);
            assert (toolWindow != null);
            editorTextField.setBackground(toolWindow.getComponent().getBackground());
        }
        editorTextField.setRequestFocusEnabled(false);
        editorTextField.ensureWillComputePreferredSize();
        editorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        editorTextField.setHorizontalSizeReferent((JComponent)editorTextField);
        JBScrollPane jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, size.height + 10);
            }
        };
        jbScrollPane.setViewportView((Component)editorTextField);
        jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jbScrollPane.setHorizontalScrollBarPolicy(30);
        jbScrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)jbScrollPane);
    }

    private void initComponents(List<HtmlBlock> blocks) {
        for (HtmlBlock block : blocks) {
            if ("content".equals(block.getType())) {
                this.addContent(block.getContent());
                continue;
            }
            if (!"code".equals(block.getType())) continue;
            this.addCode(block.getContent());
        }
    }
}

