/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundLineBorder;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import lombok.Generated;

public class RichRoundRectPanel
extends JPanel
implements RefreshColorComponent {
    private static final int DEFAULT_CORNER_RADIUS = 16;
    private int cornerRadius = 16;
    private Color borderColor = null;
    private RoundLineBorder roundLineBorder;
    private Color defaultBackgoundColor;
    private Color hoverBackgoundColor;
    private Color selectedBackgoundColor;
    private boolean needDrawRect;
    private boolean disableBackgoundColorEvent = false;
    private Color cornorBackgroundColor = null;

    public RichRoundRectPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public RichRoundRectPanel(LayoutManager layout) {
        super(layout);
    }

    public RichRoundRectPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public RichRoundRectPanel() {
        this.setup();
    }

    public void setup() {
        SwingUtil.foreachChildComponent(this, this::setupComponent);
    }

    public void setupComponent(final Component component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (RichRoundRectPanel.this.hoverBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.hoverBackgoundColor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (RichRoundRectPanel.this.defaultBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.defaultBackgoundColor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RichRoundRectPanel.this.defaultBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.defaultBackgoundColor);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (RichRoundRectPanel.this.selectedBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.selectedBackgoundColor);
                }
            }
        });
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (RichRoundRectPanel.this.hoverBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.hoverBackgoundColor);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (RichRoundRectPanel.this.defaultBackgoundColor != null && component.isEnabled() && !RichRoundRectPanel.this.disableBackgoundColorEvent) {
                    RichRoundRectPanel.this.setBackground(RichRoundRectPanel.this.defaultBackgoundColor);
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        Dimension arcs = new Dimension(this.cornerRadius, this.cornerRadius);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (null != this.cornorBackgroundColor) {
            graphics.setColor(this.cornorBackgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        graphics.setPaint(this.getBackground());
        graphics.fillRoundRect(0, 0, width, height, arcs.width, arcs.height);
        this.paintChildren(graphics);
        if (this.roundLineBorder != null) {
            this.roundLineBorder.paintBorder(this, graphics, 0, 0, width, height);
        }
        if (this.needDrawRect) {
            graphics.setColor(ColorUtil.getToolWindowBackgroundColor());
            graphics.setStroke(new BasicStroke(3.0f, 0, 1, 0.0f, new float[]{4.0f, 2.0f}, 0.0f));
            graphics.drawRoundRect(0, 0, width, height, arcs.width, arcs.height);
        }
        graphics.dispose();
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.roundLineBorder = borderColor != null ? new RoundLineBorder(borderColor, 2, this.cornerRadius) : null;
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        if (!(this.getBackground() instanceof JBColor)) {
            return;
        }
        JBColor jbColor = (JBColor)this.getBackground();
        if (themeColor == null) {
            JBColor.setDark((boolean)true);
        } else {
            JBColor.setDark((boolean)false);
        }
    }

    @Generated
    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    @Generated
    public int getCornerRadius() {
        return this.cornerRadius;
    }

    @Generated
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Generated
    public Color getDefaultBackgoundColor() {
        return this.defaultBackgoundColor;
    }

    @Generated
    public void setDefaultBackgoundColor(Color defaultBackgoundColor) {
        this.defaultBackgoundColor = defaultBackgoundColor;
    }

    @Generated
    public Color getHoverBackgoundColor() {
        return this.hoverBackgoundColor;
    }

    @Generated
    public void setHoverBackgoundColor(Color hoverBackgoundColor) {
        this.hoverBackgoundColor = hoverBackgoundColor;
    }

    @Generated
    public Color getSelectedBackgoundColor() {
        return this.selectedBackgoundColor;
    }

    @Generated
    public void setSelectedBackgoundColor(Color selectedBackgoundColor) {
        this.selectedBackgoundColor = selectedBackgoundColor;
    }

    @Generated
    public boolean isNeedDrawRect() {
        return this.needDrawRect;
    }

    @Generated
    public void setNeedDrawRect(boolean needDrawRect) {
        this.needDrawRect = needDrawRect;
    }

    @Generated
    public boolean isDisableBackgoundColorEvent() {
        return this.disableBackgoundColorEvent;
    }

    @Generated
    public void setDisableBackgoundColorEvent(boolean disableBackgoundColorEvent) {
        this.disableBackgoundColorEvent = disableBackgoundColorEvent;
    }

    @Generated
    public Color getCornorBackgroundColor() {
        return this.cornorBackgroundColor;
    }

    @Generated
    public void setCornorBackgroundColor(Color cornorBackgroundColor) {
        this.cornorBackgroundColor = cornorBackgroundColor;
    }
}

