/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ToolbarLabel
extends JLabel {
    Icon image;
    Icon hoverImage;
    Icon selectImage;
    Consumer<MouseEvent> clickHandler;

    public ToolbarLabel(Icon image, Icon hoverImage, Icon selectImage) {
        this(image, hoverImage, selectImage, null);
    }

    public ToolbarLabel(final Icon image, final Icon hoverImage, Icon selectImage, Consumer<MouseEvent> handler) {
        super(image);
        this.image = image;
        this.hoverImage = hoverImage;
        this.selectImage = selectImage;
        this.clickHandler = handler;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (hoverImage != null) {
                    ToolbarLabel.this.setIcon(hoverImage);
                    ToolbarLabel.this.revalidate();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (hoverImage != null) {
                    ToolbarLabel.this.setIcon(image);
                    ToolbarLabel.this.revalidate();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ToolbarLabel.this.clickHandler != null) {
                    ToolbarLabel.this.clickHandler.accept(e);
                }
                ToolbarLabel.this.renderSelect();
            }
        });
    }

    public void renderSelect() {
        if (this.selectImage != null) {
            this.setIcon(this.selectImage);
            this.revalidate();
        }
    }

    public void setClickHandler(Consumer<MouseEvent> clickHandler) {
        this.clickHandler = clickHandler;
    }

    public void changeImageAfterSelection(Icon image) {
        this.setIcon(image);
        this.removeListeners();
    }

    public void invalid() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.removeListeners();
    }

    public void removeListeners() {
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    public void revalidateLabel() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setIcon(this.image);
        this.revalidate();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolbarLabel.this.setIcon(ToolbarLabel.this.hoverImage);
                ToolbarLabel.this.revalidate();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolbarLabel.this.setIcon(ToolbarLabel.this.image);
                ToolbarLabel.this.revalidate();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolbarLabel.this.clickHandler.accept(e);
            }
        });
    }
}

