/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component;

import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class VoteAcceptPanel
extends JPanel {
    public static final int DOC_LIST_STYLE = 0;
    public static final int DOC_ANSWER_STYLE = 1;
    public static final int DOC_QUESTION_STYLE = 2;
    private static final int TAG_HEIGHT = 24;
    private static final Color VOTE_TEXT_COLOR = new JBColor(new Color(3639110), new Color(6142589));
    private static final Color UNVOTE_TEXT_COLOR = new JBColor(new Color(16755009), new Color(16755009));
    private static final Color NUMBER_TEXT_COLOR = new JBColor(new Color(0), new Color(0xBBBBBB));
    private static final Color NORMAL_TEXT_COLOR = new JBColor(new Color(0x808080), new Color(13487823));
    private static final Color TRANSPARENT_BG_COLOR = new JBColor(new Color(0xC4C4C4, true), new Color(5132884, true));
    private static final int LABEL_LEFTRIGHT_PADDING = 8;
    private static final int LABEL_TOPBOTTOM_PADDING = 4;
    private static final int PANEL_ROUND_CORNER = 5;
    Long voteCount;
    Long answerCount;
    Boolean hasAccepted;
    String authorName;
    String datetime;
    private List<DisplayLabel> labels = new ArrayList<DisplayLabel>();
    private DisplayLabel dotLabel;
    int layoutStyle = 0;

    public VoteAcceptPanel() {
    }

    public VoteAcceptPanel(Long voteCount, Long answerCount, Boolean hasAccepted) {
        this(voteCount, answerCount, hasAccepted, null, 0);
    }

    public VoteAcceptPanel(Long voteCount, Long answerCount, Boolean hasAccepted, String authorName, int layoutStyle) {
        this.voteCount = voteCount;
        this.answerCount = answerCount;
        this.hasAccepted = hasAccepted;
        this.authorName = authorName;
        this.layoutStyle = layoutStyle;
        this.initUI();
    }

    public void initUI() {
        this.setBackground(new Color(0, 0, 0, 0));
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.layoutLabel();
        this.setupUI();
    }

    private void layoutLabel() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        ColorHolder colorHolder = new ColorHolder(this.layoutStyle);
        if (!colorHolder.isValid()) {
            return;
        }
        if (this.hasAccepted != null && this.hasAccepted.booleanValue()) {
            DisplayLabel label = this.addLabel("", color == null ? CommonIcons.lightAcceptIcon : CommonIcons.acceptIcon, colorHolder.normalColor);
            label.setToolTipText(I18NConstant.ACCEPT_TEXT);
            this.addDotLabel(colorHolder.normalColor);
        }
        this.layoutVote(colorHolder);
        if (this.answerCount != null) {
            DisplayLabel answerLabel = this.addLabel(I18NConstant.ANSWER_TEXT, null, colorHolder.normalColor);
            answerLabel.setBundleKey("answer.label.txt");
            this.addEmptyLabel(colorHolder.normalColor);
            this.addLabel(StringUtils.convertShortNumber(this.answerCount), null, colorHolder.normalNumberColor);
            this.addDotLabel(colorHolder.normalColor);
        }
        if (this.authorName != null) {
            this.addLabel(this.authorName, null, colorHolder.normalColor);
            this.addDotLabel(colorHolder.normalColor);
        }
        if (this.datetime != null) {
            this.addLabel(this.datetime, null, colorHolder.normalColor);
        }
    }

    private void layoutVote(ColorHolder colorHolder) {
        String bundleKey;
        String voteText;
        this.voteCount = this.voteCount == null ? 0L : this.voteCount;
        if (this.voteCount > 0L || this.voteCount == 0L) {
            voteText = I18NConstant.VOTE_TEXT.strip();
            bundleKey = "vote.label.txt";
        } else {
            voteText = I18NConstant.UNVOTE_TEXT.strip();
            bundleKey = "un.vote.label.txt";
        }
        if (this.layoutStyle == 0 || this.layoutStyle == 1) {
            if (this.voteCount > 0L) {
                colorHolder.voteColor = VOTE_TEXT_COLOR;
                colorHolder.voteNumberColor = VOTE_TEXT_COLOR;
            } else if (this.voteCount == 0L) {
                colorHolder.voteColor = NORMAL_TEXT_COLOR;
                colorHolder.voteNumberColor = NORMAL_TEXT_COLOR;
            } else {
                colorHolder.voteColor = UNVOTE_TEXT_COLOR;
                colorHolder.voteNumberColor = UNVOTE_TEXT_COLOR;
            }
        }
        DisplayLabel voteLabel = this.addLabel(voteText, null, colorHolder.voteColor);
        voteLabel.setBundleKey(bundleKey);
        this.addEmptyLabel(colorHolder.voteColor);
        this.addLabel(StringUtils.convertShortNumber(Math.abs(this.voteCount)), null, colorHolder.voteNumberColor);
        this.addDotLabel(colorHolder.normalColor);
    }

    public void addDotLabel(Color textColor) {
        Color bgColor = this.getBackground() != null ? this.getBackground() : TRANSPARENT_BG_COLOR;
        this.dotLabel = new DisplayLabel("\u00b7", null, bgColor, textColor);
        this.dotLabel.setSeparator(true);
    }

    public void addEmptyLabel(Color textColor) {
        Color bgColor = this.getBackground() != null ? this.getBackground() : TRANSPARENT_BG_COLOR;
        this.dotLabel = new DisplayLabel("", null, bgColor, textColor);
        this.dotLabel.setSeparator(true);
    }

    public DisplayLabel addLabel(String text, Icon icon, Color textColor) {
        if (this.dotLabel != null) {
            this.labels.add(this.dotLabel);
            this.dotLabel = null;
        }
        Color bgColor = this.getBackground() != null ? this.getBackground() : TRANSPARENT_BG_COLOR;
        DisplayLabel label = new DisplayLabel(text, icon, bgColor, textColor);
        label.setSeparator(false);
        this.labels.add(label);
        return label;
    }

    private void setupUI() {
        Box container = Box.createHorizontalBox();
        for (int i = 0; i < this.labels.size(); ++i) {
            DisplayLabel label = this.labels.get(i);
            if (label.isSeparator()) {
                label.setBorder(BorderFactory.createEmptyBorder());
            } else {
                int borderLeft = 8;
                int borderRight = 8;
                if (i > 0 && this.labels.get(i - 1).isSeparator()) {
                    borderLeft = 4;
                }
                if (i < this.labels.size() - 1 && this.labels.get(i + 1).isSeparator()) {
                    borderRight = 4;
                }
                if (i == 0) {
                    borderLeft = 0;
                }
                label.setBorder((Border)JBUI.Borders.empty((int)4, (int)borderLeft, (int)4, (int)borderRight));
            }
            container.add(label);
        }
        this.add((Component)container, "Center");
    }

    public void updateUiTexts() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Box)) continue;
            for (Component component1 : ((Box)component).getComponents()) {
                DisplayLabel label;
                if (!(component1 instanceof DisplayLabel) || (label = (DisplayLabel)component1).getBundleKey() == null) continue;
                label.setText(CosyBundle.message(label.getBundleKey(), new Object[0]));
            }
        }
    }

    public void reset() {
        this.setAnswerCount(null);
        this.setAuthorName(null);
        this.setHasAccepted(null);
        this.setDotLabel(null);
        this.setVoteCount(null);
        this.setDatetime(null);
        this.removeAll();
        this.labels.clear();
    }

    @Generated
    public Long getVoteCount() {
        return this.voteCount;
    }

    @Generated
    public Long getAnswerCount() {
        return this.answerCount;
    }

    @Generated
    public Boolean getHasAccepted() {
        return this.hasAccepted;
    }

    @Generated
    public String getAuthorName() {
        return this.authorName;
    }

    @Generated
    public String getDatetime() {
        return this.datetime;
    }

    @Generated
    public List<DisplayLabel> getLabels() {
        return this.labels;
    }

    @Generated
    public DisplayLabel getDotLabel() {
        return this.dotLabel;
    }

    @Generated
    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    @Generated
    public void setVoteCount(Long voteCount) {
        this.voteCount = voteCount;
    }

    @Generated
    public void setAnswerCount(Long answerCount) {
        this.answerCount = answerCount;
    }

    @Generated
    public void setHasAccepted(Boolean hasAccepted) {
        this.hasAccepted = hasAccepted;
    }

    @Generated
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @Generated
    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    @Generated
    public void setLabels(List<DisplayLabel> labels) {
        this.labels = labels;
    }

    @Generated
    public void setDotLabel(DisplayLabel dotLabel) {
        this.dotLabel = dotLabel;
    }

    @Generated
    public void setLayoutStyle(int layoutStyle) {
        this.layoutStyle = layoutStyle;
    }

    static class ColorHolder {
        Color voteColor;
        Color normalColor;
        Color voteNumberColor;
        Color normalNumberColor;

        public ColorHolder(int layoutStyle) {
            switch (layoutStyle) {
                case 0: 
                case 1: {
                    this.voteColor = VOTE_TEXT_COLOR;
                    this.voteNumberColor = VOTE_TEXT_COLOR;
                    this.normalColor = NORMAL_TEXT_COLOR;
                    this.normalNumberColor = NORMAL_TEXT_COLOR;
                    break;
                }
                case 2: {
                    this.voteColor = CosyColor.GRAY_TXT_COLOR;
                    this.voteNumberColor = NUMBER_TEXT_COLOR;
                    this.normalColor = CosyColor.GRAY_TXT_COLOR;
                    this.normalNumberColor = NUMBER_TEXT_COLOR;
                    break;
                }
            }
        }

        public boolean isValid() {
            return this.voteColor != null && this.normalColor != null && this.voteNumberColor != null && this.normalNumberColor != null;
        }
    }
}

