/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat;

import com.alibabacloud.intellij.qoder.chat.model.ChatSessionContext;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.BaseChatTagButton;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatContextTagDragGestureListener;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicLabelUI;
import lombok.Generated;

public class ChatContextTagButton
extends BaseChatTagButton {
    public static final int DEFAULT_VERTICAL_PADDING = 2;
    public static final int DEFAULT_HORIZONTAL_PADDING = 4;
    public static final int DEFAULT_CORNER_RADIUS = 8;
    ChatContextTag tag;
    private JLabel label;
    private JLabel lineRangeLabel;
    private JLabel closeLabel;
    private ChatContextTagsPanel tagsPanel;
    Project project;
    private AtomicBoolean loading = new AtomicBoolean(false);

    public ChatContextTagButton(Project project, ChatContextTagsPanel tagsPanel, ChatContextTag tag, boolean enableDrag) {
        this(project, tagsPanel, tag, enableDrag, true);
    }

    public ChatContextTagButton(Project project, final ChatContextTagsPanel tagsPanel, ChatContextTag tag, boolean enableDrag, boolean needListeners) {
        super(new BorderLayout());
        this.project = project;
        this.tagsPanel = tagsPanel;
        this.tag = tag;
        this.setCornerRadius(8);
        this.setCornorBackgroundColor(tagsPanel.getBackground());
        this.label = new JLabel(tag.getText());
        this.label.setHorizontalAlignment(2);
        this.label.setFont(FontUtil.LABEL_TAG_SMALL_FONT);
        this.label.setIconTextGap(8);
        this.label.setUI(new CustomLabelUI());
        this.add((Component)this.label, "Center");
        Box rightBox = Box.createHorizontalBox();
        if (tag.getStatLine() != null && tag.getEndLine() != null) {
            rightBox.add(Box.createHorizontalStrut(2));
            this.lineRangeLabel = new JLabel(tag.getStatLine() + "-" + tag.getEndLine());
            this.lineRangeLabel.setHorizontalAlignment(0);
            this.lineRangeLabel.setFont(FontUtil.LABEL_TAG_SMALL_FONT);
            this.lineRangeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            rightBox.add(this.lineRangeLabel);
        }
        rightBox.add(Box.createHorizontalStrut(2));
        this.closeLabel = new JLabel(AllIcons.Actions.Close);
        this.closeLabel.setFont(FontUtil.LABEL_TAG_SMALL_FONT);
        this.closeLabel.setHorizontalAlignment(0);
        if (tagsPanel.getChatInputContext().getInputMainPanel() == null) {
            this.closeLabel.setVisible(false);
        }
        rightBox.add(this.closeLabel);
        this.add((Component)rightBox, "East");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
        this.setDefaultBackgoundColor(ColorUtil.getToolWindowBackgroundColor());
        this.setHoverBackgoundColor(ColorUtil.getItemSelectionBackground());
        this.setSelectedBackgoundColor(ColorUtil.getLinkForegroundColor());
        if (needListeners) {
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ChatContextTagButton.this.handleClick();
                }
            });
            this.closeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ChatContextTagButton.this.loading.get()) {
                        return;
                    }
                    tagsPanel.removeTag(ChatContextTagButton.this);
                    ChatSessionContext userData = (ChatSessionContext)ApplicationManager.getApplication().getUserData(CosyKey.CHAT_SESSION_CONTEXT);
                    if (null != userData) {
                        if (ChatContextTypeEnum.CODEBASE.getType().equals(ChatContextTagButton.this.tag.getType())) {
                            userData.setCodeBaseRemoved(true);
                        } else {
                            userData.setCurrentFileRemoved(true);
                        }
                    }
                }
            });
            this.setup();
            this.setupDrag(enableDrag);
            this.setupKeyListener(tagsPanel.getChatInputContext().getProject());
        }
    }

    private void setupDrag(boolean enableDrag) {
        if (!enableDrag) {
            return;
        }
        SwingUtil.foreachChildComponent(this, component -> {
            DragSource ds = new DragSource();
            ds.createDefaultDragGestureRecognizer((Component)component, 2, new ChatContextTagDragGestureListener(ds, this, this.tagsPanel.getChatInputContext()));
        });
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this.label.setIcon(icon);
            this.revalidate();
            this.repaint();
        }
    }

    public void setText(String text) {
        if (text != null) {
            this.label.setText(text);
            this.revalidate();
            this.repaint();
        }
    }

    public void setValid(boolean valid) {
        if (!valid) {
            this.label.setText("<html><body style='text-decoration: line-through;'>" + this.tag.getText() + "</body></html>");
            this.label.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        } else {
            this.label.setText(this.tag.getText());
            this.label.setForeground(ColorUtil.getLabelForegroundColor());
        }
        this.tag.setValid(valid);
        this.revalidate();
        this.repaint();
    }

    public void setLoading(boolean loading) {
        this.loading.getAndSet(loading);
        if (loading) {
            this.closeLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
        } else {
            this.closeLabel.setIcon(AllIcons.Actions.Close);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void handleClick() {
        ChatContextTypeEnum typeEnum = ChatContextTypeEnum.getByType(this.tag.getType());
        if (typeEnum != null && typeEnum.getProvider() != null) {
            typeEnum.getProvider().click(this.project, this.tag, this);
        }
    }

    @Override
    public void handleDelete() {
        for (int i = 0; i < this.tagsPanel.getComponentCount(); ++i) {
            Component component = this.tagsPanel.getComponent(i);
            if (component != this) continue;
            this.tagsPanel.focusTag(i - 1);
            break;
        }
        this.tagsPanel.removeTag(this);
    }

    @Generated
    public ChatContextTag getTag() {
        return this.tag;
    }

    @Generated
    public JLabel getLabel() {
        return this.label;
    }

    @Generated
    public JLabel getLineRangeLabel() {
        return this.lineRangeLabel;
    }

    @Generated
    public JLabel getCloseLabel() {
        return this.closeLabel;
    }

    @Generated
    public ChatContextTagsPanel getTagsPanel() {
        return this.tagsPanel;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public AtomicBoolean getLoading() {
        return this.loading;
    }

    static class CustomLabelUI
    extends BasicLabelUI {
        private static final int MARGIN_OFFSET = 8;

        CustomLabelUI() {
        }

        @Override
        protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
            String clipText = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
            int textLength = fontMetrics.stringWidth(text);
            if (textLength <= textR.width) {
                return clipText;
            }
            return FontUtil.clipString(fontMetrics, text, textR.width - 8, true);
        }
    }
}

