/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.qoder.service.ModelService;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatModelChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatModelListRefreshNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.ModelUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ChatModelChooser {
    private static final Logger LOG = Logger.getInstance(ChatModelChooser.class);
    private static final ChatModelItem LOGOUT_MODEL_ITEM = ((ChatModelItem.ChatModelItemBuilder)((ChatModelItem.ChatModelItemBuilder)ChatModelItem.builder().key("")).displayName("models")).build();
    private static final int MAX_DISPLAY_NAME_WIDTH = 200;
    public static final String USAGE_ANSWER_PANEL = "AnswerPanel";
    public static final String USAGE_OPERATION_PANEL = "OperationPanel";
    PrettyListPopup<ChatModelItem> popup;
    ModelSelectedLabel modelSelectedLabel;
    MessageBusConnection messageBusConnection;
    String sessionType;
    Project project;
    Color backgroundColor;
    Color foregroundColor;
    Color hoverColor;
    String usage;

    public ChatModelChooser(Project project, String sessionType) {
        this(project, sessionType, ColorUtil.getEditorBackgroundColor(), ColorUtil.getAuxiliaryForegroundColor(), ColorUtil.getButtonHoverBackgroundColor());
    }

    public ChatModelChooser(Project project, String sessionType, Color backgroundColor, Color foregroundColor, Color hoverColor) {
        this(project, sessionType, backgroundColor, foregroundColor, hoverColor, USAGE_OPERATION_PANEL);
    }

    public ChatModelChooser(Project project, String sessionType, Color backgroundColor, Color foregroundColor, Color hoverColor, String usage) {
        this.sessionType = sessionType;
        this.project = project;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.hoverColor = hoverColor;
        this.usage = usage;
        this.modelSelectedLabel = new ModelSelectedLabel(LOGOUT_MODEL_ITEM, backgroundColor);
        this.popup = new PrettyListPopup<ChatModelItem>(project, this::onModelSelected, 200);
        this.setupModelSelectEvent();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::onLogin);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::onLogout);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::onAuthStatusChange);
        this.messageBusConnection.subscribe(ChatModelListRefreshNotifier.CHAT_MODEL_LIST_REFRESH_NOTIFICATION, this::onRefreshModel);
        this.messageBusConnection.subscribe(ChatModelChangeNotifier.CHAT_MODEL_CHANGE_NOTIFICATION, this::changeModel);
        ThreadUtil.execute(() -> {
            AuthStatus status = LoginUtil.getAuthStatusCacheFirst(project);
            SwingUtilities.invokeLater(() -> this.onAuthStatusChange(status));
        });
    }

    private void changeModel(ChatModelItem chatModelItem, String usage) {
        if (!this.modelSelectedLabel.getModelItem().getKey().equals(chatModelItem.getKey())) {
            this.modelSelectedLabel.selectModel(chatModelItem);
            this.modelSelectedLabel.revalidate();
            this.modelSelectedLabel.repaint();
        }
    }

    public void dispose() {
        this.messageBusConnection.disconnect();
    }

    private void onAuthStatusChange(AuthStatus status) {
        LOG.info("start to change status: " + System.currentTimeMillis());
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.onLogin(status);
        } else {
            this.onLogout(status);
        }
    }

    private void onLogin(AuthStatus status) {
        ThreadUtil.execute(() -> {
            if (null != status && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
                LOG.info("start to init model: " + System.currentTimeMillis());
                ChatModelItem selectModel = ModelService.getInstance().getSelectionModelItem(this.project, this.sessionType);
                if (selectModel == null) {
                    selectModel = LOGOUT_MODEL_ITEM;
                }
                ChatModelItem finalSelectModel = selectModel;
                SwingUtilities.invokeLater(() -> {
                    this.modelSelectedLabel.selectModel(finalSelectModel);
                    if (finalSelectModel == LOGOUT_MODEL_ITEM) {
                        this.modelSelectedLabel.setVirtualEnabled(false);
                    } else {
                        this.modelSelectedLabel.setVirtualEnabled(true);
                    }
                    this.modelSelectedLabel.revalidate();
                    this.modelSelectedLabel.repaint();
                    LOG.info("init model succeed: " + System.currentTimeMillis());
                });
            }
        });
    }

    private void onLogout(AuthStatus status) {
        ModelService.getInstance().clearCache();
        this.modelSelectedLabel.selectModel(LOGOUT_MODEL_ITEM);
        this.modelSelectedLabel.setVirtualEnabled(false);
        this.modelSelectedLabel.revalidate();
        this.modelSelectedLabel.repaint();
    }

    public void onModelSelected(ChatModelItem modelItem) {
        if (modelItem == null) {
            return;
        }
        this.modelSelectedLabel.selectModel(modelItem);
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null) {
            cosySetting.getChatModelSelected().put(ModelService.buildModelKey(this.project, ModelUtil.convertSessionType(this.project, this.sessionType)), modelItem.getKey());
        }
        this.modelSelectedLabel.revalidate();
        this.modelSelectedLabel.repaint();
        if (USAGE_ANSWER_PANEL.equals(this.usage)) {
            ((ChatModelChangeNotifier)this.project.getMessageBus().syncPublisher(ChatModelChangeNotifier.CHAT_MODEL_CHANGE_NOTIFICATION)).changeModel(modelItem, this.usage);
        }
    }

    private void onRefreshModel(Map<String, List<ChatModelItem>> modelList) {
        ModelService modelService = ModelService.getInstance();
        modelService.updateModelMap(modelList);
        ChatModelItem selectModel = modelService.getSelectionModelItem(this.project, this.sessionType);
        if (selectModel != null) {
            LOG.info("onRefreshModel, select model is " + selectModel.getKey());
            this.modelSelectedLabel.setVirtualEnabled(true);
            this.onModelSelected(selectModel);
        } else {
            LOG.warn("onRefreshModel, cannot get config model for " + this.sessionType);
        }
    }

    private void setupModelSelectEvent() {
        this.modelSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ChatModelChooser.this.modelSelectedLabel.isVirtualEnabled()) {
                    return;
                }
                ChatModelChooser.this.showModelListPopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ChatModelChooser.this.modelSelectedLabel.isVirtualEnabled()) {
                    return;
                }
                ChatModelChooser.this.modelSelectedLabel.setForeground(ColorUtil.getTextPaneForegroundColor());
                ChatModelChooser.this.modelSelectedLabel.setBackgroundColor(ChatModelChooser.this.hoverColor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ChatModelChooser.this.modelSelectedLabel.isVirtualEnabled()) {
                    return;
                }
                ChatModelChooser.this.modelSelectedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                ChatModelChooser.this.modelSelectedLabel.setBackgroundColor(ChatModelChooser.this.backgroundColor);
            }
        });
    }

    public void showModelListPopup() {
        List<ChatModelItem> list = ModelService.getInstance().getModelList(this.project, ModelUtil.convertSessionType(this.project, this.sessionType));
        if (list == null) {
            LOG.warn("get model list failed for " + this.sessionType);
            return;
        }
        int selectIndex = 0;
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && cosySetting.getChatModelSelected() != null) {
            String configModelKey = cosySetting.getChatModelSelected().get(ModelService.buildModelKey(this.project, ModelUtil.convertSessionType(this.project, this.sessionType)));
            LOG.info("get config model key for " + this.sessionType + " is " + configModelKey);
            if (StringUtils.isNotBlank((CharSequence)configModelKey)) {
                for (int i = 0; i < list.size(); ++i) {
                    ChatModelItem item = list.get(i);
                    if (!item.getKey().equals(configModelKey)) continue;
                    selectIndex = i;
                    break;
                }
            }
        }
        this.popup.showAbove(this.modelSelectedLabel, list, selectIndex);
    }

    public JComponent getBaseComponent() {
        return this.modelSelectedLabel;
    }

    @Generated
    public ModelSelectedLabel getModelSelectedLabel() {
        return this.modelSelectedLabel;
    }

    public static class ModelSelectedLabel
    extends RoundRectLabel {
        public static final int DEFAULT_VERTICAL_PADDING = 0;
        public static final int DEFAULT_HORIZONTAL_PADDING = 2;
        public static final int DEFAULT_HORIZONTAL_MARGIN = 0;
        public static final int DEFAULT_CORNER_RADIUS = 8;
        private static final int MAX_WIDTH = 150;
        ChatModelItem modelItem;
        private boolean enabled = false;

        public ModelSelectedLabel(ChatModelItem modelItem) {
            this(modelItem, ColorUtil.getEditorBackgroundColor());
        }

        public ModelSelectedLabel(ChatModelItem modelItem, Color backgroundColor) {
            super(modelItem.getDisplayName(), backgroundColor, 2, 0, 8, 0);
            this.modelItem = modelItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modelItem.getDisplayName(), 150, false);
            this.setText(newText);
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setIcon(AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.setIconTextGap(2);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setHorizontalTextPosition(2);
            this.setFont(this.getFont().deriveFont(12.0f));
            this.setBackground(backgroundColor);
            this.setAlignmentY(0.5f);
        }

        public void selectModel(ChatModelItem modelItem) {
            this.modelItem = modelItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modelItem.getDisplayName(), 150, false);
            this.setText(newText);
        }

        public void setVirtualEnabled(boolean enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.setForeground(ColorUtil.getInactiveForegroundColor());
            } else {
                this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            }
        }

        public boolean isVirtualEnabled() {
            return this.enabled;
        }

        @Generated
        public ChatModelItem getModelItem() {
            return this.modelItem;
        }
    }
}

