/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatStageContext;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatStageParser;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceChunk;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceDocItem;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceItem;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ChatReferenceParser
implements ChatStageParser {
    private static final Logger log = Logger.getInstance(ChatReferenceParser.class);

    @Override
    public void parse(ChatStageContext ctx, ChatStep stepItem) {
        if (!ChatStepStatusEnum.DONE.getKey().equals(stepItem.getStatus())) {
            return;
        }
        if (ChatStepEnum.DETERMINING_CODEBASE.getKey().equals(stepItem.getStep())) {
            Object result = stepItem.getResult();
            ChatReferenceChunk chunk = (ChatReferenceChunk)JSON.parseObject((String)JSON.toJSONString((Object)result), ChatReferenceChunk.class);
            DefaultListModel<ChatReferenceItem> listModel = new DefaultListModel<ChatReferenceItem>();
            if (chunk == null || chunk.getChunks() == null) {
                log.warn("ChatReferenceChunk is null. stepItem=" + JSON.toJSONString((Object)stepItem));
                return;
            }
            for (ChatReferenceItem item : chunk.getChunks()) {
                item.setType(ChatStageParseKey.CODE_CHUNK.getKey());
                listModel.addElement(item);
            }
            ctx.addContext(ChatStageParseKey.CODE_CHUNK.getKey(), listModel);
        } else if (ChatStepEnum.RETRIEVE_RELEVANT_INFO.getKey().equals(stepItem.getStep())) {
            Object result = stepItem.getResult();
            List<ChatReferenceDocItem> docs = new ArrayList<ChatReferenceDocItem>();
            if (result != null) {
                docs = JSONArray.parseArray((String)JSON.toJSONString((Object)result), ChatReferenceDocItem.class);
            }
            if (CollectionUtils.isEmpty(docs)) {
                if (StringUtils.isNotBlank((CharSequence)stepItem.getMessage())) {
                    ctx.addContext(ChatStageParseKey.MESSAGE.getKey(), stepItem.getMessage());
                }
                return;
            }
            DefaultListModel<ChatReferenceItem> listModel = ChatReferenceParser.transferDocItemToReferenceItem(docs);
            ctx.addContext(ChatStageParseKey.DOC_CHUNK.getKey(), listModel);
        }
    }

    public static DefaultListModel<ChatReferenceItem> transferDocItemToReferenceItem(List<ChatReferenceDocItem> chatReferenceDocItems) {
        DefaultListModel<ChatReferenceItem> listModel = new DefaultListModel<ChatReferenceItem>();
        if (CollectionUtils.isEmpty(chatReferenceDocItems)) {
            return listModel;
        }
        Map<String, List<ChatReferenceDocItem>> docMap = chatReferenceDocItems.stream().collect(Collectors.groupingBy(ChatReferenceDocItem::getFileId));
        for (String key : docMap.keySet()) {
            List<ChatReferenceDocItem> docs = docMap.get(key);
            for (int index = 0; index < docs.size(); ++index) {
                ChatReferenceDocItem docItem = docs.get(index);
                ChatReferenceItem chatReferenceItem = ChatReferenceParser.getChatReferenceItem(docItem, index);
                listModel.addElement(chatReferenceItem);
            }
        }
        return listModel;
    }

    @NotNull
    private static ChatReferenceItem getChatReferenceItem(ChatReferenceDocItem docItem, int index) {
        String knowledgeBaseName = docItem.getKnowledgeBaseName();
        String filePath = "\u4f01\u4e1a\u77e5\u8bc6\u5e93";
        if (StringUtils.isNotBlank((CharSequence)knowledgeBaseName)) {
            filePath = knowledgeBaseName;
        }
        ChatReferenceItem chatReferenceItem = new ChatReferenceItem(filePath, null, null);
        chatReferenceItem.setType(ChatStageParseKey.DOC_CHUNK.getKey());
        chatReferenceItem.setIcon(QoderIcons.FileGreyIcon);
        chatReferenceItem.setSectionNumber(index + 1);
        chatReferenceItem.setFileName(docItem.getFileName());
        chatReferenceItem.setPageContent(docItem.getPageContent());
        ChatReferenceItem chatReferenceItem2 = chatReferenceItem;
        if (chatReferenceItem2 == null) {
            ChatReferenceParser.$$$reportNull$$$0(0);
        }
        return chatReferenceItem2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/ui/search/component/chat/ChatReferenceParser", "getChatReferenceItem"));
    }
}

