/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.BaseChatStageComponent;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ChatStageComponent
extends BaseChatStageComponent {
    private static final int MARGIN = 8;
    ChatStep stepItem;
    JLabel textLabel;
    JLabel statusLabel;
    private static final int COSY_GENERATE_TIMEOUT = 20;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();

    public ChatStageComponent(ChatStep stepItem) {
        this.stepItem = stepItem;
        this.chatStep = stepItem;
        this.setup();
    }

    private void setup() {
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.textLabel = new JLabel(this.stepItem.getDescription());
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusLabel = new JLabel();
        this.updateItem(this.stepItem);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.textLabel);
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
    }

    @Override
    public void updateItem(ChatStep stepItem) {
        this.stepItem = stepItem;
        if (ChatStepStatusEnum.DOING.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            this.scheduleStepTimeout(this.statusLabel);
        } else if (ChatStepStatusEnum.DONE.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(QoderIcons.SuccessGreenIcon);
        } else if (ChatStepStatusEnum.ERROR.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(QoderIcons.ErrorRedIcon);
        }
    }

    private void scheduleStepTimeout(JLabel statusLabel) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (statusLabel != null && QoderIcons.StatusBarLoadingIcon.equals(statusLabel.getIcon())) {
                statusLabel.setIcon(QoderIcons.ErrorRedIcon);
            }
        }, 20L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (!ChatStepStatusEnum.DONE.getKey().equals(this.stepItem.getStatus())) {
            this.stepItem.setStatus(ChatStepStatusEnum.ERROR.getKey());
            this.updateItem(this.stepItem);
        }
    }

    @Override
    public boolean shouldRemoveAfterEndStep() {
        return ChatStepEnum.DETERMINING_CODEBASE.getKey().equals(this.stepItem.getStep()) || ChatStepEnum.RETRIEVE_RELEVANT_INFO.getKey().equals(this.stepItem.getStep()) || ChatStepEnum.REFINE_QUERY.getKey().equals(this.stepItem.getStep()) || ChatStepEnum.COLLECTING_WORKSPACE_TREE.getKey().equals(this.stepItem.getStep());
    }
}

