/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModeItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.qoder.service.ModeService;
import com.alibabacloud.intellij.qoder.service.ModelService;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatContextTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatMode;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputOperationPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatModeChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ExperimentalFeaturesRefreshNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChatModeChooser {
    private static final Logger LOG = Logger.getInstance(ChatModeChooser.class);
    private static final ChatModeItem LOGOUT_MODEL_ITEM = ((ChatModeItem.ChatModeItemBuilder)ChatModeItem.builder().mode(ChatMode.MODES.getMode())).build();
    private static final int MAX_DISPLAY_NAME_WIDTH = 80;
    PrettyListPopup<ChatModeItem> popup;
    ModeSelectedLabel modeSelectedLabel;
    MessageBusConnection messageBusConnection;
    Project project;
    AskInputPanel askInputPanel;

    public ChatModeChooser(Project project, AskInputPanel askInputPanel) {
        this.project = project;
        this.askInputPanel = askInputPanel;
        this.modeSelectedLabel = new ModeSelectedLabel(LOGOUT_MODEL_ITEM);
        this.popup = new PrettyListPopup<ChatModeItem>(project, this::onModeSelected, 80);
        this.setupModeSelectEvent();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::onLogin);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::onLogout);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::onAuthStatusChange);
        this.messageBusConnection.subscribe(ExperimentalFeaturesRefreshNotifier.CHAT_MODE_DEFAULT_REFRESH_NOTIFICATION, this::onRefreshMode);
        this.messageBusConnection.subscribe(ChatModeChangeNotifier.CHAT_MODE_CHANGE_NOTIFICATION, this::onModeSelected);
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        ThreadUtil.execute(() -> {
            AuthStatus status = LoginUtil.getAuthStatusCacheFirst(project);
            SwingUtilities.invokeLater(() -> this.onAuthStatusChange(status));
        });
    }

    private void updateUiTexts() {
        this.modeSelectedLabel.setText(FontUtil.getStringAdaptiveWidth(this.modeSelectedLabel, this.modeSelectedLabel.modeItem.getDisplayName(), 150, false));
        this.modeSelectedLabel.setToolTipText(CosyBundle.message("chat.mode.tooltip", new Object[0]));
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    public void dispose() {
        this.messageBusConnection.disconnect();
    }

    private void onAuthStatusChange(AuthStatus status) {
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.onLogin(status);
        } else {
            this.onLogout(status);
        }
    }

    private void onLogin(AuthStatus status) {
        ThreadUtil.execute(() -> {
            if (null != status && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
                ChatModeItem selectMode = ModeService.getInstance().getSelectionModeItem(this.project);
                if (selectMode == null) {
                    selectMode = LOGOUT_MODEL_ITEM;
                }
                ChatModeItem finalSelectMode = selectMode;
                SwingUtilities.invokeLater(() -> {
                    this.modeSelectedLabel.selectMode(finalSelectMode);
                    this.modeSelectedLabel.setVirtualEnabled(finalSelectMode != LOGOUT_MODEL_ITEM);
                    this.modeSelectedLabel.revalidate();
                    this.modeSelectedLabel.repaint();
                });
            }
        });
    }

    private void onLogout(AuthStatus status) {
        this.modeSelectedLabel.selectMode(LOGOUT_MODEL_ITEM);
        this.modeSelectedLabel.setVirtualEnabled(false);
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    public void onModeSelected(ChatModeItem modeItem) {
        String toMode;
        if (modeItem == null) {
            return;
        }
        String fromMode = ChatModeItem.getModeByDisplayName(this.modeSelectedLabel.getText());
        if (fromMode.equals(toMode = modeItem.getMode())) {
            LOG.info("mode is same, no need to change");
            return;
        }
        this.modeSelectedLabel.selectMode(modeItem);
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null) {
            cosySetting.getChatModeSelected().put(this.project.getPresentableUrl(), modeItem.getMode());
        }
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
        if (ChatMode.AGENT.getMode().equals(toMode) && null != this.askInputPanel && null != this.askInputPanel.getInputTagsPanel()) {
            this.askInputPanel.getInputTagsPanel().removeTagsOfTypes(Sets.newHashSet((Object[])new ChatContextTypeEnum[]{ChatContextTypeEnum.CURRENT_FILE}));
        }
        if (null != this.askInputPanel) {
            ChatInputOperationPanel inputOperationPanel = this.askInputPanel.getInputOperationPanel();
            if (null != inputOperationPanel) {
                ChatModelItem modelItem = ModelService.getInstance().getSelectionModelItem(this.project, SessionTypeEnum.ASSISTANT.getType());
                inputOperationPanel.getModelChooser().onModelSelected(modelItem);
            }
            this.askInputPanel.setTextAreaPlaceholder();
        }
        TelemetryService.getInstance().telemetryChatModeSwitch(this.project, UUID.randomUUID().toString(), UUID.randomUUID().toString(), fromMode, toMode, SessionTypeEnum.ASSISTANT.getTelemetryType());
    }

    public void onRefreshMode() {
        ChatModeItem selectMode = ModeService.getInstance().getSelectionModeItem(this.project);
        if (selectMode != null) {
            LOG.info("onRefreshMode, select mode is " + selectMode.getMode());
            this.modeSelectedLabel.setVirtualEnabled(true);
            this.onModeSelected(selectMode);
        } else {
            LOG.warn("onRefreshMode, cannot get config mode");
        }
    }

    private void setupModeSelectEvent() {
        this.modeSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ChatModeChooser.this.modeSelectedLabel.isVirtualDisable()) {
                    return;
                }
                ChatModeChooser.this.showModeListPopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ChatModeChooser.this.modeSelectedLabel.isVirtualDisable()) {
                    return;
                }
                ChatModeChooser.this.modeSelectedLabel.setForeground(ColorUtil.getTextPaneForegroundColor());
                ChatModeChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getButtonHoverBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ChatModeChooser.this.modeSelectedLabel.isVirtualDisable()) {
                    return;
                }
                ChatModeChooser.this.modeSelectedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                ChatModeChooser.this.modeSelectedLabel.setBackgroundColor(ColorUtil.getEditorBackgroundColor());
            }
        });
    }

    public void showModeListPopup() {
        String lastSelectedChatMode;
        List<ChatModeItem> list = ModeService.getInstance().getModeList();
        int selectIndex = 0;
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && (lastSelectedChatMode = cosySetting.getChatModeSelected().get(this.project.getPresentableUrl())) != null) {
            for (int i = 0; i < list.size(); ++i) {
                ChatModeItem item = list.get(i);
                if (!item.getMode().equals(lastSelectedChatMode)) continue;
                selectIndex = i;
                break;
            }
        }
        this.popup.showAbove(this.modeSelectedLabel, list, selectIndex);
    }

    public JComponent getBaseComponent() {
        return this.modeSelectedLabel;
    }

    static class ModeSelectedLabel
    extends RoundRectLabel {
        public static final int DEFAULT_VERTICAL_PADDING = 0;
        public static final int DEFAULT_HORIZONTAL_PADDING = 2;
        public static final int DEFAULT_HORIZONTAL_MARGIN = 0;
        public static final int DEFAULT_CORNER_RADIUS = 8;
        private static final int MAX_WIDTH = 150;
        ChatModeItem modeItem;
        private boolean enabled = false;

        public ModeSelectedLabel(ChatModeItem modeItem) {
            super(modeItem.getDisplayName(), ColorUtil.getEditorBackgroundColor(), 2, 0, 8, 0);
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setIcon(AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.setIconTextGap(2);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setHorizontalTextPosition(2);
            this.setFont(this.getFont().deriveFont(12.0f));
            this.setToolTipText(CosyBundle.message("chat.mode.tooltip", new Object[0]));
            this.setBackground(ColorUtil.getEditorBackgroundColor());
            this.setAlignmentY(0.5f);
        }

        public void selectMode(ChatModeItem modeItem) {
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
        }

        public void setVirtualEnabled(boolean enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.setForeground(ColorUtil.getInactiveForegroundColor());
            } else {
                this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            }
        }

        public boolean isVirtualDisable() {
            return !this.enabled;
        }
    }
}

