/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ToolAutoRunModeItem;
import com.alibabacloud.intellij.qoder.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.ChatModeChooser;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import lombok.Generated;

public class ToolAutoRunChooser {
    private static final Logger LOG = Logger.getInstance(ChatModeChooser.class);
    public static final ToolAutoRunModeItem ITEM_ASK_EVERYTIME = ToolAutoRunModeItem.builder().mode(ToolAutoRunEnum.ASK_EVERYTIME).build();
    public static final ToolAutoRunModeItem ITEM_ENABLE_AUTO_RUN = ToolAutoRunModeItem.builder().mode(ToolAutoRunEnum.ENABLE_AUTO_RUN).build();
    private static final List<ToolAutoRunModeItem> MODES = Arrays.asList(ITEM_ASK_EVERYTIME, ITEM_ENABLE_AUTO_RUN);
    private static final int MAX_DISPLAY_NAME_WIDTH = 100;
    PrettyListPopup<ToolAutoRunModeItem> popup;
    ModeSelectedLabel modeSelectedLabel;
    Project project;
    private final Function<ToolAutoRunModeItem, Boolean> switchChecker;

    public ToolAutoRunChooser(Project project, Function<ToolAutoRunModeItem, Boolean> selectChecker) {
        this.project = project;
        this.modeSelectedLabel = new ModeSelectedLabel(ITEM_ASK_EVERYTIME);
        this.popup = new PrettyListPopup<ToolAutoRunModeItem>(project, this::onModeSelected, 100);
        this.setupModeSelectEvent();
        this.switchChecker = selectChecker;
        if (null != project && !project.isDisposed()) {
            MessageBusConnection messageBusConnection = project.getMessageBus().connect();
            messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        }
    }

    private void updateUiTexts() {
        this.modeSelectedLabel.setText(this.modeSelectedLabel.modeItem.getDisplayName());
    }

    public void dispose() {
    }

    public void onModeSelected(ToolAutoRunModeItem modeItem) {
        if (modeItem == null) {
            return;
        }
        if (this.modeSelectedLabel.modeItem.getMode() == modeItem.getMode()) {
            LOG.info("mode is same, no need to change");
            return;
        }
        if (null != this.switchChecker && !this.switchChecker.apply(modeItem).booleanValue()) {
            LOG.info("switchChecker return false, no need to change");
            return;
        }
        this.modeSelectedLabel.selectMode(modeItem);
        this.modeSelectedLabel.revalidate();
        this.modeSelectedLabel.repaint();
    }

    private void setupModeSelectEvent() {
        this.modeSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolAutoRunChooser.this.showModeListPopup();
            }
        });
    }

    public void showModeListPopup() {
        this.popup.showAbove(this.modeSelectedLabel, MODES, MODES.indexOf(this.modeSelectedLabel.getModeItem()));
    }

    public JComponent getBaseComponent() {
        return this.modeSelectedLabel;
    }

    @Generated
    public ModeSelectedLabel getModeSelectedLabel() {
        return this.modeSelectedLabel;
    }

    public static class ModeSelectedLabel
    extends RoundRectLabel {
        public static final int DEFAULT_VERTICAL_PADDING = 0;
        public static final int DEFAULT_HORIZONTAL_PADDING = 2;
        public static final int DEFAULT_HORIZONTAL_MARGIN = 0;
        public static final int DEFAULT_CORNER_RADIUS = 8;
        private static final int MAX_WIDTH = 150;
        ToolAutoRunModeItem modeItem;

        public ModeSelectedLabel(ToolAutoRunModeItem modeItem) {
            super(modeItem.getDisplayName(), ColorUtil.getEditorBackgroundColor(), 2, 0, 0, 0);
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
            this.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.setIcon(AllIcons.Actions.FindAndShowNextMatchesSmall);
            this.setIconTextGap(2);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setHorizontalTextPosition(2);
            this.setFont(this.getFont().deriveFont(12.0f));
            this.setBackground(ColorUtil.getEditorBackgroundColor());
            this.setAlignmentY(0.5f);
        }

        public void selectMode(ToolAutoRunModeItem modeItem) {
            this.modeItem = modeItem;
            String newText = FontUtil.getStringAdaptiveWidth(this, modeItem.getDisplayName(), 150, false);
            this.setText(newText);
        }

        @Generated
        public ToolAutoRunModeItem getModeItem() {
            return this.modeItem;
        }
    }
}

