/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.inputfield;

import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.ActionSelectListener;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.qoder.ui.search.enums.TextFieldActionEnum;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;

public class SearchActionPanel
extends JPanel {
    static PopupAction searchAction = new PopupAction("Search", TextFieldActionEnum.SEARCH_ACTION.getName(), CommonIcons.searchIcon);
    List<PopupAction> popupActions = new ArrayList<PopupAction>();
    PopupAction defaultAction;
    JLabel content;
    JBPopup popup;
    List<ActionSelectListener> listeners = new ArrayList<ActionSelectListener>();
    PopupAction selectedValue;
    SearchBar searchBar;

    public SearchActionPanel(SearchBar searchBar) {
        this.searchBar = searchBar;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground((Color)SearchBar.SEARCHBAR_BG_COLOR);
        this.setLayout(new BorderLayout());
        this.buildPopupActions();
        this.content = new JLabel(this.defaultAction.getDisplayIcon());
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)this.content, "Center");
        this.selectedValue = this.defaultAction;
    }

    private void buildPopupActions() {
        this.popupActions.add(searchAction);
        this.defaultAction = searchAction;
        Project project = this.searchBar.getProject();
        if (project == null) {
            project = ProjectUtil.guessCurrentProject((JComponent)((Object)this.searchBar));
        }
    }

    public void addActionSelectListener(ActionSelectListener listener) {
        this.listeners.add(listener);
    }

    public PopupAction getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String actionType) {
        for (PopupAction action : this.popupActions) {
            if (!action.getType().equals(actionType)) continue;
            this.content.setIcon(action.getDisplayIcon());
            this.selectedValue = action;
            break;
        }
    }

    @Generated
    public List<ActionSelectListener> getListeners() {
        return this.listeners;
    }

    public static class PopupAction {
        String displayText;
        String type;
        Icon displayIcon;

        @Generated
        public String getDisplayText() {
            return this.displayText;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Icon getDisplayIcon() {
            return this.displayIcon;
        }

        @Generated
        public void setDisplayText(String displayText) {
            this.displayText = displayText;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setDisplayIcon(Icon displayIcon) {
            this.displayIcon = displayIcon;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PopupAction)) {
                return false;
            }
            PopupAction other = (PopupAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayText = this.getDisplayText();
            String other$displayText = other.getDisplayText();
            if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Icon this$displayIcon = this.getDisplayIcon();
            Icon other$displayIcon = other.getDisplayIcon();
            return !(this$displayIcon == null ? other$displayIcon != null : !this$displayIcon.equals(other$displayIcon));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PopupAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayText = this.getDisplayText();
            result = result * 59 + ($displayText == null ? 43 : $displayText.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Icon $displayIcon = this.getDisplayIcon();
            result = result * 59 + ($displayIcon == null ? 43 : $displayIcon.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SearchActionPanel.PopupAction(displayText=" + this.getDisplayText() + ", type=" + this.getType() + ", displayIcon=" + this.getDisplayIcon() + ")";
        }

        @Generated
        public PopupAction(String displayText, String type, Icon displayIcon) {
            this.displayText = displayText;
            this.type = type;
            this.displayIcon = displayIcon;
        }
    }
}

