/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.inputfield;

import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.qoder.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.search.result.SearchValue;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.ActionSelectListener;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.ImagePanel;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchActionPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchInputField;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchKeyword;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchKeywordPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.TextFieldActionEnum;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnySearchNotifier;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import lombok.Generated;

public class SearchBar
extends JBPanel {
    public static final int SEARCHBAR_INIT_HEIGHT = 35;
    public static final int KEYWORD_VGAP_SIZE = 2;
    public static final int KEYWORD_HGAP_SIZE = 5;
    public static final int KEYWORD_HEIGHT = 31;
    public static final String TEXTFIELD_REWRITE_FLAG = "cosy.searchbar.textfield.rewrite";
    public static final String TEXTFIELD_REWRITE_INDEX = "cosy.searchbar.textfield.rewrite.index";
    public static final JBColor SEARCHBAR_BG_COLOR = new JBColor(new Color(255, 255, 255), new Color(48, 53, 55));
    public static final JBColor SEARCHBAR_BORDER_COLOR = new JBColor(new Color(232, 232, 232), new Color(48, 53, 55));
    protected static final int IGNORE_TEXTFIELD_INDEX = -1;
    protected static final int SEARCH_ICON_WIDTH = 30;
    protected static final int CLEAR_ICON_WIDTH = 30;
    SearchInputField textField;
    JTextComponent textComponent;
    FocusListener textFieldFocusListener;
    DocumentListener textFieldDocumentListener;
    KeyListener textFieldKeyListener;
    SearchActionPanel actionPanel;
    SearchKeywordPanel keywordPanel;
    JBScrollPane keywordMainPanel;
    JPanel operPanel;
    ImagePanel searchIconPanel;
    ImagePanel closeIconPanel;
    Project project;
    JBPopup editorPopup;

    public SearchBar() {
        this.setMinimumSize(new Dimension(-1, 35));
        this.initUI();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SearchBar.this.textField != null) {
                    SearchBar.this.textField.adaptTextFieldWidth();
                }
            }
        });
        this.initActionChoosePanel();
        this.initKeywordPanel();
        this.initOperationPanel();
        this.setBorder((Border)new RoundedLineBorder((Color)SEARCHBAR_BORDER_COLOR, 4, 2));
        this.setBackground((Color)SEARCHBAR_BG_COLOR);
    }

    private void initActionChoosePanel() {
        this.actionPanel = new SearchActionPanel(this);
        this.actionPanel.setBorder(JBUI.Borders.customLine((Color)SEARCHBAR_BORDER_COLOR, (int)0, (int)0, (int)0, (int)1));
        this.add(this.actionPanel, "West");
    }

    private void initKeywordPanel() {
        this.keywordPanel = new SearchKeywordPanel(this);
        this.keywordMainPanel = new JBScrollPane((Component)this.keywordPanel);
        this.keywordMainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.keywordMainPanel.setVerticalScrollBarPolicy(21);
        this.keywordMainPanel.setHorizontalScrollBarPolicy(30);
        this.add((Component)this.keywordMainPanel, "Center");
    }

    private void initOperationPanel() {
        Icon closeIcon;
        Icon searchIcon;
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        if (color == null) {
            searchIcon = CommonIcons.lightSearchIcon;
            closeIcon = CommonIcons.lightCloseFillIcon;
        } else {
            searchIcon = CommonIcons.searchIcon;
            closeIcon = CommonIcons.closeFillIcon;
        }
        this.operPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = SearchBar.this.keywordPanel.getPreferredSize().height;
                return dimension;
            }
        };
        this.operPanel.setLayout(new BorderLayout());
        this.operPanel.setBackground((Color)SEARCHBAR_BG_COLOR);
        this.searchIconPanel = new ImagePanel(this.keywordPanel, searchIcon, 30);
        this.closeIconPanel = new ImagePanel(this.keywordPanel, closeIcon, 30);
        this.closeIconPanel.setVisible(false);
        this.operPanel.add((Component)this.closeIconPanel, "West");
        this.closeIconPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SearchBar.this.project != null) {
                    SearchContext context = new SearchContext(OperationEnum.CLEAR_ALL.text, SearchActionTypeEnum.DELETE_LABEL_TRIGGER.getType());
                    ((AnySearchNotifier)SearchBar.this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, null);
                }
            }
        });
        this.add(this.operPanel, "East");
    }

    public void initComponents(Project project) {
        this.project = project;
        this.initTextField();
    }

    private void initTextField() {
        this.initTextField(-1, false);
    }

    private void initTextField(int index, boolean rewrite) {
        if (this.actionPanel.getSelectedValue().getType().equals(TextFieldActionEnum.GENERATE_ACTION.getName())) {
            this.textComponent = new SearchInputTextArea(this);
        } else {
            this.textField = new SearchInputField(this);
            this.textComponent = this.textField;
        }
        if (this.textFieldFocusListener != null) {
            this.textComponent.addFocusListener(this.textFieldFocusListener);
        }
        if (this.textFieldDocumentListener != null) {
            this.textComponent.getDocument().addDocumentListener(this.textFieldDocumentListener);
        }
        if (this.textFieldKeyListener != null) {
            this.textComponent.addKeyListener(this.textFieldKeyListener);
        }
        this.textComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchBar.this.keywordPanel.setFlowLayout(true);
                SearchBar.this.keywordPanel.togglePromptText(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchBar.this.keywordPanel.setFlowLayout(false);
                if ("".equals(SearchBar.this.textComponent.getText()) && SearchBar.this.getSearchValueCount() == 0) {
                    SearchBar.this.keywordPanel.togglePromptText(true);
                }
            }
        });
        this.textComponent.putClientProperty(TEXTFIELD_REWRITE_FLAG, rewrite);
        if (rewrite) {
            this.textComponent.putClientProperty(TEXTFIELD_REWRITE_INDEX, index);
        }
        if (index >= 0) {
            this.keywordPanel.add((Component)this.textComponent, index);
        } else {
            this.keywordPanel.add(this.textComponent);
        }
        this.textComponent.requestFocus();
    }

    public void addKeyword(SearchKeyword keyword) {
        this.addKeyword(keyword, -1);
    }

    public void addKeyword(final SearchKeyword keyword, int index) {
        if (this.textComponent != null) {
            this.keywordPanel.remove(this.textComponent);
        }
        List<SearchValue> searchValues = this.getSearchValueList();
        int maxIndex = searchValues.size();
        boolean repeat = false;
        for (SearchValue searchValue : searchValues) {
            if (!searchValue.equals(keyword.getSearchValue())) continue;
            repeat = true;
            break;
        }
        if (!repeat) {
            keyword.addContentMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SearchBar.this.isTextFieldRewrite() && !"".equals(SearchBar.this.textField.getText())) {
                        return;
                    }
                    SearchBar.this.startEditKeyword(keyword);
                }
            });
            if (index >= 0) {
                keyword.setIndex(index);
                this.keywordPanel.add((Component)keyword, index);
            } else {
                keyword.setIndex(maxIndex);
                this.keywordPanel.add(keyword);
            }
        }
        this.initTextField();
    }

    public void startEditKeyword(SearchKeyword keyword) {
        if (this.textField != null) {
            this.keywordPanel.remove(this.textField);
        }
        this.keywordPanel.remove(keyword);
        SearchContext context = new SearchContext(OperationEnum.DELETE.text, SearchActionTypeEnum.EDIT_LABEL_TRIGGER.getType());
        ((AnySearchNotifier)this.project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, null);
        this.initTextField(keyword.getIndex(), true);
        if (this.textField != null) {
            this.textField.setText(keyword.getSearchValue().getNiceName());
            this.textField.requestFocus();
        }
    }

    public void requestTextFieldFocus() {
        if (this.textComponent != null) {
            this.textComponent.requestFocus();
        }
    }

    public void addTextFieldDocumentListener(DocumentListener listener) {
        this.textFieldDocumentListener = listener;
        if (this.textComponent != null) {
            this.textComponent.getDocument().addDocumentListener(listener);
        }
    }

    public void addTextFieldKeyListener(KeyListener listener) {
        this.textFieldKeyListener = listener;
        if (this.textComponent != null) {
            this.textComponent.addKeyListener(listener);
        }
    }

    public boolean isTextFieldRewrite() {
        Object value;
        if (this.textComponent != null && (value = this.textComponent.getClientProperty(TEXTFIELD_REWRITE_FLAG)) != null) {
            return (Boolean)value;
        }
        return false;
    }

    public int getTextFieldRewriteIndex() {
        Object value;
        if (this.textComponent != null && (value = this.textComponent.getClientProperty(TEXTFIELD_REWRITE_INDEX)) != null) {
            return (Integer)value;
        }
        return -1;
    }

    public void setIcon(Icon searchIcon, Icon closeIcon) {
        this.searchIconPanel.setIcon(searchIcon);
        this.closeIconPanel.setIcon(closeIcon);
    }

    public boolean isFocusOwner() {
        return this.textField != null && this.textField.isFocusOwner() || super.isFocusOwner();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.getHeight() < 35.0) {
            dimension.height = 35;
        }
        Container parent = SwingUtilities.getUnwrappedParent((Component)((Object)this));
        Dimension parentDim = parent.getSize();
        if (dimension.getWidth() > (double)parentDim.width) {
            dimension.width = parentDim.width;
        }
        return new Dimension((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public List<SearchValue> getSearchValueList() {
        ArrayList<SearchValue> result = new ArrayList<SearchValue>();
        for (Component comp : this.keywordPanel.getComponents()) {
            if (!(comp instanceof SearchKeyword)) continue;
            SearchKeyword keyword = (SearchKeyword)comp;
            result.add(keyword.getSearchValue());
        }
        return result;
    }

    public void updateSearchValueIndex() {
        int index = 0;
        for (Component comp : this.keywordPanel.getComponents()) {
            if (!(comp instanceof SearchKeyword)) continue;
            SearchKeyword keyword = (SearchKeyword)comp;
            keyword.setIndex(index++);
        }
    }

    public boolean hasOtherSearchValue(SearchValue searchValue) {
        ArrayList result = new ArrayList();
        for (Component comp : this.keywordPanel.getComponents()) {
            if (!(comp instanceof SearchKeyword)) continue;
            SearchKeyword keyword = (SearchKeyword)comp;
            if (!SearchValueTypeEnum.NLP.getType().equals(keyword.getSearchValue().getType()) || keyword.getSearchValue().equals(searchValue)) continue;
            return true;
        }
        return false;
    }

    public int getSearchValueCount() {
        int count = 0;
        for (Component comp : this.keywordPanel.getComponents()) {
            if (!(comp instanceof SearchKeyword)) continue;
            ++count;
        }
        return count;
    }

    public SearchKeyword getKeywordComponentBeforeText() {
        SearchKeyword latestKeyword = null;
        for (Component comp : this.keywordPanel.getComponents()) {
            if (comp instanceof SearchKeyword) {
                latestKeyword = (SearchKeyword)comp;
                continue;
            }
            if (comp instanceof SearchInputField) break;
        }
        return latestKeyword;
    }

    public SearchKeyword removeSearchValue(SearchValue searchValue) {
        for (Component comp : this.keywordPanel.getComponents()) {
            SearchKeyword keyword;
            if (!(comp instanceof SearchKeyword) || (keyword = (SearchKeyword)comp) == null || !keyword.getSearchValue().equals(searchValue)) continue;
            this.keywordPanel.remove(comp);
            return keyword;
        }
        return null;
    }

    public void clearSearchKeyword() {
        this.keywordPanel.removeAll();
        this.initTextField();
    }

    public void toggleClearButton(boolean visible) {
        this.closeIconPanel.setVisible(visible);
        this.revalidate();
    }

    public int getContentMaxWidth() {
        return this.keywordPanel.getSize().width - 10;
    }

    public void forceUpdateThemeColor(EditorColorsScheme scheme) {
        this.setBackground((Color)SEARCHBAR_BG_COLOR);
        this.keywordPanel.setBackground((Color)SEARCHBAR_BG_COLOR);
        this.operPanel.setBackground((Color)SEARCHBAR_BG_COLOR);
        if (this.textComponent != null && scheme != null) {
            this.textComponent.setForeground(scheme.getDefaultForeground());
        }
        this.updateUI();
    }

    public void setText(String text) {
        if (this.textComponent != null) {
            this.textComponent.setText(text);
        }
    }

    public void setTextFocus(boolean focus) {
        if (this.textComponent != null) {
            if (focus) {
                this.textComponent.requestFocusInWindow();
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
        }
    }

    public String getText() {
        if (this.textComponent != null) {
            return this.textComponent.getText();
        }
        return "";
    }

    public boolean isInputMethodChange() {
        if (this.textComponent != null && this.textComponent instanceof SearchInputTextArea) {
            return ((SearchInputTextArea)this.textComponent).isInputMethodChange();
        }
        return false;
    }

    public void addActionSelectListener(ActionSelectListener listener) {
        if (this.actionPanel != null) {
            this.actionPanel.addActionSelectListener(listener);
        }
    }

    public JTextComponent getTextField() {
        return this.textComponent;
    }

    public SearchKeywordPanel getKeywordPanel() {
        return this.keywordPanel;
    }

    public String getActionType() {
        if (this.actionPanel != null) {
            SearchActionPanel.PopupAction action = this.actionPanel.getSelectedValue();
            return action.getType();
        }
        return TextFieldActionEnum.SEARCH_ACTION.getName();
    }

    public void setActionType(String actionType) {
        if (this.actionPanel != null) {
            this.actionPanel.setSelectedValue(actionType);
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }
}

