/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.inputfield;

import com.alibabacloud.intellij.qoder.ui.search.component.LimitDocument;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchKeyword;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class SearchInputField
extends JTextField {
    private static final Logger log = Logger.getInstance(SearchInputField.class);
    private static final int OFFSET = 20;
    private static final int CHANGE_EMPTY_CHECK_COUNT = 2;
    private static final int INIT_EMPTY_CHECK_COUNT = 1;
    private int emptyCount = 1;
    private int FONT_DEFAULT_WIDTH = 6;
    private final SearchBar searchBar;

    public SearchInputField(SearchBar searchBar) {
        this.searchBar = searchBar;
        this.initComponents();
    }

    private void initComponents() {
        this.setDocument(new LimitDocument(300));
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchInputField.this.adaptTextFieldWidth();
                SearchInputField.this.searchBar.toggleClearButton(!"".equals(SearchInputField.this.getText()) || !SearchInputField.this.searchBar.getSearchValueList().isEmpty());
                if (!"".equals(SearchInputField.this.getText())) {
                    SearchInputField.this.emptyCount = 2;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/qoder/ui/search/component/inputfield/SearchInputField$1", "textChanged"));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchInputField.this.searchBar.getKeywordPanel().setFlowLayout(true);
                SearchInputField.this.searchBar.getKeywordPanel().togglePromptText(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchInputField.this.searchBar.getKeywordPanel().setFlowLayout(false);
                if ("".equals(SearchInputField.this.getText()) && SearchInputField.this.searchBar.getSearchValueCount() == 0) {
                    SearchInputField.this.searchBar.getKeywordPanel().togglePromptText(true);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 8 && "".equals(SearchInputField.this.getText())) {
                    SearchKeyword keyword;
                    --SearchInputField.this.emptyCount;
                    if (SearchInputField.this.emptyCount == 0 && (keyword = SearchInputField.this.searchBar.getKeywordComponentBeforeText()) != null) {
                        SearchInputField.this.searchBar.startEditKeyword(keyword);
                    }
                }
            }
        });
    }

    @Override
    protected void processKeyEvent(@com.sun.istack.NotNull KeyEvent e) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        int position = this.getCaretPosition();
        int code = keyStroke.getKeyCode();
        int modifiers = keyStroke.getModifiers();
        super.processKeyEvent(e);
        if ((code == 38 || code == 40) && modifiers == 0) {
            this.setCaretPosition(position);
        }
    }

    public void adaptTextFieldWidth() {
        Rectangle2D fontSize;
        Insets insets = this.getInsets();
        String content = this.getText();
        int inputWidth = content.length() * this.FONT_DEFAULT_WIDTH;
        Graphics g = this.getGraphics();
        if (!"".equals(content) && g != null && g.getFontMetrics() != null && (fontSize = g.getFontMetrics().getStringBounds(content, g)) != null) {
            inputWidth = (int)fontSize.getWidth();
        }
        Dimension dim = this.getPreferredSize();
        dim.width = inputWidth + insets.left + insets.right + 20;
        dim.width = Math.min(dim.width, this.searchBar.getContentMaxWidth());
        this.setPreferredSize(dim);
        this.revalidate();
        this.searchBar.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension((int)dimension.getWidth(), 31);
    }
}

