/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.inputfield;

import com.alibabacloud.intellij.qoder.layout.WrapForKeywordLayout;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.qoder.ui.search.enums.TextFieldActionEnum;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SearchKeywordPanel
extends JPanel {
    private static final int PROMPT_Y_OFFSET = 3;
    private boolean showPromptText = true;
    private SearchBar searchBar;

    public SearchKeywordPanel(final SearchBar searchBar) {
        this.searchBar = searchBar;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setBackground((Color)SearchBar.SEARCHBAR_BG_COLOR);
        this.setFlowLayout(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                SearchKeywordPanel.this.setCursor(new Cursor(2));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchKeywordPanel.this.setFlowLayout(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchKeywordPanel.this.setFlowLayout(false);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchKeywordPanel.this.setFlowLayout(true);
                if (searchBar.getTextField() != null) {
                    searchBar.getTextField().requestFocus();
                    searchBar.getTextField().setCaretPosition(searchBar.getTextField().getText().length());
                }
            }
        });
    }

    public void togglePromptText(boolean visible) {
        this.showPromptText = visible;
    }

    public void setFlowLayout(boolean wrap) {
        this.setLayout(new WrapForKeywordLayout(5, 2));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.showPromptText) {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            Dimension parentDim = parent.getPreferredSize();
            Dimension dim = this.getSize();
            String promptText = "";
            promptText = TextFieldActionEnum.SEARCH_ACTION.getName().equals(this.searchBar.getActionType()) ? I18NConstant.SEARCH_DEFAULT_TIP : I18NConstant.CHAT_DEFAULT_TIP;
            Rectangle2D fontSize = this.getGraphics().getFontMetrics().getStringBounds(promptText, g);
            int x = (int)((double)dim.width - fontSize.getWidth()) / 2;
            int y = (int)(((double)Math.max(dim.height, parentDim.height) - fontSize.getHeight()) / 2.0 + fontSize.getHeight()) - 3;
            g.setColor(ColorUtil.getAuxiliaryForegroundColor());
            g.setFont((Font)JBUI.Fonts.label((float)14.0f));
            g.drawString(promptText, x, y);
        }
    }
}

