/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.markdown;

import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.SwingManager;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.ToolbarLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CodeMarkdownComponent
implements MarkdownComponent {
    private static final int HGAP = 5;
    private static final int TOOLBAR_WIDTH = 29;
    private static final int TOOLBAR_HEIGHT = 28;
    private static final int TOOLBAR_X_OFFSET = 20;
    private Project project;
    private EditorTextField editorTextField;
    private JBPopup toolBarPopup;
    private JPanel popupPanel;
    JScrollPane jbScrollPane;
    private JComponent parentComponent;
    private GenerateAnswerPanel generateAnswerPanel;
    private SessionTypeEnum sessionType;

    public CodeMarkdownComponent(final Project project, String content, final JComponent parentComponent, final GenerateAnswerPanel generateAnswerPanel) {
        this.project = project;
        this.parentComponent = parentComponent;
        this.generateAnswerPanel = generateAnswerPanel;
        this.sessionType = generateAnswerPanel.getSessionType();
        Document document = EditorFactory.getInstance().createDocument((CharSequence)content);
        FileType fileType = PsiUtils.getFileType();
        this.editorTextField = new EditorTextField(document, this.project, fileType, true, false);
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (color == null) {
            this.editorTextField.setBackground(editorColorsScheme.getDefaultBackground());
        } else {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
            assert (toolWindow != null);
            this.editorTextField.setBackground(toolWindow.getComponent().getBackground());
        }
        this.editorTextField.setBorder(JBUI.Borders.empty((int)8));
        this.editorTextField.setRequestFocusEnabled(false);
        this.editorTextField.ensureWillComputePreferredSize();
        this.editorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        this.editorTextField.setHorizontalSizeReferent(parentComponent);
        this.editorTextField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (CodeMarkdownComponent.this.toolBarPopup != null && CodeMarkdownComponent.this.toolBarPopup.isVisible()) {
                    return;
                }
                CodeMarkdownComponent.this.popupPanel = new JPanel();
                CodeMarkdownComponent.this.popupPanel.setPreferredSize(new Dimension(29, 28));
                CodeMarkdownComponent.this.popupPanel.setBackground((Color)CosyColor.TOOLBAR_GN_COLOR);
                CodeMarkdownComponent.this.popupPanel.setLayout(new FlowLayout());
                ToolbarLabel copyLabel = new ToolbarLabel(CommonIcons.copyIcon, CommonIcons.copyHoverIcon, null, clickEvt -> {
                    StringSelection selection = new StringSelection(CodeMarkdownComponent.this.editorTextField.getText());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    CodeMarkdownComponent.this.toolBarPopup.cancel();
                    if (generateAnswerPanel != null && generateAnswerPanel.getSessionId() != null && generateAnswerPanel.getRequestId() != null) {
                        TelemetryService.getInstance().telemetrySessionId(project, TrackEventTypeEnum.CHAT_ANSWER_CODE_COPY, generateAnswerPanel.getRequestId(), generateAnswerPanel.getSessionId());
                    }
                });
                copyLabel.setCursor(Cursor.getPredefinedCursor(12));
                CodeMarkdownComponent.this.popupPanel.add(copyLabel);
                CodeMarkdownComponent.this.toolBarPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)CodeMarkdownComponent.this.popupPanel, null).setFocusable(true).setRequestFocus(true).setResizable(false).setCancelOnClickOutside(false).createPopup();
                Dimension sim = parentComponent.getSize();
                int x = sim.width - 29 - 5 - 20;
                int y = 5;
                JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)CodeMarkdownComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)CodeMarkdownComponent.this.sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY"));
                if (scrollPane != null && CodeMarkdownComponent.this.editorTextField.getLocationOnScreen().y - scrollPane.getLocationOnScreen().y < 0) {
                    y += Math.abs(CodeMarkdownComponent.this.editorTextField.getLocationOnScreen().y - scrollPane.getLocationOnScreen().y);
                }
                CodeMarkdownComponent.this.toolBarPopup.show(new RelativePoint((Component)CodeMarkdownComponent.this.editorTextField, new Point(x, y)));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (CodeMarkdownComponent.this.toolBarPopup != null) {
                    MouseEvent childEvent = SwingUtilities.convertMouseEvent((Component)CodeMarkdownComponent.this.editorTextField, e, CodeMarkdownComponent.this.popupPanel);
                    Point mousePosition = childEvent.getPoint();
                    Rectangle popupBounds = CodeMarkdownComponent.this.popupPanel.getBounds();
                    mousePosition.x = Math.max(mousePosition.x, 0);
                    mousePosition.y = Math.max(mousePosition.y, 0);
                    Point screenPoint = CodeMarkdownComponent.this.jbScrollPane.getLocationOnScreen();
                    Dimension paneDim = CodeMarkdownComponent.this.jbScrollPane.getSize();
                    Point screenMousePoint = e.getLocationOnScreen();
                    if (screenMousePoint.x < screenPoint.x || screenMousePoint.x > screenPoint.x + paneDim.width || screenMousePoint.y < screenPoint.y || screenMousePoint.y > screenPoint.y + paneDim.height || !popupBounds.contains(mousePosition)) {
                        CodeMarkdownComponent.this.toolBarPopup.cancel();
                        CodeMarkdownComponent.this.popupPanel = null;
                        CodeMarkdownComponent.this.toolBarPopup = null;
                    }
                }
            }
        });
        if (this.sessionType == SessionTypeEnum.INLINE) {
            this.editorTextField.putClientProperty((Object)"AuxEditorComponent", (Object)true);
        }
        this.jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension parentSize = parentComponent.getSize();
                return new Dimension(parentSize.width - 5, size.height + 10);
            }
        };
        this.jbScrollPane.setViewportView((Component)this.editorTextField);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(30);
        this.jbScrollPane.setVerticalScrollBarPolicy(21);
    }

    @Override
    public void updateText(String text, String language, boolean isCompleted) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        this.editorTextField.setDocument(document);
        this.editorTextField.revalidate();
        Dimension parentSize = this.parentComponent.getSize();
        Dimension editSize = this.editorTextField.getPreferredSize();
        this.editorTextField.setSize(editSize);
        this.jbScrollPane.setPreferredSize(new Dimension(parentSize.width - 5, editSize.height + 10));
        this.jbScrollPane.revalidate();
    }

    @Override
    public Component getComponent() {
        return this.jbScrollPane;
    }
}

