/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.markdown;

import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.qoder.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownBlock;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.IconUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class FileMarkdownComponent
implements MarkdownComponent,
RefreshColorComponent {
    private static final int BLOCK_MAX_HEIGHT = 400;
    private Project project;
    private List<MarkdownBlock> fileItems;
    private AIDevFilePanel aiDevFilePanel;

    public FileMarkdownComponent(Project project, List<MarkdownBlock> fileItems, String sessionId) {
        this.project = project;
        this.fileItems = fileItems;
        this.aiDevFilePanel = new AIDevFilePanel(project, AIDevFileUsageEnum.CHAT_CARD, this.getFileItemsFromBlock(fileItems, sessionId));
    }

    public FileMarkdownComponent(Project project, MarkdownBlock fileItem, String sessionId) {
        this.project = project;
        this.fileItems = new ArrayList<MarkdownBlock>();
        this.fileItems.add(fileItem);
        this.aiDevFilePanel = new AIDevFilePanel(project, AIDevFileUsageEnum.CHAT_CARD, this.getFileItemsFromBlock(this.fileItems, sessionId));
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
    }

    @Override
    public void updateText(String text, String language, boolean isCompleted) {
    }

    @Override
    public Component getComponent() {
        return this.aiDevFilePanel;
    }

    private List<AIDevFilePanel.FileItem> getFileItemsFromBlock(List<MarkdownBlock> blocks, String sessionId) {
        ArrayList<AIDevFilePanel.FileItem> fileItemList = new ArrayList<AIDevFilePanel.FileItem>();
        for (MarkdownBlock block : blocks) {
            if (block.getContent() == null) continue;
            fileItemList.add(this.constructFileItem(sessionId, block));
        }
        return fileItemList;
    }

    private @NotNull AIDevFilePanel.FileItem constructFileItem(String sessionId, MarkdownBlock block) {
        String filePath = block.getContent();
        String fileName = FileUtil.getFileName(filePath);
        AIDevFilePanel.FileItem fileItem = new AIDevFilePanel.FileItem();
        fileItem.setName(fileName);
        fileItem.setStatus(AIDevFileStatusEnum.GENERATING);
        fileItem.setPath(filePath);
        fileItem.setFileId(filePath);
        fileItem.setId(block.getWorkingItemId());
        fileItem.setIcon(IconUtil.getFileTypeIcon(this.project, filePath));
        fileItem.setSessionId(sessionId);
        AIDevFilePanel.FileItem fileItem2 = fileItem;
        if (fileItem2 == null) {
            FileMarkdownComponent.$$$reportNull$$$0(0);
        }
        return fileItem2;
    }

    public void addFileItem(String sessionId, MarkdownBlock block) {
        if (null != block.getContent()) {
            this.fileItems.add(block);
            this.aiDevFilePanel.addFileItem(this.constructFileItem(sessionId, block));
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public List<MarkdownBlock> getFileItems() {
        return this.fileItems;
    }

    @Generated
    public AIDevFilePanel getAiDevFilePanel() {
        return this.aiDevFilePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/ui/search/component/markdown/FileMarkdownComponent", "constructFileItem"));
    }
}

