/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.markdown;

import com.alibabacloud.intellij.qoder.chat.model.ToolInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatQueueParams;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.util.Md5Util;
import lombok.Generated;

public class MarkdownBlock {
    public static final String TEXT_BLOCK = "content";
    public static final String CODE_BLOCK = "code";
    public static final String FILE_BLOCK = "file";
    public static final String TOOL_BLOCK = "tool";
    public static final String THINK_BLOCK = "think";
    public static final String QUEUE_BLOCK = "queue";
    private String identifier;
    private String content;
    private String type;
    private String language;
    private boolean completed;
    private MarkdownComponent component;
    private ToolInfo toolInfo;
    private String workingItemId;
    private String filePath;
    private boolean needUpdate = true;
    private ChatQueueParams queuedInfo;
    private Long thinkTime;

    public MarkdownBlock(String content, String type) {
        this.content = content;
        this.type = type;
        this.completed = true;
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, boolean completed) {
        this.content = content;
        this.type = type;
        this.completed = completed;
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, String language) {
        this.content = content;
        this.type = type;
        this.completed = true;
        this.language = language == null ? null : language.trim();
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, boolean completed, String language, long thinkTime) {
        this(content, type, completed, language);
        this.thinkTime = thinkTime;
    }

    public MarkdownBlock(String content, String type, String language, String workingItemId) {
        this.content = content;
        this.type = type;
        this.completed = true;
        this.language = language == null ? null : language.trim();
        this.identifier = Md5Util.encode(content.getBytes());
        this.workingItemId = workingItemId;
    }

    public MarkdownBlock(String content, String type, boolean completed, String language) {
        this.content = content;
        this.type = type;
        this.completed = completed;
        this.language = language == null ? null : language.trim();
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(ToolInfo toolInfo, String type) {
        this.toolInfo = toolInfo;
        this.content = toolInfo.getToolName() + "::" + toolInfo.getToolCallId() + "::" + toolInfo.getToolCallStatus();
        this.type = type;
        this.completed = true;
        this.identifier = toolInfo.getToolCallId();
    }

    public MarkdownBlock(String content, String type, boolean completed, String language, String identifier, String filePath) {
        this.content = content;
        this.type = type;
        this.completed = completed;
        this.language = language == null ? null : language.trim();
        this.identifier = identifier != null ? identifier : Md5Util.encode(content.getBytes());
        this.filePath = filePath;
    }

    public void update(String content, String language, boolean completed) {
        this.content = content;
        this.identifier = Md5Util.encode(content.getBytes());
        this.language = language;
        this.completed = completed;
    }

    public MarkdownBlock(ChatQueueParams queuedInfo, String type) {
        this.queuedInfo = queuedInfo;
        this.content = queuedInfo.getWaitTime() + "\u79d2\u540e\u5f00\u59cb\u6267\u884c";
        this.type = type;
        this.completed = true;
        this.identifier = queuedInfo.getModelKey();
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public MarkdownComponent getComponent() {
        return this.component;
    }

    @Generated
    public ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    @Generated
    public String getWorkingItemId() {
        return this.workingItemId;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    @Generated
    public ChatQueueParams getQueuedInfo() {
        return this.queuedInfo;
    }

    @Generated
    public Long getThinkTime() {
        return this.thinkTime;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Generated
    public void setComponent(MarkdownComponent component) {
        this.component = component;
    }

    @Generated
    public void setToolInfo(ToolInfo toolInfo) {
        this.toolInfo = toolInfo;
    }

    @Generated
    public void setWorkingItemId(String workingItemId) {
        this.workingItemId = workingItemId;
    }

    @Generated
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Generated
    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    @Generated
    public void setQueuedInfo(ChatQueueParams queuedInfo) {
        this.queuedInfo = queuedInfo;
    }

    @Generated
    public void setThinkTime(Long thinkTime) {
        this.thinkTime = thinkTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarkdownBlock)) {
            return false;
        }
        MarkdownBlock other = (MarkdownBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        MarkdownComponent this$component = this.getComponent();
        MarkdownComponent other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        ToolInfo this$toolInfo = this.getToolInfo();
        ToolInfo other$toolInfo = other.getToolInfo();
        if (this$toolInfo == null ? other$toolInfo != null : !((Object)this$toolInfo).equals(other$toolInfo)) {
            return false;
        }
        String this$workingItemId = this.getWorkingItemId();
        String other$workingItemId = other.getWorkingItemId();
        if (this$workingItemId == null ? other$workingItemId != null : !this$workingItemId.equals(other$workingItemId)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        if (this.isNeedUpdate() != other.isNeedUpdate()) {
            return false;
        }
        ChatQueueParams this$queuedInfo = this.getQueuedInfo();
        ChatQueueParams other$queuedInfo = other.getQueuedInfo();
        if (this$queuedInfo == null ? other$queuedInfo != null : !((Object)this$queuedInfo).equals(other$queuedInfo)) {
            return false;
        }
        Long this$thinkTime = this.getThinkTime();
        Long other$thinkTime = other.getThinkTime();
        return !(this$thinkTime == null ? other$thinkTime != null : !((Object)this$thinkTime).equals(other$thinkTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MarkdownBlock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        MarkdownComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        ToolInfo $toolInfo = this.getToolInfo();
        result = result * 59 + ($toolInfo == null ? 43 : ((Object)$toolInfo).hashCode());
        String $workingItemId = this.getWorkingItemId();
        result = result * 59 + ($workingItemId == null ? 43 : $workingItemId.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        result = result * 59 + (this.isNeedUpdate() ? 79 : 97);
        ChatQueueParams $queuedInfo = this.getQueuedInfo();
        result = result * 59 + ($queuedInfo == null ? 43 : ((Object)$queuedInfo).hashCode());
        Long $thinkTime = this.getThinkTime();
        result = result * 59 + ($thinkTime == null ? 43 : ((Object)$thinkTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MarkdownBlock(identifier=" + this.getIdentifier() + ", content=" + this.getContent() + ", type=" + this.getType() + ", language=" + this.getLanguage() + ", completed=" + this.isCompleted() + ", component=" + this.getComponent() + ", toolInfo=" + this.getToolInfo() + ", workingItemId=" + this.getWorkingItemId() + ", filePath=" + this.getFilePath() + ", needUpdate=" + this.isNeedUpdate() + ", queuedInfo=" + this.getQueuedInfo() + ", thinkTime=" + this.getThinkTime() + ")";
    }
}

