/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.markdown;

import com.alibabacloud.intellij.qoder.chat.model.ToolInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatQueueParams;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.ChatTagsComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.CodeMarkdownHighlightComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.EmptyComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.FileMarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownBlock;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.QueuedComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.ThinkingComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.ToolMarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.Md5Util;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MarkdownStreamPanel
extends JPanel
implements RefreshColorComponent {
    private static final Logger log = Logger.getInstance(MarkdownStreamPanel.class);
    private static final String SOFT_PLACEHOLDER = "&[0-9a-z]{2,8};|&#[0-9]{1,7};";
    public static final Pattern MATCHER_PATTERN = Pattern.compile("```([\\w#+.-]+)::([^\\n]+)::([^\\n]+)\\n+(.*?)```|````think::(\\d+|\\{THINK_TIME})\n(.*?)\n````|````think::(\\d+|\\{THINK_TIME})\n(.*)|```([\\w#+.-]*\n*)?(.*?)`{2,3}|`{2,3}([\\w#+.-]+\n*)?(.*)|<think>(.*?)</think>|<think>(.*)", 32);
    private static final String ASK_CODE_COMPONENT_CODE_EDIT_BLOCK = "CODE_EDIT_BLOCK";
    private final Project project;
    private final JComponent parentComponent;
    private final GenerateAnswerPanel generateAnswerPanel;
    List<MarkdownBlock> blocks;
    List<ChatAskTag> tags;
    ChatTagsComponent tagsComponent;
    private int height;
    private MarkdownBlock globalLastBlock;
    private Color textBackgroundColor;
    private final int limitCodeBlockHeight;
    private StringBuilder buffer = new StringBuilder();

    public MarkdownStreamPanel(Project project, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel) {
        this(project, parentComponent, generateAnswerPanel, 0);
    }

    public MarkdownStreamPanel(Project project, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel, int limitCodeBlockHeight) {
        this(project, parentComponent, generateAnswerPanel, limitCodeBlockHeight, (LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false), ColorUtil.getChatCardChildBackgroundColor());
    }

    public MarkdownStreamPanel(Project project, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel, int limitCodeBlockHeight, LayoutManager mgr, Color textBackgroundColor) {
        this.project = project;
        this.setLayout(mgr);
        this.parentComponent = parentComponent;
        this.generateAnswerPanel = generateAnswerPanel;
        this.limitCodeBlockHeight = limitCodeBlockHeight;
        this.setBackground(parentComponent.getBackground());
        this.globalLastBlock = null;
        this.textBackgroundColor = textBackgroundColor;
        this.setBorder((Border)JBUI.Borders.empty());
    }

    public String getText() {
        StringBuilder stringBuffer = new StringBuilder();
        for (MarkdownBlock block : this.blocks) {
            stringBuffer.append(block.getContent());
        }
        return stringBuffer.toString();
    }

    public String getTextWithCodeBlock() {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.blocks)) {
            for (MarkdownBlock block : this.blocks) {
                if ("code".equals(block.getType())) {
                    String content = block.getContent();
                    if (content == null || content.isEmpty()) continue;
                    if (!content.startsWith("```\n")) {
                        stringBuilder.append("```");
                        stringBuilder.append(block.getLanguage());
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(block.getContent());
                    if (content.endsWith("```\n")) continue;
                    stringBuilder.append("```\n");
                    continue;
                }
                if ("file".equals(block.getType())) {
                    String filePath = block.getContent();
                    String fileName = block.getContent();
                    int nameIndex = block.getContent().lastIndexOf("/");
                    if (nameIndex != -1 && nameIndex < fileName.length() - 1) {
                        fileName = fileName.substring(nameIndex + 1);
                    }
                    stringBuilder.append("\n[").append(fileName).append("](").append(filePath).append(")\n");
                    continue;
                }
                if ("tool".equals(block.getType())) {
                    ToolPanel toolPanel;
                    String content;
                    ToolMarkdownComponent component;
                    if (!(block.getComponent() instanceof ToolMarkdownComponent) || (component = (ToolMarkdownComponent)block.getComponent()).getComponent() == null || !(component.getComponent() instanceof ToolPanel) || !StringUtils.isNotBlank((String)(content = (toolPanel = (ToolPanel)component.getComponent()).getContent()))) continue;
                    stringBuilder.append(content);
                    continue;
                }
                if ("think".equals(block.getType())) {
                    stringBuilder.append(CosyBundle.message("chat.answer.deep.thinking.label", new Object[0])).append("\n```").append(block.getContent()).append("\n```");
                    continue;
                }
                stringBuilder.append(block.getContent());
            }
        }
        return stringBuilder.toString();
    }

    public synchronized void setTags(List<ChatAskTag> tags) {
        this.tags = tags;
    }

    public synchronized void append(String markdown, boolean isRecoverSession) {
        if (this.blocks == null || this.blocks.isEmpty()) {
            this.setBorder((Border)JBUI.Borders.emptyBottom((int)0));
        }
        this.buffer.append(markdown);
        List<MarkdownBlock> incrBlocks = this.parseBlock(this.buffer.toString());
        if (incrBlocks.isEmpty()) {
            return;
        }
        if (this.blocks == null || this.blocks.isEmpty()) {
            this.blocks = incrBlocks;
        } else {
            MarkdownBlock newBlock;
            for (int i = 0; i < Math.min(this.blocks.size(), incrBlocks.size()); ++i) {
                MarkdownBlock oldBlock = this.blocks.get(i);
                newBlock = incrBlocks.get(i);
                if (oldBlock.getIdentifier().equals(newBlock.getIdentifier())) {
                    if (oldBlock.isCompleted() == newBlock.isCompleted()) continue;
                    oldBlock.setCompleted(newBlock.isCompleted());
                    oldBlock.setNeedUpdate(true);
                    continue;
                }
                oldBlock.setNeedUpdate(true);
                oldBlock.update(newBlock.getContent(), newBlock.getLanguage(), newBlock.isCompleted());
            }
            for (int j = i; j < incrBlocks.size(); ++j) {
                newBlock = incrBlocks.get(j);
                newBlock.setNeedUpdate(true);
                this.blocks.add(newBlock);
            }
        }
        this.renderComponent(isRecoverSession);
    }

    public synchronized void appendComponent(ChatQueueParams queuedInfo) {
        this.blocks.add(new MarkdownBlock(queuedInfo, "queue"));
        this.renderComponent(false);
    }

    private void renderComponent(boolean isRecoverSession) {
        if (this.blocks != null && !this.blocks.isEmpty()) {
            if (this.tagsComponent != null) {
                this.tagsComponent.addBottomMargin();
            }
            this.renderBlocks(isRecoverSession);
        }
        this.revalidate();
    }

    private void renderBlocks(boolean isRecoverSession) {
        MarkdownBlock lastBlock = null;
        for (int i = 0; i < this.blocks.size(); ++i) {
            MarkdownBlock block = this.blocks.get(i);
            if (block.getComponent() != null && !block.isNeedUpdate()) {
                lastBlock = block;
                if (null != this.globalLastBlock && "file".equals(this.globalLastBlock.getType()) && "file".equals(block.getType())) continue;
                this.globalLastBlock = block;
                continue;
            }
            if (block.getComponent() == null) {
                MarkdownComponent component = null;
                if ("content".equals(block.getType())) {
                    component = new TextMarkdownComponent(this.project, block.getContent(), i, this.blocks.size(), this.tags, this.generateAnswerPanel.getSessionType(), this.textBackgroundColor);
                } else if ("code".equals(block.getType())) {
                    if (null != this.globalLastBlock && "think".equals(this.globalLastBlock.getType())) {
                        this.add(new EmptyComponent(4).getComponent());
                    }
                    component = new CodeMarkdownHighlightComponent(this.project, block.getContent(), block.getLanguage(), block.getFilePath(), this.parentComponent, this.generateAnswerPanel, this.limitCodeBlockHeight, block.isCompleted());
                } else if ("file".equals(block.getType())) {
                    if (block.isNeedUpdate()) {
                        if (null != this.globalLastBlock && "file".equals(this.globalLastBlock.getType())) {
                            ((FileMarkdownComponent)this.globalLastBlock.getComponent()).addFileItem(this.generateAnswerPanel.getSessionId(), block);
                        } else {
                            component = new FileMarkdownComponent(this.project, block, this.generateAnswerPanel.getSessionId());
                        }
                    }
                } else if ("tool".equals(block.getType())) {
                    if (null != this.globalLastBlock && ("tool".equals(this.globalLastBlock.getType()) || "think".equals(this.globalLastBlock.getType()))) {
                        this.add(new EmptyComponent(4).getComponent());
                    }
                    component = new ToolMarkdownComponent(this.project, this.generateAnswerPanel, block.getToolInfo(), isRecoverSession);
                } else if ("think".equals(block.getType())) {
                    if (null != this.globalLastBlock && ("tool".equals(this.globalLastBlock.getType()) || "think".equals(this.globalLastBlock.getType()))) {
                        this.add(new EmptyComponent(4).getComponent());
                    }
                    component = new ThinkingComponent(this.project, isRecoverSession, block.getContent(), block.getThinkTime());
                } else if ("queue".equals(block.getType())) {
                    if (null != this.globalLastBlock && ("tool".equals(this.globalLastBlock.getType()) || "think".equals(this.globalLastBlock.getType()))) {
                        this.add(new EmptyComponent(8).getComponent());
                    }
                    component = new QueuedComponent(this.project, block.getQueuedInfo());
                }
                if (component != null) {
                    this.add(component.getComponent());
                    block.setComponent(component);
                    if (lastBlock != null && lastBlock.getComponent() instanceof CodeMarkdownHighlightComponent) {
                        CodeMarkdownHighlightComponent codeComponent = (CodeMarkdownHighlightComponent)lastBlock.getComponent();
                        codeComponent.scrollLeft();
                    }
                }
            } else {
                block.getComponent().updateText(block.getContent(), block.getLanguage(), block.isCompleted());
            }
            block.setNeedUpdate(false);
            lastBlock = block;
            if (null != this.globalLastBlock && "file".equals(this.globalLastBlock.getType()) && "file".equals(block.getType())) continue;
            this.globalLastBlock = block;
        }
    }

    private void renderTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            return;
        }
        if (this.tagsComponent == null) {
            this.tagsComponent = new ChatTagsComponent(this.tags);
            this.add(this.tagsComponent.getComponent(), 0);
        }
    }

    private List<MarkdownBlock> parseBlock(String markdown) {
        ArrayList<MarkdownBlock> result = new ArrayList<MarkdownBlock>();
        StringBuilder sb = new StringBuilder();
        Matcher matcher = MATCHER_PATTERN.matcher(markdown);
        while (matcher.find()) {
            MarkdownBlock block = null;
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            String group6 = matcher.group(6);
            String group8 = matcher.group(8);
            String group13 = matcher.group(13);
            String group14 = matcher.group(14);
            if (null != group1 || null != group2) {
                if ("toolCall".equals(group1)) {
                    String[] split = group2.split("::");
                    block = new MarkdownBlock(new ToolInfo(split[0], split[1], matcher.group(3)), "tool");
                } else {
                    block = new MarkdownBlock(group2, "file", matcher.group(1), matcher.group(3));
                }
            } else if (null != group6 || null != group8) {
                block = null != group6 ? ("{THINK_TIME}".equals(matcher.group(5)) ? new MarkdownBlock(group6, "think", true, null) : new MarkdownBlock(group6, "think", true, null, Long.parseLong(matcher.group(5)) / 1000L + 1L)) : ("{THINK_TIME}".equals(matcher.group(7)) ? new MarkdownBlock(group8, "think", false, null) : new MarkdownBlock(group8, "think", false, null, Long.parseLong(matcher.group(7)) / 1000L + 1L));
            } else if (null != group13 || null != group14) {
                block = null == group13 ? new MarkdownBlock(group14, "think", false, null) : new MarkdownBlock(group13, "think", null);
            } else {
                Pair<String, String> pathAndContentPair;
                String[] parts;
                if (matcher.group(9) != null && matcher.group(10) != null) {
                    parts = matcher.group(10).split("\\|");
                    if (parts.length >= 3 && ASK_CODE_COMPONENT_CODE_EDIT_BLOCK.equals(parts[1]) && (pathAndContentPair = this.getFilePathAndContent(matcher.group(10))) != null) {
                        block = new MarkdownBlock((String)pathAndContentPair.getSecond(), "code", true, matcher.group(9), this.getCodeEditBlockIdentifier((String)pathAndContentPair.getSecond(), true), (String)pathAndContentPair.getFirst());
                    }
                } else if (matcher.group(11) != null && matcher.group(12) != null && (parts = matcher.group(12).split("\\|")).length >= 3 && ASK_CODE_COMPONENT_CODE_EDIT_BLOCK.equals(parts[1]) && (pathAndContentPair = this.getFilePathAndContent(matcher.group(12))) != null) {
                    block = new MarkdownBlock((String)pathAndContentPair.getSecond(), "code", false, matcher.group(11), this.getCodeEditBlockIdentifier((String)pathAndContentPair.getSecond(), false), (String)pathAndContentPair.getFirst());
                }
                if (null == block) {
                    block = null == matcher.group(10) ? new MarkdownBlock(matcher.group(12), "code", false, matcher.group(11)) : new MarkdownBlock(matcher.group(10), "code", matcher.group(9));
                }
            }
            this.processOtherTexts(matcher, sb, result);
            result.add(block);
            sb.setLength(0);
        }
        matcher.appendTail(sb);
        this.processOtherTexts(sb, result, false);
        return result;
    }

    private Pair<String, String> getFilePathAndContent(String blockSignalAndPathAndContent) {
        int firstIndex = blockSignalAndPathAndContent.indexOf("\n");
        if (firstIndex > 0) {
            String content = blockSignalAndPathAndContent.substring(firstIndex + 1);
            String filePath = blockSignalAndPathAndContent.substring(0, firstIndex).replace("|CODE_EDIT_BLOCK|", "");
            return new Pair((Object)filePath, (Object)content);
        }
        return null;
    }

    private String getCodeEditBlockIdentifier(String content, boolean completed) {
        return Md5Util.encode((content + "&completed=" + completed).getBytes());
    }

    private void processOtherTexts(Matcher matcher, StringBuilder sb, List<MarkdownBlock> result) {
        matcher.appendReplacement(sb, "");
        this.processOtherTexts(sb, result, true);
    }

    private void processOtherTexts(StringBuilder sb, List<MarkdownBlock> result, boolean completed) {
        if (!sb.toString().trim().isEmpty()) {
            MarkdownBlock textBlock = new MarkdownBlock(sb.toString(), "content", completed);
            result.add(textBlock);
        }
    }

    public void enableBottomMarginForText() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            return;
        }
        MarkdownBlock lastBlock = this.blocks.get(this.blocks.size() - 1);
        if (lastBlock.getComponent() instanceof TextMarkdownComponent) {
            TextMarkdownComponent textComponent = (TextMarkdownComponent)lastBlock.getComponent();
            textComponent.addBottomMargin();
        }
    }

    public void clear() {
        if (this.blocks != null && !this.blocks.isEmpty()) {
            this.blocks.forEach(e -> {
                if (!("file".equals(e.getType()) || "tool".equals(e.getType()) || "think".equals(e.getType()))) {
                    e.setIdentifier("");
                }
            });
        } else {
            this.blocks = new ArrayList<MarkdownBlock>();
        }
        this.buffer = new StringBuilder();
        this.revalidate();
    }

    public void clearAll() {
        this.blocks = new ArrayList<MarkdownBlock>();
        this.buffer = new StringBuilder();
        this.removeAll();
        this.revalidate();
    }

    public void clearForRetry() {
        this.blocks.clear();
        this.buffer = new StringBuilder();
        this.removeAll();
        this.revalidate();
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        for (MarkdownBlock block : this.blocks) {
            if (block.getComponent() == null) continue;
            MarkdownComponent component = block.getComponent();
            if (component instanceof TextMarkdownComponent) {
                ((TextMarkdownComponent)component).refreshColor(scheme, themeColor);
                continue;
            }
            if (!(component instanceof CodeMarkdownHighlightComponent)) continue;
            ((CodeMarkdownHighlightComponent)component).refreshColor(scheme, themeColor);
        }
        this.revalidate();
    }

    @Generated
    public List<MarkdownBlock> getBlocks() {
        return this.blocks;
    }
}

