/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.markdown;

import com.alibabacloud.intellij.qoder.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.qoder.ui.search.SwingManager;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.WrappedHtmlEditorKit;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.ThemeUtil;
import com.alibabacloud.intellij.qoder.util.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TextMarkdownComponent
implements MarkdownComponent,
RefreshColorComponent {
    private static Logger log = Logger.getInstance(TextMarkdownComponent.class);
    private JTextPane textPanel;
    private Font originalFont;
    private Color originalColor;
    private String originalText;
    private boolean enableTopMargin = false;
    private boolean enableBottomMargin = false;
    private int textPanelHeight;
    private int textPanelWidth;
    Project project;
    private List<ChatAskTag> tags;
    private SessionTypeEnum sessionType;
    private Color backgroundColor;

    public TextMarkdownComponent(Project project, String text, int blockIndex, int blockCount, List<ChatAskTag> tags, SessionTypeEnum sessionType) {
        this(project, text, blockIndex, blockCount, tags, sessionType, ColorUtil.getChatCardChildBackgroundColor());
    }

    public TextMarkdownComponent(final Project project, String text, int blockIndex, int blockCount, List<ChatAskTag> tags, final SessionTypeEnum sessionType, Color backgroundColor) {
        this.project = project;
        this.tags = tags;
        this.sessionType = sessionType;
        this.textPanel = new JTextPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (TextMarkdownComponent.this.textPanelHeight > 0 && dim.height < TextMarkdownComponent.this.textPanelHeight) {
                    dim.height = TextMarkdownComponent.this.textPanelHeight;
                } else {
                    TextMarkdownComponent.this.textPanelHeight = dim.height;
                }
                if (TextMarkdownComponent.this.textPanelWidth == 0) {
                    TextMarkdownComponent.this.textPanelWidth = dim.width;
                }
                return dim;
            }
        };
        this.textPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent().getWidth() > TextMarkdownComponent.this.textPanelWidth) {
                    TextMarkdownComponent.this.textPanelHeight = 0;
                }
                TextMarkdownComponent.this.textPanelWidth = e.getComponent().getWidth();
            }
        });
        this.textPanel.addMouseMotionListener(new MouseMotionAdapter(){
            private int lastMouseY = -1;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TextMarkdownComponent.this.textPanel.getVisibleRect().contains(e.getPoint())) {
                    this.lastMouseY = e.getY();
                } else {
                    JBScrollPane scrollPane = SessionTypeEnum.CHAT.equals((Object)sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.ASSISTANT.equals((Object)sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY") : (SessionTypeEnum.INLINE.equals((Object)sessionType) ? (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY") : (JBScrollPane)SwingManager.INSTANCE.getComponent(project, "AI_DEVELOPER_MAIN_VERTICAL_SCROLLBAR_KEY")));
                    this.lastMouseY = TextMarkdownComponent.this.handleTextDragEvent(project, e, this.lastMouseY, scrollPane);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.lastMouseY = e.getY();
            }
        });
        this.textPanel.setEditable(false);
        this.setupBorder(blockIndex, blockCount);
        this.textPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.textPanel.setFont(this.textPanel.getFont().deriveFont(13.0f));
        this.originalFont = this.textPanel.getFont();
        this.originalColor = this.textPanel.getForeground();
        this.originalText = StringUtils.trim((String)text);
        this.textPanel.setEditorKit(new WrappedHtmlEditorKit());
        this.textPanel.setText(this.buildText(this.originalText));
        this.textPanel.setBackground(backgroundColor);
        this.textPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    UrlUtil.performHyperlink(null, e, TextMarkdownComponent.this.textPanel);
                }
            }
        });
        if (sessionType == SessionTypeEnum.INLINE) {
            this.textPanel.putClientProperty("AuxEditorComponent", true);
        }
    }

    private void setupBorder(int blockIndex, int blockCount) {
        int top = 0;
        int bottom = 0;
        if (blockIndex > 0) {
            this.enableTopMargin = true;
            top = 8;
        }
        if (blockIndex < blockCount - 1) {
            this.enableBottomMargin = true;
            bottom = 8;
        }
        this.textPanel.setBorder((Border)JBUI.Borders.empty((int)top, (int)12, (int)bottom, (int)12));
    }

    public void addTopMargin() {
        this.enableTopMargin = true;
        this.changeTopBottomMargin();
    }

    public void addBottomMargin() {
        this.enableBottomMargin = true;
        this.changeTopBottomMargin();
    }

    private void changeTopBottomMargin() {
        int top = 0;
        int bottom = 0;
        if (this.enableTopMargin) {
            top = 8;
        }
        if (this.enableBottomMargin) {
            bottom = 8;
        }
        this.textPanel.setBorder((Border)JBUI.Borders.empty((int)top, (int)12, (int)bottom, (int)12));
        this.textPanel.invalidate();
        this.textPanel.repaint();
    }

    private String buildText(String text) {
        String content = ThemeUtil.getMarkdownContent(this.originalColor, this.originalFont, text.trim());
        if (CollectionUtils.isEmpty(this.tags)) {
            return content;
        }
        List workspaceTagList = this.tags.stream().filter(chatAskTag -> AgentTagEnum.WORKSPACE.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workspaceTagList)) {
            return content;
        }
        return FileUtil.detectFileUrl(this.project, content);
    }

    @Override
    public void updateText(String text, String language, boolean isCompleted) {
        this.originalText = text;
        this.textPanel.setText(this.buildText(text));
    }

    @Override
    public Component getComponent() {
        return this.textPanel;
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.originalColor = ColorUtil.getTextForegroundColor();
        this.textPanel.setText(this.buildText(this.originalText));
    }

    public void disableTextMarkdown() {
        this.originalColor = ColorUtil.getAuxiliaryForegroundColor();
        String text = this.buildText(this.originalText);
        String textColorStr = String.format("%02x%02x%02x", this.originalColor.getRed(), this.originalColor.getGreen(), this.originalColor.getBlue());
        text = text.replaceAll("<code>", "<code style=\"color: #" + textColorStr + ";\">");
        this.textPanel.setText(text);
    }

    public void enableTextMarkdown() {
        this.originalColor = ColorUtil.getTextForegroundColor();
        this.textPanel.setText(this.buildText(this.originalText));
    }

    public void resetTextPanelHeight() {
        this.textPanelHeight = 0;
    }
}

