/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.profiler;

import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.CosyStartupAdapter;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthUserTypeEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.BaseResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SwitchAccountParams;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.qoder.ui.search.component.PrettyListPopup;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderProfilerReloadNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ShowSwitchIdentifyPopupNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ProfilerDisplayItemPanel
extends JPanel
implements Disposable {
    private static final Logger LOGGER = Logger.getInstance(ProfilerDisplayItemPanel.class);
    private static final int MAX_DISPLAY_NAME_LENGTH = 10;
    private static final int MAX_ITEM_WIDTH = 150;
    private static final int AVATAR_SIZE = 20;
    private static final int MAX_VISIBLE_ORG_COUNT = 8;
    JLabel identityPopLabel;
    JLabel expandLabel;
    Project project;
    AuthStatus status;
    PrettyListPopup<AuthOrgItem> orgPopup;
    AtomicReference<OrgIdentifyData> identifyData = new AtomicReference();
    MouseListener mouseListener;
    MessageBusConnection messageBusConnection;
    AtomicLong lastRefreshTime = new AtomicLong(0L);

    public ProfilerDisplayItemPanel(Project project, AuthStatus status) {
        super(new BorderLayout());
        this.project = project;
        this.status = status;
        this.orgPopup = new PrettyListPopup<AuthOrgItem>(project, this::onSelectProfiler, 150);
        this.orgPopup.setVisibleRowCount(8);
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(ShowSwitchIdentifyPopupNotifier.SHOW_SWITCH_IDENTIFY_POPUP_NOTIFIER_TOPIC, this::showSwitchPopup);
        this.addIdentityLabel(status);
        this.addExpandLabel();
        SwingUtil.foreachChildComponent(this, cp -> cp.setBackground(ColorUtil.getToolWindowBackgroundColor()));
        ThreadUtil.execute(this::refreshOrganizations);
    }

    private void addIdentityLabel(AuthStatus status) {
        this.identityPopLabel = this.getIdentityLabel(status);
        this.identityPopLabel.setFont(this.identityPopLabel.getFont().deriveFont(14.0f));
        this.identityPopLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
        this.identityPopLabel.setEnabled(false);
        this.identityPopLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.add((Component)this.identityPopLabel, "West");
    }

    private void addExpandLabel() {
        this.expandLabel = new JLabel(AllIcons.Actions.ArrowExpand);
        this.expandLabel.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)this.expandLabel, "East");
        this.expandLabel.setVisible(false);
    }

    public void refreshOrganizations() {
        if (System.currentTimeMillis() - this.lastRefreshTime.get() < 5000L) {
            LOGGER.debug("skip refresh organizations");
            return;
        }
        CosyStartupAdapter listener = new CosyStartupAdapter(){

            @Override
            public void onStartup() {
                ProfilerDisplayItemPanel.this.updateOrgIds(ProfilerDisplayItemPanel.this.project);
            }
        };
        if (Cosy.INSTANCE.checkCosy(this.project, true, Collections.singletonList(listener))) {
            this.updateOrgIds(this.project);
        }
    }

    private void updateOrgIds(Project project) {
        this.lastRefreshTime.getAndSet(System.currentTimeMillis());
        boolean existOrg = false;
        int currentIndex = 0;
        List<AuthOrgItem> orgItems = LoginUtil.getOrgItems(project, this.status);
        LOGGER.info("get org items: " + orgItems.size());
        if (!orgItems.isEmpty()) {
            for (int i = 0; i < orgItems.size(); ++i) {
                AuthOrgItem org = orgItems.get(i);
                if ("org".equals(org.getType())) {
                    existOrg = true;
                }
                if (!this.status.getOrgId().equals(org.getOrgId())) continue;
                currentIndex = i;
            }
        }
        boolean finalExistOrg = existOrg;
        int finalSelectIndex = currentIndex;
        this.identifyData.getAndSet(new OrgIdentifyData(orgItems, existOrg, currentIndex));
        SwingUtilities.invokeLater(() -> this.updateProfilerUI(orgItems, finalExistOrg, finalSelectIndex));
    }

    private void updateProfilerUI(List<AuthOrgItem> orgItems, boolean existOrg, int currentIndex) {
        if (!existOrg) {
            this.identityPopLabel.setEnabled(false);
            this.identityPopLabel.setIcon(QoderIcons.EditionIndividualDisabledIcon);
            this.expandLabel.setVisible(false);
            if (this.mouseListener != null) {
                SwingUtil.foreachChildComponent(this, component -> {
                    component.setCursor(Cursor.getPredefinedCursor(0));
                    component.removeMouseListener(this.mouseListener);
                });
            }
        } else {
            this.identityPopLabel.setEnabled(true);
            this.identityPopLabel.setIcon(LoginUtil.getProfilerIcon(this.project, this.status));
            this.expandLabel.setVisible(true);
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ProfilerDisplayItemPanel.this.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                    ProfilerDisplayItemPanel.this.identityPopLabel.setForeground(ColorUtil.getPopupMenuSelectionForeground());
                    ProfilerDisplayItemPanel.this.invalidate();
                    ProfilerDisplayItemPanel.this.repaint();
                    OrgIdentifyData data = ProfilerDisplayItemPanel.this.identifyData.get();
                    if (data != null) {
                        ProfilerDisplayItemPanel.this.orgPopup.showLeftOrRight(ProfilerDisplayItemPanel.this, data.orgItems, data.currentIndex);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ProfilerDisplayItemPanel.this.setBackground(ColorUtil.getToolWindowBackgroundColor());
                    ProfilerDisplayItemPanel.this.identityPopLabel.setForeground(ColorUtil.getLabelForegroundColor());
                    ProfilerDisplayItemPanel.this.invalidate();
                    ProfilerDisplayItemPanel.this.repaint();
                }
            };
            SwingUtil.foreachChildComponent(this, component -> {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.addMouseListener(this.mouseListener);
            });
        }
    }

    private void onSelectProfiler(final AuthOrgItem orgItem) {
        LOGGER.info("select profiler info:" + orgItem);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.project, "Switch user identity"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator.setText("Checking service process status");
                if (!Cosy.INSTANCE.checkCosy(ProfilerDisplayItemPanel.this.project) && !Cosy.INSTANCE.checkAndWaitCosyState(indicator, ProfilerDisplayItemPanel.this.project)) {
                    LOGGER.warn("check cosy state error");
                    return;
                }
                indicator.setText("Switching user identity");
                SwitchAccountParams params = null;
                if ("org".equals(orgItem.getType())) {
                    params = SwitchAccountParams.createEnterprise(orgItem.getAliyunUid(), orgItem.getOrgId());
                } else if ("personal".equals(orgItem.getType())) {
                    params = SwitchAccountParams.createIndividual(orgItem.getAliyunUid());
                }
                if (params == null) {
                    LOGGER.warn("select profiler info error, params is null:" + orgItem);
                    return;
                }
                BaseResult result = Cosy.INSTANCE.getLanguageService(ProfilerDisplayItemPanel.this.project).switchAccount(params, 3000L);
                if (result == null) {
                    LOGGER.warn("select profiler info error, result is null:" + orgItem);
                } else if (StringUtils.isNotEmpty((CharSequence)result.getErrorCode())) {
                    LOGGER.warn("select profiler info error, errorMsg is " + result.getErrorMessage() + ",errorCode is " + result.getErrorCode());
                } else {
                    LOGGER.info("select profiler info success:" + orgItem);
                    SwingUtilities.invokeLater(() -> ((QoderProfilerReloadNotifier)ProfilerDisplayItemPanel.this.project.getMessageBus().syncPublisher(QoderProfilerReloadNotifier.PROFILER_RELOAD_NOTIFIER_TOPIC)).reloadProfiler());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/search/component/profiler/ProfilerDisplayItemPanel$3", "run"));
            }
        });
    }

    public void cancelPopup() {
        this.orgPopup.cancel();
    }

    void showSwitchPopup(Component component, RelativePoint point) {
        this.refreshOrganizations();
        OrgIdentifyData data = this.identifyData.get();
        if (data == null) {
            return;
        }
        this.orgPopup.showAtRelativePoint(point, data.orgItems, data.currentIndex, true);
    }

    private JLabel getIdentityLabel(AuthStatus status) {
        Object text = CosyBundle.message("settings.login.panel.identity.enterprise.standard", new Object[0]);
        Icon icon = QoderIcons.EditionEnterpriseStandardDisabledIcon;
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            text = status.getOrgName();
            icon = QoderIcons.EditionEnterpriseDedicatedDisabledIcon;
        } else if (AuthUserTypeEnum.UserTypePersonalStandard.getUserType().equals(status.getUserType()) || StringUtils.isBlank((CharSequence)status.getOrgName())) {
            text = CosyBundle.message("settings.login.panel.identity.individual", new Object[0]);
            if (status.getIsSubAccount() != null && status.getIsSubAccount().booleanValue()) {
                text = (String)text + "\uff08RAM\uff09";
            }
            icon = QoderIcons.EditionIndividualDisabledIcon;
        } else {
            text = status.getOrgName();
            if (AuthUserTypeEnum.UserTypeEnterpriseDedicated.getUserType().equals(status.getUserType())) {
                icon = QoderIcons.EditionEnterpriseDedicatedDisabledIcon;
            }
        }
        if (((String)text).length() > 10) {
            text = ((String)text).substring(0, 10) + "...";
        }
        return new JLabel((String)text, icon, 10);
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
        }
    }

    class OrgIdentifyData {
        List<AuthOrgItem> orgItems;
        boolean existOrg;
        int currentIndex;

        @Generated
        public List<AuthOrgItem> getOrgItems() {
            return this.orgItems;
        }

        @Generated
        public boolean isExistOrg() {
            return this.existOrg;
        }

        @Generated
        public int getCurrentIndex() {
            return this.currentIndex;
        }

        @Generated
        public void setOrgItems(List<AuthOrgItem> orgItems) {
            this.orgItems = orgItems;
        }

        @Generated
        public void setExistOrg(boolean existOrg) {
            this.existOrg = existOrg;
        }

        @Generated
        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrgIdentifyData)) {
                return false;
            }
            OrgIdentifyData other = (OrgIdentifyData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AuthOrgItem> this$orgItems = this.getOrgItems();
            List<AuthOrgItem> other$orgItems = other.getOrgItems();
            if (this$orgItems == null ? other$orgItems != null : !((Object)this$orgItems).equals(other$orgItems)) {
                return false;
            }
            if (this.isExistOrg() != other.isExistOrg()) {
                return false;
            }
            return this.getCurrentIndex() == other.getCurrentIndex();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OrgIdentifyData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AuthOrgItem> $orgItems = this.getOrgItems();
            result = result * 59 + ($orgItems == null ? 43 : ((Object)$orgItems).hashCode());
            result = result * 59 + (this.isExistOrg() ? 79 : 97);
            result = result * 59 + this.getCurrentIndex();
            return result;
        }

        @Generated
        public String toString() {
            return "ProfilerDisplayItemPanel.OrgIdentifyData(orgItems=" + this.getOrgItems() + ", existOrg=" + this.isExistOrg() + ", currentIndex=" + this.getCurrentIndex() + ")";
        }

        @Generated
        public OrgIdentifyData(List<AuthOrgItem> orgItems, boolean existOrg, int currentIndex) {
            this.orgItems = orgItems;
            this.existOrg = existOrg;
            this.currentIndex = currentIndex;
        }
    }
}

