/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.textpane;

import com.intellij.openapi.diagnostic.Logger;
import javax.swing.SizeRequirements;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ChatStyledEditorKit
extends StyledEditorKit {
    private static final Logger LOGGER = Logger.getInstance(ChatStyledEditorKit.class);
    private static final int MAX_HEIGHT = 24;

    @Override
    public ViewFactory getViewFactory() {
        return new ChatInputStyledViewFactory();
    }

    static class CustomLabelView
    extends LabelView {
        public CustomLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getAlignment(int axis) {
            if (axis == 1) {
                return 0.55f;
            }
            return super.getAlignment(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            float result = super.getMaximumSpan(axis);
            if (axis == 1) {
                result = Math.max(result, 24.0f);
            }
            return result;
        }

        @Override
        public float getMinimumSpan(int axis) {
            float result = super.getMinimumSpan(axis);
            if (axis == 1) {
                result = Math.max(result, 24.0f);
            } else if (axis == 0) {
                return 0.0f;
            }
            return result;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float result = super.getPreferredSpan(axis);
            return result;
        }

        public float getOriginPreferredSpan(int axis) {
            return super.getPreferredSpan(axis);
        }
    }

    static class CenteredComponentView
    extends ComponentView {
        public CenteredComponentView(Element elem) {
            super(elem);
        }

        @Override
        public float getAlignment(int axis) {
            if (axis == 1) {
                return 0.5f;
            }
            return super.getAlignment(axis);
        }
    }

    static class CustomParagraphView
    extends ParagraphView {
        public CustomParagraphView(Element elem) {
            super(elem);
        }

        @Override
        public float getMaximumSpan(int axis) {
            float result = super.getMaximumSpan(axis);
            if (axis == 1) {
                result = Math.max(result, 24.0f);
            }
            return result;
        }

        @Override
        public float getMinimumSpan(int axis) {
            float result = super.getMinimumSpan(axis);
            if (axis == 1) {
                result = Math.max(result, 24.0f);
            }
            return result;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float result = super.getPreferredSpan(axis);
            if (axis == 1) {
                result = Math.max(result, 24.0f);
            }
            return result;
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            if (r == null) {
                r = new SizeRequirements();
            }
            float pref = this.layoutPool.getPreferredSpan(axis);
            float min = this.layoutPool.getMinimumSpan(axis);
            r.minimum = (int)min;
            r.preferred = Math.max(r.minimum, (int)pref);
            r.maximum = Integer.MAX_VALUE;
            r.alignment = 0.5f;
            return r;
        }

        @Override
        protected void layout(int width, int height) {
            try {
                super.layout(Math.max(width, 1), height);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    static class ChatInputStyledViewFactory
    implements ViewFactory {
        ChatInputStyledViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new CustomLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new CustomParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new CenteredComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new CustomLabelView(elem);
        }
    }
}

