/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.context.tool.BaseToolContextProvider;
import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileStatusEnum;
import com.alibabacloud.intellij.qoder.chat.enums.aidev.AIDevFileUsageEnum;
import com.alibabacloud.intellij.qoder.chat.model.LineRange;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.tool.excutor.TerminalCommandExecutor;
import com.alibabacloud.intellij.qoder.ui.chat.AIDevFilePanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.common.ToolCallConstant;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.RunInTerminalToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCountStyleEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.task.TaskResponseItem;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.task.TaskTreeItem;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.OpenMemoryRecordPageNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.tool.ToolRunInTerminalOpenTerminalNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.FontUtil;
import com.alibabacloud.intellij.qoder.util.IconUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.alibabacloud.intellij.qoder.util.TerminalUtils;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class ToolPanel
extends JPanel {
    private static final Logger log = Logger.getInstance(ToolPanel.class);
    private static final int CORNER_RADIUS = 8;
    private static final int ERROR_LABEL_TOOL_TIP_WIDTH = 312;
    private Project project;
    public String toolCallId;
    public AtomicReference<Boolean> titlePanelIsHover = new AtomicReference<Boolean>(false);
    private ToolTypeEnum toolTypeEnum;
    private BaseToolContextProvider toolContextProvider;
    private AtomicReference<ToolCallInfo> toolCallInfo = new AtomicReference();
    JPanel basePanel;
    AIDevFilePanel aiDevFilePanel;
    JPanel titlePanel;
    Box titleAndStatusBox;
    JLabel statusIcon;
    JLabel titleLabel;
    Box scopeBox;
    JComponent scopeLabel;
    Box resultAndOperateBox;
    JLabel resultCountLabel;
    JLabel viewMemoryBtn;
    JLabel backgroundLabel;
    JLabel runBackgroundLabel;
    JLabel cancelLabel;
    JLabel expandCollapseBtn;
    ToolApprovalPanel toolApprovalPanel;
    ToolDetailPanel toolDetailPanel;
    JLabel errorLabel;
    Box toolAutoRunChooser;
    boolean isWeekUI;
    JLabel toolRunTipLabel;
    boolean hasRiskOrInDenyList;
    GenerateAnswerPanel generateAnswerPanel;
    MessageBusConnection messageBusConnection;

    public ToolPanel(Project project, GenerateAnswerPanel generateAnswerPanel, String toolName, String toolCallId, String toolCallStatus) {
        log.debug("init tool panel, toolName: " + toolName + ", toolCallId: " + toolCallId + ", toolCallStatus: " + toolCallStatus);
        this.project = project;
        this.generateAnswerPanel = generateAnswerPanel;
        this.toolCallId = toolCallId;
        this.toolTypeEnum = ToolTypeEnum.getByToolName(toolName);
        this.toolContextProvider = this.toolTypeEnum.getToolContextProvider();
        this.toolCallInfo.set(new ToolCallInfo(generateAnswerPanel.getSessionId(), generateAnswerPanel.getRequestId(), toolName, toolCallId, toolCallStatus));
        this.toolAutoRunChooser = null;
        this.isWeekUI = this.toolTypeEnum.isWeekUi();
        this.hasRiskOrInDenyList = false;
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.setBackground(ColorUtil.getChatCardBackgroundColor());
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)this.basePanel, "Center");
        this.toolDetailPanel = this.toolContextProvider.initToolDetailPanel(project, this);
        if (this.toolDetailPanel != null) {
            this.toolDetailPanel.getComponent().setVisible(this.toolContextProvider.showDetailPanelDefault());
            this.basePanel.add((Component)this.toolDetailPanel.getComponent(), "South");
        }
        this.titlePanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                if (ToolPanel.this.isToolApprovalPanelVisible() || ToolPanel.this.isToolDetailPanelVisible()) {
                    int halfHeight = height / 2;
                    int quarterHeight = height / 4;
                    RoundRectangle2D.Float upperRoundRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, halfHeight, 8.0f, 8.0f);
                    Rectangle lowerRect = new Rectangle(0, quarterHeight, width, height - quarterHeight);
                    if (ToolTypeEnum.RUN_IN_TERMINAL.getToolName().equals(ToolPanel.this.toolTypeEnum.getToolName()) && ToolPanel.this.isToolCallFinished() && !ToolPanel.this.titlePanelIsHover.get().booleanValue() && !ToolPanel.this.isTerminalDetailsPanelHover()) {
                        g2.setColor(ColorUtil.getToolWindowBackgroundColor());
                    } else {
                        g2.setColor(ToolPanel.this.isWeekUI ? ColorUtil.getChatCardChildBackgroundColor() : ColorUtil.getEditorBackgroundColor());
                    }
                    g2.fill(upperRoundRect);
                    g2.fill(lowerRect);
                } else {
                    RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, 8.0f, 8.0f);
                    g2.setColor(ToolPanel.this.isWeekUI ? ColorUtil.getChatCardChildBackgroundColor() : (ToolPanel.this.titlePanelIsHover.get() != false ? ColorUtil.getEditorBackgroundColor() : ColorUtil.getToolWindowBackgroundColor()));
                    g2.fill(roundRect);
                }
                this.paintChildren(g2);
                g2.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ToolPanel.this.isWeekUI ? 24 : 28);
            }
        };
        this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)(this.isWeekUI ? 0 : 8)));
        this.titlePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        MouseAdapter mouseAdapter = this.myMouseAdapter();
        this.titlePanel.addMouseListener(mouseAdapter);
        this.titleAndStatusBox = Box.createHorizontalBox();
        ToolCallStatusEnum toolCallStatusEnum = ToolCallStatusEnum.getStatus(toolCallStatus);
        this.titleLabel = new JLabel(this.toolContextProvider.getToolNameAndStatus(toolCallStatusEnum, toolName));
        this.titleLabel.setIcon(this.isWeekUI ? null : this.toolContextProvider.getIcon(toolCallStatusEnum));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(0, 12.0f));
        this.titleLabel.setForeground(this.toolContextProvider.getTitleLabelForegroundColor());
        this.titleAndStatusBox.add(this.titleLabel);
        this.titleAndStatusBox.add(Box.createHorizontalStrut(8));
        this.titlePanel.add((Component)this.titleAndStatusBox, "West");
        this.scopeBox = Box.createHorizontalBox();
        this.scopeLabel = this.toolContextProvider.getScopeLabel(project, this.toolCallInfo.get(), this.getScopeSize());
        if (this.scopeLabel != null) {
            this.resetScopeLabelDimension();
            this.scopeBox.add(this.scopeLabel);
        }
        this.titlePanel.add((Component)this.scopeBox, "Center");
        this.scopeBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ToolPanel.this.titlePanel.getWidth() > 0) {
                    ToolPanel.this.repaintScopeLabel();
                }
            }
        });
        this.resultAndOperateBox = Box.createHorizontalBox();
        this.titlePanel.add((Component)this.resultAndOperateBox, "East");
        SwingUtil.foreachChildComponent(this.titlePanel, cp -> {
            cp.addMouseListener(mouseAdapter);
            if (this.isWeekUI) {
                cp.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            }
            cp.setCursor(Cursor.getPredefinedCursor(12));
        });
        this.basePanel.add((Component)this.titlePanel, "North");
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(ToolRunInTerminalOpenTerminalNotifier.TOOL_RUN_IN_TERMINAL_OPEN_TERMINAL_NOTIFICATION, this::openTerminalWindowNotify);
    }

    private void repaintScopeLabel() {
        this.scopeBox.removeAll();
        int maxWidth = this.getScopeSize();
        this.scopeLabel = this.toolContextProvider.getScopeLabel(this.project, this.toolCallInfo.get(), maxWidth);
        if (this.scopeLabel != null) {
            this.resetScopeLabelDimension();
            this.scopeBox.add(this.scopeLabel);
            SwingUtil.foreachChildComponent(this.scopeBox, cp -> cp.addMouseListener(this.myMouseAdapter()));
        }
    }

    private int getScopeSize() {
        return this.scopeBox.getWidth();
    }

    private void resetScopeLabelDimension() {
        if (this.titleLabel != null) {
            Dimension dimension = new Dimension(this.scopeLabel.getPreferredSize().width, this.titleLabel.getHeight());
            this.scopeLabel.setPreferredSize(dimension);
            this.scopeLabel.setMinimumSize(dimension);
        }
    }

    public void syncToolCall(ToolCallSyncResult result) {
        ToolCallInfo toolCall;
        ToolCallStatusEnum toolCallStatusEnum;
        log.info("syncToolCall result=" + JSONObject.toJSONString((Object)result));
        String toolCallId = result.getToolCallId();
        if (StringUtils.isBlank((String)toolCallId) || !toolCallId.equals(this.toolCallInfo.get().getToolCallId())) {
            log.debug("toolCallId is null or not current tool:" + toolCallId);
            return;
        }
        ToolCallInfo updateToolCallInfo = this.toolCallInfo.get();
        updateToolCallInfo.setToolCallStatus(result.getToolCallStatus());
        updateToolCallInfo.setParameters(result.getParameters());
        updateToolCallInfo.setResults(result.getResults());
        updateToolCallInfo.setErrorCode(result.getErrorCode());
        updateToolCallInfo.setErrorMsg(result.getErrorMsg());
        this.toolCallInfo.set(updateToolCallInfo);
        String toolName = updateToolCallInfo.getToolName();
        if (ToolTypeEnum.EDIT_FILE.getToolName().equals(toolName) || ToolTypeEnum.DELETE_FILE.getToolName().equals(toolName) || ToolTypeEnum.CREATE_FILE.getToolName().equals(toolName) || ToolTypeEnum.SEARCH_REPLACE.getToolName().equals(toolName)) {
            if (this.aiDevFilePanel == null && result.getParameters() != null && result.getResults() != null) {
                String filePath = "";
                Map<String, Object> fileParams = result.getParameters();
                if (fileParams.containsKey("file_path")) {
                    filePath = (String)fileParams.get("file_path");
                }
                String id = "";
                Map<String, Object> fileResult = result.getResults().get(0);
                if (fileResult.containsKey("fileId")) {
                    id = (String)fileResult.get("fileId");
                }
                if (StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)id)) {
                    log.warn("syncToolCall edit file id or path is blank, result=" + JSONObject.toJSONString((Object)result));
                    return;
                }
                List<AIDevFilePanel.FileItem> referenceItems = this.getFileItemsFromBlock(result.getSessionId(), filePath, id);
                this.aiDevFilePanel = new AIDevFilePanel(this.project, AIDevFileUsageEnum.TOOL_PANEL, referenceItems);
                this.setBorder((Border)JBUI.Borders.empty());
                this.basePanel.removeAll();
                this.basePanel.add(this.aiDevFilePanel);
                this.basePanel.revalidate();
                this.basePanel.repaint();
                this.generateAnswerPanel.moveScrollToBottom(false);
            } else if (this.aiDevFilePanel == null) {
                if (ToolCallStatusEnum.CANCELLED.getStatus().equals(updateToolCallInfo.getToolCallStatus())) {
                    ToolCallStatusEnum toolCallStatusEnum2 = ToolCallStatusEnum.getStatus(updateToolCallInfo.getToolCallStatus());
                    if (toolCallStatusEnum2 != null) {
                        this.titleLabel.setIcon(this.toolContextProvider.getIcon(toolCallStatusEnum2));
                        this.titleLabel.setText(this.toolContextProvider.getToolNameAndStatus(toolCallStatusEnum2, toolName));
                    }
                } else if (ToolCallStatusEnum.ERROR.getStatus().equals(updateToolCallInfo.getToolCallStatus())) {
                    ToolCallStatusEnum toolCallStatusEnum3 = ToolCallStatusEnum.getStatus(updateToolCallInfo.getToolCallStatus());
                    if (toolCallStatusEnum3 != null) {
                        this.titleLabel.setIcon(this.toolContextProvider.getIcon(toolCallStatusEnum3));
                        this.titleLabel.setText(this.toolContextProvider.getToolNameAndStatus(toolCallStatusEnum3, toolName));
                    }
                    if (this.errorLabel == null) {
                        this.errorLabel = new JLabel(CommonIcons.infoIcon);
                        this.errorLabel.setCursor(Cursor.getPredefinedCursor(12));
                        this.errorLabel.setToolTipText(BaseToolContextProvider.getErrorMsg(result.getErrorCode(), result.getErrorMsg()));
                        this.titleAndStatusBox.add(this.errorLabel);
                        this.titleAndStatusBox.add(Box.createHorizontalStrut(8));
                        this.titleAndStatusBox.repaint();
                    }
                }
            }
            return;
        }
        if ((ToolTypeEnum.ADD_TASKS.getToolName().equals(toolName) || ToolTypeEnum.UPDATE_TASKS.getToolName().equals(toolName)) && CollectionUtils.isNotEmpty(updateToolCallInfo.getResults())) {
            TaskResponseItem item = (TaskResponseItem)JSONObject.parseObject((String)JSONObject.toJSONString(updateToolCallInfo.getResults().get(0)), TaskResponseItem.class);
            if (null != item && null != item.getDetailPlan() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getDetailPlan().getTaskTreeJson())) {
                TaskTreeItem taskTreeItem = (TaskTreeItem)JSONObject.parseObject((String)item.getDetailPlan().getTaskTreeJson(), TaskTreeItem.class);
                if (null != taskTreeItem && CollectionUtils.isNotEmpty(taskTreeItem.getTasks())) {
                    this.generateAnswerPanel.getGenerateContentForm().reloadTodoViewPanel(taskTreeItem.getTasks());
                } else {
                    log.warn("syncToolCall failed taskTreeItem=" + item.getDetailPlan().getTaskTreeJson());
                }
            } else {
                log.warn("syncToolCall failed item result=" + JSONObject.toJSONString(updateToolCallInfo.getResults().get(0)));
            }
        }
        if ((toolCallStatusEnum = ToolCallStatusEnum.getStatus(updateToolCallInfo.getToolCallStatus())) != null) {
            this.titleLabel.setIcon(this.toolContextProvider.getIcon(toolCallStatusEnum));
            this.titleLabel.setText(this.toolContextProvider.getToolNameAndStatus(toolCallStatusEnum, toolName));
            this.titleLabel.setForeground(this.toolContextProvider.getTitleLabelForegroundColor());
        }
        if (toolCallStatusEnum != null && ToolCallStatusEnum.PENDING.getStatus().equals(toolCallStatusEnum.getStatus())) {
            this.toolApprovalPanel = this.toolContextProvider.initToolApprovalPanel(this.project, this);
            if (this.toolApprovalPanel != null) {
                if (this.toolTypeEnum == ToolTypeEnum.SEARCH_WEB || this.toolTypeEnum == ToolTypeEnum.FETCH_CONTENT) {
                    this.isWeekUI = false;
                }
                this.toolApprovalPanel.initToolApprovalPanel(this.project, this.toolCallInfo.get());
                this.basePanel.add((Component)this.toolApprovalPanel.getComponent(), "Center");
                this.basePanel.revalidate();
                this.basePanel.repaint();
                this.generateAnswerPanel.moveScrollToBottom(true);
            }
        } else if (this.toolApprovalPanel != null && this.toolApprovalPanel.getComponent() != null) {
            this.toolApprovalPanel.getComponent().setVisible(false);
            this.basePanel.remove(this.toolApprovalPanel.getComponent());
            if (!this.hasRiskOrInDenyList) {
                this.toolAutoRunChooser.setVisible(false);
            }
            if (this.toolTypeEnum == ToolTypeEnum.SEARCH_WEB || this.toolTypeEnum == ToolTypeEnum.FETCH_CONTENT) {
                this.isWeekUI = true;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.titlePanel.repaint();
            } else {
                SwingUtilities.invokeLater(() -> this.titlePanel.repaint());
            }
        }
        if (toolCallStatusEnum != null && ToolCallStatusEnum.ERROR.getStatus().equals(toolCallStatusEnum.getStatus()) && this.errorLabel == null) {
            this.errorLabel = new JLabel(CommonIcons.infoIcon);
            this.errorLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.errorLabel.setToolTipText(this.buildErrorMsg(result.getErrorCode(), result.getErrorMsg()));
            this.titleAndStatusBox.add(this.errorLabel);
            this.titleAndStatusBox.add(Box.createHorizontalStrut(8));
            this.titleAndStatusBox.repaint();
        }
        if (ToolCountStyleEnum.COUNT_AND_DOWN_ARROW == this.toolContextProvider.needRenderResultCount()) {
            if (this.toolCallInfo.get().getResults() != null) {
                boolean resultNotEmpty = !this.toolCallInfo.get().getResults().isEmpty();
                this.resultCountLabel = new JLabel(this.toolCallInfo.get().getResults().size() + " " + CosyBundle.message("tool.text.results", new Object[0]));
                this.resultCountLabel.setFont(this.resultCountLabel.getFont().deriveFont(0, 12.0f));
                this.resultCountLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                if (resultNotEmpty) {
                    this.resultCountLabel.setCursor(Cursor.getPredefinedCursor(12));
                }
                this.resultAndOperateBox.add(this.resultCountLabel);
                this.resultAndOperateBox.add(Box.createHorizontalStrut(4));
                if (resultNotEmpty) {
                    this.expandCollapseBtn = new JLabel(QoderIcons.ExpandGrey16Icon);
                    this.expandCollapseBtn.setPreferredSize(new Dimension(16, 16));
                    this.expandCollapseBtn.setCursor(Cursor.getPredefinedCursor(12));
                    this.resultAndOperateBox.add(this.expandCollapseBtn);
                } else {
                    this.resultAndOperateBox.add(Box.createHorizontalStrut(16));
                }
                SwingUtil.foreachChildComponent(this.resultAndOperateBox, cp -> cp.addMouseListener(this.myMouseAdapter()));
            }
        } else if (ToolCountStyleEnum.DOWN_ARROW == this.toolContextProvider.needRenderResultCount()) {
            boolean resultNotEmpty = CollectionUtils.isNotEmpty(this.toolCallInfo.get().getResults());
            boolean paramsNotEmpty = MapUtils.isNotEmpty(this.toolCallInfo.get().getParameters());
            boolean finished = ToolCallStatusEnum.isFinished(this.toolCallInfo.get().getToolCallStatus());
            if (finished && (resultNotEmpty || paramsNotEmpty)) {
                this.expandCollapseBtn = new JLabel(QoderIcons.ExpandGrey16Icon);
                this.expandCollapseBtn.setPreferredSize(new Dimension(16, 16));
                this.expandCollapseBtn.setCursor(Cursor.getPredefinedCursor(12));
                this.resultAndOperateBox.add(this.expandCollapseBtn);
                SwingUtil.foreachChildComponent(this.resultAndOperateBox, cp -> cp.addMouseListener(this.myMouseAdapter()));
            }
        } else if (ToolTypeEnum.UPDATE_MEMORY.getToolName().equals(toolName) && CollectionUtils.isNotEmpty(this.toolCallInfo.get().getResults())) {
            final String id = (String)this.toolCallInfo.get().getResults().get(0).get("id");
            if (StringUtils.isNotBlank((String)id)) {
                this.viewMemoryBtn = new JLabel(CosyBundle.message("tool.add.memory.text.view", new Object[0]));
                this.viewMemoryBtn.setFont(this.viewMemoryBtn.getFont().deriveFont(0, 13.0f));
                this.viewMemoryBtn.setForeground(ColorUtil.getLinkForegroundColor());
                this.viewMemoryBtn.setCursor(Cursor.getPredefinedCursor(12));
                this.viewMemoryBtn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            ((OpenMemoryRecordPageNotifier)ToolPanel.this.project.getMessageBus().syncPublisher(OpenMemoryRecordPageNotifier.OPEN_MEMORY_RECORD_PAGE_NOTIFIER)).openMemoryRecordPage(id);
                        }
                        catch (Exception ex) {
                            log.warn("fail to send message. " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
                this.resultAndOperateBox.add(this.viewMemoryBtn);
            }
        } else if (ToolTypeEnum.RUN_IN_TERMINAL.getToolName().equals(toolName) && ToolCallConstant.checkTerminalDisabled(toolCall = this.toolCallInfo.get()) == null && toolCall.getParameters() != null && toolCall.getParameters().containsKey("is_background")) {
            boolean background = BooleanUtils.isTrue((Boolean)ToolCallConstant.isTerminalRunInBackground(toolCall));
            if (background) {
                if (this.backgroundLabel == null) {
                    this.configBackgroundLabel();
                    this.resultAndOperateBox.add(this.backgroundLabel);
                }
            } else if (toolCall.getToolCallStatus() != null && ToolCallStatusEnum.RUNNING.getStatus().equals(toolCall.getToolCallStatus())) {
                TerminalCommandExecutor executor = TerminalUtils.getTerminalCommandExecutor(toolCall.getToolCallId());
                if (executor != null) {
                    this.initTerminalOperatePanel(toolCall, false);
                } else {
                    this.waitForTerminalStartup(toolCall);
                }
            } else if (this.resultAndOperateBox != null && this.runBackgroundLabel != null) {
                this.resultAndOperateBox.removeAll();
                if (null != this.backgroundLabel) {
                    this.resultAndOperateBox.add(this.backgroundLabel);
                }
                if (this.hasRiskOrInDenyList) {
                    this.addFillerForResultOperateBox();
                    this.resultAndOperateBox.add(this.toolAutoRunChooser);
                }
            }
        }
        if (this.toolDetailPanel != null) {
            this.toolDetailPanel.refreshToolDetailPanel(this.toolCallInfo.get());
        }
        if (this.isWeekUI) {
            this.titleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.titleLabel.setIcon(null);
            this.titlePanel.setBorder((Border)JBUI.Borders.empty());
        } else {
            this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        }
        this.repaintScopeLabel();
        this.titlePanel.revalidate();
        this.titlePanel.repaint();
    }

    private void configBackgroundLabel() {
        this.backgroundLabel = new JLabel(CosyBundle.message("tool.run.terminal.text.background", new Object[0]));
        this.backgroundLabel.setFont(this.backgroundLabel.getFont().deriveFont(0, 12.0f));
        this.backgroundLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
    }

    private String buildErrorMsg(String errorCode, String errorMsg) {
        String errorMessage = BaseToolContextProvider.getErrorMsg(errorCode, errorMsg);
        FontMetrics fm = FontUtil.fontMetrics(this.errorLabel, this.errorLabel.getFont());
        int textWidth = fm.stringWidth(errorMessage);
        if (textWidth < 312) {
            return StringEscapeUtils.unescapeHtml4((String)errorMessage);
        }
        return "<html><body width='312'>" + StringEscapeUtils.unescapeHtml4((String)errorMessage) + "</body></html>";
    }

    private void waitForTerminalStartup(ToolCallInfo toolCallInfo) {
        CompletableFuture.runAsync(() -> {
            try {
                String toolCallId = toolCallInfo.getToolCallId();
                boolean isReady = ToolPanel.waitUntilReady(toolCallId);
                if (isReady) {
                    SwingUtilities.invokeLater(() -> this.initTerminalOperatePanel(toolCallInfo, true));
                } else {
                    log.warn("waiting for terminal startup timeout,toolCallId=" + toolCallId);
                }
            }
            catch (Exception e) {
                log.warn("Error waiting for terminal startup", (Throwable)e);
            }
        });
    }

    private static boolean waitUntilReady(String toolCallId) {
        long startTime = System.currentTimeMillis();
        long timeoutMs = 10000L;
        while (System.currentTimeMillis() - startTime < timeoutMs) {
            TerminalCommandExecutor executor = TerminalUtils.getTerminalCommandExecutor(toolCallId);
            if (executor != null) {
                log.debug("waitUntilReady finish," + (System.currentTimeMillis() - startTime));
                return true;
            }
            ThreadUtil.sleep(100L);
        }
        return false;
    }

    private void initTerminalOperatePanel(final ToolCallInfo toolCallInfo, boolean async) {
        this.runBackgroundLabel = new JLabel(CosyBundle.message("tool.run.terminal.operation.run.background", new Object[0]));
        this.runBackgroundLabel.setFont(this.runBackgroundLabel.getFont().deriveFont(0, 12.0f));
        this.runBackgroundLabel.setForeground(ColorUtil.getLinkForegroundColor());
        this.runBackgroundLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.runBackgroundLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TerminalCommandExecutor executor = TerminalUtils.getTerminalCommandExecutor(toolCallInfo.getToolCallId());
                if (executor != null) {
                    log.debug("runBackgroundLabel mouseClicked, toolCallId=" + toolCallInfo.getToolCallId());
                    executor.runInBackground();
                    ToolPanel.this.configBackgroundLabel();
                } else {
                    log.warn("runBackgroundLabel mouseClicked,executor is null,toolCallId=" + toolCallInfo.getToolCallId());
                }
            }
        });
        this.addFillerForResultOperateBox();
        this.resultAndOperateBox.add(this.runBackgroundLabel);
        this.cancelLabel = new JLabel(CosyBundle.message("tool.run.terminal.operation.cancel", new Object[0]));
        this.cancelLabel.setFont(this.cancelLabel.getFont().deriveFont(0, 12.0f));
        this.cancelLabel.setForeground(ColorUtil.getLinkForegroundColor());
        this.cancelLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.cancelLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TerminalCommandExecutor executor = TerminalUtils.getTerminalCommandExecutor(toolCallInfo.getToolCallId());
                if (executor != null) {
                    log.debug("cancelLabel mouseClicked, toolCallId=" + toolCallInfo.getToolCallId());
                    executor.cancel();
                } else {
                    log.warn("cancelLabel mouseClicked,executor is null,toolCallId=" + toolCallInfo.getToolCallId());
                }
            }
        });
        this.resultAndOperateBox.add(Box.createHorizontalStrut(8));
        this.resultAndOperateBox.add(this.cancelLabel);
        this.resultAndOperateBox.revalidate();
        this.resultAndOperateBox.repaint();
    }

    private void addFillerForResultOperateBox() {
        if (this.resultAndOperateBox.getComponentCount() != 0) {
            this.resultAndOperateBox.add(Box.createHorizontalStrut(8));
        }
    }

    private void openTerminalWindowNotify(String toolCallId) {
        if (StringUtils.isNotBlank((String)toolCallId) && this.toolCallInfo.get() != null && toolCallId.equals(this.toolCallInfo.get().getToolCallId())) {
            this.generateAnswerPanel.moveScrollToBottom(false);
        }
    }

    private void toggleDetailPanel() {
        if (this.toolDetailPanel == null || this.expandCollapseBtn == null) {
            return;
        }
        if (this.toolDetailPanel.getComponent().isShowing()) {
            this.toolDetailPanel.getComponent().setVisible(false);
            this.expandCollapseBtn.setIcon(QoderIcons.ExpandGrey16Icon);
        } else {
            this.toolDetailPanel.refreshToolDetailPanel(this.toolCallInfo.get());
            this.toolDetailPanel.getComponent().setVisible(true);
            this.toolDetailPanel.getComponent().revalidate();
            this.toolDetailPanel.getComponent().repaint();
            this.expandCollapseBtn.setIcon(QoderIcons.ShrinkGrey16Icon);
        }
    }

    private boolean isToolDetailPanelVisible() {
        return this.toolDetailPanel != null && this.toolDetailPanel.getComponent() != null && this.toolDetailPanel.getComponent().isVisible();
    }

    private boolean isToolApprovalPanelVisible() {
        return this.toolApprovalPanel != null && this.toolApprovalPanel.getComponent() != null && this.toolApprovalPanel.getComponent().isVisible();
    }

    private boolean isToolCallFinished() {
        if (this.toolCallInfo.get() == null) {
            return false;
        }
        return ToolCallStatusEnum.isFinished(this.toolCallInfo.get().getToolCallStatus());
    }

    private List<AIDevFilePanel.FileItem> getFileItemsFromBlock(String sessionId, String filePath, String workingItemId) {
        ArrayList<AIDevFilePanel.FileItem> fileItemList = new ArrayList<AIDevFilePanel.FileItem>();
        fileItemList.add(this.constructFileItem(sessionId, filePath, workingItemId));
        return fileItemList;
    }

    private @NotNull AIDevFilePanel.FileItem constructFileItem(String sessionId, String filePath, String workingItemId) {
        String fileName = FileUtil.getFileName(filePath);
        AIDevFilePanel.FileItem fileItem = new AIDevFilePanel.FileItem();
        fileItem.setName(fileName);
        fileItem.setStatus(AIDevFileStatusEnum.GENERATING);
        fileItem.setPath(filePath);
        fileItem.setFileId(filePath);
        fileItem.setId(workingItemId);
        fileItem.setIcon(IconUtil.getFileTypeIcon(this.project, filePath));
        fileItem.setSessionId(sessionId);
        AIDevFilePanel.FileItem fileItem2 = fileItem;
        if (fileItem2 == null) {
            ToolPanel.$$$reportNull$$$0(0);
        }
        return fileItem2;
    }

    private MouseAdapter myMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                ToolPanel.this.titlePanelIsHover.set(true);
                if (ToolPanel.this.isToolDetailPanelVisible() && ToolPanel.this.toolDetailPanel instanceof RunInTerminalToolDetailPanel) {
                    RunInTerminalToolDetailPanel runInTerminalToolPanel = (RunInTerminalToolDetailPanel)ToolPanel.this.toolDetailPanel;
                    runInTerminalToolPanel.repaintBackground();
                    runInTerminalToolPanel.getComponent().repaint();
                }
                if (ToolPanel.this.toolTypeEnum.isWeekUi()) {
                    SwingUtil.foreachChildComponent(ToolPanel.this.titlePanel, cp -> {
                        if (cp != ToolPanel.this.viewMemoryBtn) {
                            cp.setForeground(ColorUtil.getTextForegroundColor());
                        }
                    });
                }
                ToolPanel.this.repaint();
                e.consume();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (ToolTypeEnum.READ_FILE.getToolName().equals(ToolPanel.this.toolTypeEnum.getToolName())) {
                    String path;
                    Map<String, Object> result;
                    LineRange lineRange = null;
                    List<Map<String, Object>> results = ToolPanel.this.toolCallInfo.get().getResults();
                    if (results != null && !results.isEmpty() && (result = results.get(0)).containsKey("path") && StringUtils.isNotBlank((String)(path = (String)result.get("path")))) {
                        if (result.containsKey("startLine") && result.containsKey("endLine")) {
                            lineRange = new LineRange(((Double)result.get("startLine")).intValue() - 1, ((Double)result.get("endLine")).intValue() - 1);
                        }
                        EditorUtil.openEditorFile(ToolPanel.this.project, path, lineRange, ToolPanel.this.titlePanel);
                        return;
                    }
                    String filePath = ToolPanel.this.toolContextProvider.getParamValue(ToolPanel.this.toolCallInfo.get(), "file_path");
                    if (StringUtils.isNotBlank((String)filePath)) {
                        Map<String, Object> params = ToolPanel.this.toolCallInfo.get().getParameters();
                        if (null != params && params.containsKey("start_line") && params.containsKey("end_line")) {
                            lineRange = new LineRange(((Double)params.get("start_line")).intValue(), ((Double)params.get("end_line")).intValue());
                        }
                        EditorUtil.openEditorFile(ToolPanel.this.project, filePath, lineRange, ToolPanel.this.titlePanel);
                    }
                } else if (ToolTypeEnum.FETCH_CONTENT.getToolName().equals(ToolPanel.this.toolTypeEnum.getToolName())) {
                    String url = ToolPanel.this.toolContextProvider.getParamValue(ToolPanel.this.toolCallInfo.get(), "url");
                    if (StringUtils.isNotBlank((String)url)) {
                        try {
                            BrowserUtil.browse((String)url.trim());
                        }
                        catch (Exception ex) {
                            log.warn("browse url error", (Throwable)ex);
                        }
                    }
                } else {
                    ToolPanel.this.toggleDetailPanel();
                }
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                ToolPanel.this.titlePanelIsHover.set(false);
                if (ToolPanel.this.isToolDetailPanelVisible() && ToolPanel.this.toolDetailPanel instanceof RunInTerminalToolDetailPanel) {
                    RunInTerminalToolDetailPanel runInTerminalToolPanel = (RunInTerminalToolDetailPanel)ToolPanel.this.toolDetailPanel;
                    runInTerminalToolPanel.repaintBackground();
                    runInTerminalToolPanel.getComponent().repaint();
                }
                if (ToolPanel.this.toolTypeEnum.isWeekUi()) {
                    SwingUtil.foreachChildComponent(ToolPanel.this.titlePanel, cp -> {
                        if (cp != ToolPanel.this.viewMemoryBtn) {
                            cp.setForeground(ColorUtil.getAuxiliaryForegroundColor());
                        }
                    });
                }
                ToolPanel.this.repaint();
                e.consume();
            }
        };
    }

    void updateUiTexts() {
        ToolCallInfo toolCall = this.toolCallInfo.get();
        if (toolCall == null) {
            return;
        }
        if (this.titleLabel != null) {
            ToolCallStatusEnum toolCallStatusEnum = ToolCallStatusEnum.getStatus(toolCall.getToolCallStatus());
            this.titleLabel.setText(this.toolContextProvider.getToolNameAndStatus(toolCallStatusEnum, toolCall.getToolName()));
        }
        if (this.resultCountLabel != null) {
            this.resultCountLabel.setText(this.toolCallInfo.get().getResults().size() + " " + CosyBundle.message("tool.text.results", new Object[0]));
        }
        if (this.viewMemoryBtn != null) {
            this.viewMemoryBtn.setText(CosyBundle.message("tool.add.memory.text.view", new Object[0]));
        }
        if (this.backgroundLabel != null) {
            this.backgroundLabel.setText(CosyBundle.message("tool.run.terminal.text.background", new Object[0]));
        }
        if (this.runBackgroundLabel != null) {
            this.runBackgroundLabel.setText(CosyBundle.message("tool.run.terminal.operation.run.background", new Object[0]));
        }
        if (this.cancelLabel != null) {
            this.cancelLabel.setText(CosyBundle.message("tool.run.terminal.operation.cancel", new Object[0]));
        }
        if (this.toolApprovalPanel != null) {
            this.toolApprovalPanel.updateUiTexts();
        }
        if (this.toolDetailPanel != null) {
            this.toolDetailPanel.updateUiTexts();
        }
        if (this.toolRunTipLabel != null) {
            this.toolContextProvider.updateToolRunTipText(this.toolRunTipLabel);
        }
    }

    private boolean isTerminalDetailsPanelHover() {
        if (this.isToolDetailPanelVisible() && this.toolDetailPanel instanceof RunInTerminalToolDetailPanel) {
            RunInTerminalToolDetailPanel run = (RunInTerminalToolDetailPanel)this.toolDetailPanel;
            return run.getRunTerminalPanelIsHover().get();
        }
        return false;
    }

    public String getContent() {
        String command;
        Map<String, Object> params;
        String scopeContent;
        String filePath;
        Map<String, Object> fileParams;
        if (this.aiDevFilePanel != null && (fileParams = this.toolCallInfo.get().getParameters()) != null && fileParams.containsKey("file_path") && StringUtils.isNotBlank((String)(filePath = (String)fileParams.get("file_path")))) {
            String fileName = FileUtil.getFileName(filePath);
            StringBuilder sb = new StringBuilder();
            sb.append("\n[").append(fileName).append("](").append(filePath).append(")\n");
            return sb.toString();
        }
        if (this.titleLabel == null || StringUtils.isBlank((String)this.titleLabel.getText())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n**").append(this.titleLabel.getText()).append("**");
        if (this.scopeLabel != null && StringUtils.isNotBlank((String)(scopeContent = this.toolContextProvider.getScopeContent(this.project, this.toolCallInfo.get())))) {
            sb.append(" *").append(scopeContent).append("*");
        }
        if (this.resultCountLabel != null && StringUtils.isNotBlank((String)this.resultCountLabel.getText())) {
            sb.append(" ").append(this.resultCountLabel.getText());
        }
        if (ToolTypeEnum.RUN_IN_TERMINAL.getToolName().equals(this.toolCallInfo.get().getToolName()) && (params = this.toolCallInfo.get().getParameters()) != null && params.containsKey("command") && StringUtils.isNotBlank((String)(command = (String)params.get("command")))) {
            sb.append("\n```\n").append(command).append("\n```");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Generated
    public String getToolCallId() {
        return this.toolCallId;
    }

    @Generated
    public AtomicReference<Boolean> getTitlePanelIsHover() {
        return this.titlePanelIsHover;
    }

    @Generated
    public ToolTypeEnum getToolTypeEnum() {
        return this.toolTypeEnum;
    }

    @Generated
    public AtomicReference<ToolCallInfo> getToolCallInfo() {
        return this.toolCallInfo;
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public AIDevFilePanel getAiDevFilePanel() {
        return this.aiDevFilePanel;
    }

    @Generated
    public Box getResultAndOperateBox() {
        return this.resultAndOperateBox;
    }

    @Generated
    public Box getToolAutoRunChooser() {
        return this.toolAutoRunChooser;
    }

    @Generated
    public void setToolAutoRunChooser(Box toolAutoRunChooser) {
        this.toolAutoRunChooser = toolAutoRunChooser;
    }

    @Generated
    public JLabel getToolRunTipLabel() {
        return this.toolRunTipLabel;
    }

    @Generated
    public boolean isHasRiskOrInDenyList() {
        return this.hasRiskOrInDenyList;
    }

    @Generated
    public void setHasRiskOrInDenyList(boolean hasRiskOrInDenyList) {
        this.hasRiskOrInDenyList = hasRiskOrInDenyList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/ui/search/component/tool/ToolPanel", "constructFileItem"));
    }
}

