/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.approval;

import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.approval.ToolApprovalPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.enums.ToolCallStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TerminalToolApprovalPanel
extends BaseToolCallHandler
implements ToolApprovalPanel {
    private Project project;
    private JPanel contentPanel;
    private RoundRectLabel agreeLabel;
    private JLabel refuseLabel;
    private ToolCallInfo currentToolCallInfo;
    private final ToolPanel toolPanel;

    public TerminalToolApprovalPanel(Project project, ToolPanel toolPanel) {
        this.project = project;
        this.contentPanel = this.initContentPanel(toolPanel.getToolTypeEnum().isWeekUi());
        this.toolPanel = toolPanel;
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void initToolApprovalPanel(Project project, ToolCallInfo toolCallInfo) {
        this.contentPanel.removeAll();
        this.currentToolCallInfo = toolCallInfo;
        if (!ToolCallStatusEnum.PENDING.getStatus().equals(toolCallInfo.getToolCallStatus())) {
            return;
        }
        RoundRectPanel terminalPanel = new RoundRectPanel();
        terminalPanel.setLayout(new BorderLayout());
        terminalPanel.setBorder(JBUI.Borders.empty((int)8));
        terminalPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        if (toolCallInfo.getParameters() != null && toolCallInfo.getParameters().containsKey("command")) {
            JPanel commandPanel = new JPanel(new BorderLayout());
            commandPanel.setBorder((Border)JBUI.Borders.empty());
            commandPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            String command = (String)toolCallInfo.getParameters().get("command");
            JTextArea commandTextArea = new JTextArea(command);
            commandTextArea.setFont(commandTextArea.getFont().deriveFont(0, 13.0f));
            commandTextArea.setLineWrap(true);
            commandTextArea.setWrapStyleWord(true);
            commandTextArea.setEditable(false);
            commandTextArea.setBackground(ColorUtil.getEditorBackgroundColor());
            commandTextArea.setBorder((Border)JBUI.Borders.empty());
            commandTextArea.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeTerminalCommand(true)));
            commandTextArea.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeTerminalCommand(false)));
            commandPanel.add((Component)commandTextArea, "Center");
            terminalPanel.add((Component)commandPanel, "Center");
        }
        JPanel toolApprovalPanel = this.initToolApprovalLabels(project, toolCallInfo);
        terminalPanel.add((Component)toolApprovalPanel, "South");
        terminalPanel.setFocusable(true);
        terminalPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeTerminalCommand(true)));
        terminalPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeTerminalCommand(false)));
        this.contentPanel.add(terminalPanel);
        this.contentPanel.setVisible(true);
        this.contentPanel.setFocusable(true);
        this.contentPanel.addKeyListener(this.createCommandEnterKeyListener(() -> this.executeTerminalCommand(true)));
        this.contentPanel.addKeyListener(this.createCommandDeleteKeyListener(() -> this.executeTerminalCommand(false)));
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        SwingUtilities.invokeLater(terminalPanel::requestFocusInWindow);
    }

    private void executeTerminalCommand(boolean agree) {
        if (this.currentToolCallInfo != null) {
            this.operate(this.project, this.currentToolCallInfo.getSessionId(), this.currentToolCallInfo.getRequestId(), this.currentToolCallInfo.getToolCallId(), agree);
        }
    }

    private JPanel initToolApprovalLabels(final Project project, final ToolCallInfo toolCallInfo) {
        JPanel toolApprovalPanel = new JPanel();
        toolApprovalPanel.setLayout(new BoxLayout(toolApprovalPanel, 0));
        toolApprovalPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        toolApprovalPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        Box toolApprovalBox = Box.createHorizontalBox();
        this.agreeLabel = new RoundRectLabel(TerminalToolApprovalPanel.getAgreeText(), ColorUtil.getItemSelectionBackground(), 8, 3, 8, 0);
        this.agreeLabel.setBackgroundColor(ColorUtil.getDefaultButtonStartBackgroundColor());
        this.agreeLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.agreeLabel.setFont(this.agreeLabel.getFont().deriveFont(0, 13.0f));
        this.agreeLabel.setForeground(ColorUtil.getItemSelectionForeground());
        this.agreeLabel.setHorizontalAlignment(0);
        this.agreeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TerminalToolApprovalPanel.this.operate(project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), true);
                if (!TerminalToolApprovalPanel.this.toolPanel.isHasRiskOrInDenyList()) {
                    TerminalToolApprovalPanel.this.toolPanel.getToolAutoRunChooser().setVisible(false);
                }
            }
        });
        toolApprovalBox.add(this.agreeLabel);
        this.refuseLabel = new JLabel(TerminalToolApprovalPanel.getRefuseText());
        this.refuseLabel.setOpaque(true);
        this.refuseLabel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.refuseLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.refuseLabel.setFont(this.refuseLabel.getFont().deriveFont(0, 13.0f));
        this.refuseLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.refuseLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)3, (int)14));
        this.refuseLabel.setHorizontalAlignment(0);
        this.refuseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TerminalToolApprovalPanel.this.operate(project, toolCallInfo.getSessionId(), toolCallInfo.getRequestId(), toolCallInfo.getToolCallId(), false);
            }
        });
        toolApprovalBox.add(Box.createHorizontalStrut(10));
        toolApprovalBox.add(this.refuseLabel);
        toolApprovalPanel.add(toolApprovalBox);
        return toolApprovalPanel;
    }

    @Override
    public void updateUiTexts() {
        if (this.agreeLabel != null) {
            this.agreeLabel.setText(TerminalToolApprovalPanel.getAgreeText());
            this.agreeLabel.repaint();
        }
        if (this.refuseLabel != null) {
            this.refuseLabel.setText(TerminalToolApprovalPanel.getRefuseText());
            this.refuseLabel.repaint();
        }
    }

    @NotNull
    private static String getRefuseText() {
        String string = CosyBundle.message("tool.run.terminal.operation.cancel", new Object[0]) + " " + TerminalToolApprovalPanel.getCmdDeleteKey();
        if (string == null) {
            TerminalToolApprovalPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getAgreeText() {
        String string = CosyBundle.message("tool.run.terminal.operation.run", new Object[0]) + " " + TerminalToolApprovalPanel.getCmdReturnKey();
        if (string == null) {
            TerminalToolApprovalPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/alibabacloud/intellij/qoder/ui/search/component/tool/approval/TerminalToolApprovalPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefuseText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgreeText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

