/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallApproveRequest;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyKeymapUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public abstract class BaseToolCallHandler {
    private static final Logger log = Logger.getInstance(BaseToolCallHandler.class);
    protected static final int CORNER_RADIUS = 8;
    protected static final int MCP_PARAMS_MAX_HEIGHT = 120;
    protected static final int MCP_RESULT_MAX_HEIGHT = 200;
    protected final AtomicInteger hoveredIndex = new AtomicInteger(-1);

    protected JPanel initContentPanel(final boolean isWeekUi) {
        JPanel contentPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int height = this.getHeight();
                if (width <= 0 || height <= 0) {
                    return;
                }
                int halfHeight = height / 2;
                int quarterHeight = height / 4;
                Rectangle upperRect = new Rectangle(0, 1, width, height - quarterHeight);
                RoundRectangle2D.Float lowerRoundRect = new RoundRectangle2D.Float(0.0f, halfHeight, width, halfHeight, 8.0f, 8.0f);
                g2.setColor(isWeekUi ? ColorUtil.getChatCardBackgroundColor() : ColorUtil.getEditorBackgroundColor());
                g2.fill(upperRect);
                g2.fill(lowerRoundRect);
                this.paintChildren(g2);
                g2.dispose();
            }
        };
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)(isWeekUi ? 0 : 1), (int)0, (int)0, (int)0));
        contentPanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        return contentPanel;
    }

    protected void operate(Project project, String sessionId, String requestId, String toolCallId, boolean agree) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        ToolCallApproveRequest toolCallApproveRequest = new ToolCallApproveRequest();
        toolCallApproveRequest.setSessionId(sessionId);
        toolCallApproveRequest.setRequestId(requestId);
        toolCallApproveRequest.setToolCallId(toolCallId);
        toolCallApproveRequest.setApproval(agree);
        Cosy.INSTANCE.getLanguageService(project).toolCallApprove(toolCallApproveRequest, 3000L);
    }

    public static String getCmdReturnKey() {
        int modifiers = SystemInfo.isMac ? 256 : 128;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, modifiers);
        return CosyKeymapUtil.getKeyStrokeShortcutText(keyStroke);
    }

    public static String getCmdDeleteKey() {
        int modifiers = SystemInfo.isMac ? 256 : 128;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(8, modifiers);
        return CosyKeymapUtil.getKeyStrokeShortcutText(keyStroke);
    }

    protected KeyAdapter createCommandEnterKeyListener(final Runnable executeAction) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.isMetaDown() || e.isControlDown())) {
                    e.consume();
                    executeAction.run();
                }
            }
        };
    }

    protected KeyAdapter createCommandDeleteKeyListener(final Runnable executeAction) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && (e.isMetaDown() || e.isControlDown())) {
                    e.consume();
                    executeAction.run();
                }
            }
        };
    }

    protected String formatJson(Map<String, Object> jsonObject) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (String key : jsonObject.keySet()) {
            sb.append("    \"").append(key).append("\": \"").append(jsonObject.get(key)).append("\",\n");
        }
        if (sb.length() > 3) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("\n}");
        return sb.toString();
    }

    protected void addStyledText(JTextPane pane, String json) {
        StyledDocument doc = pane.getStyledDocument();
        Style defaultStyle = pane.addStyle("default", null);
        StyleConstants.setForeground(defaultStyle, new Color(169, 183, 198));
        Style keyStyle = pane.addStyle("key", null);
        StyleConstants.setForeground(keyStyle, new Color(103, 140, 177));
        Style valueStyle = pane.addStyle("value", null);
        StyleConstants.setForeground(valueStyle, new Color(106, 135, 89));
        Style bracketStyle = pane.addStyle("bracket", null);
        StyleConstants.setForeground(bracketStyle, new Color(169, 183, 198));
        try {
            String[] lines = json.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.trim().equals("{")) {
                    doc.insertString(doc.getLength(), line + "\n", bracketStyle);
                    continue;
                }
                if (line.contains(":")) {
                    int colonIndex = line.indexOf(":");
                    String key = line.substring(0, colonIndex + 1);
                    String value = line.substring(colonIndex + 1);
                    doc.insertString(doc.getLength(), key, keyStyle);
                    doc.insertString(doc.getLength(), value + "\n", valueStyle);
                    continue;
                }
                if (!line.trim().equals("}")) continue;
                if (i == lines.length - 1) {
                    doc.insertString(doc.getLength(), line, bracketStyle);
                    continue;
                }
                doc.insertString(doc.getLength(), line + "\n", bracketStyle);
            }
        }
        catch (Exception e) {
            log.warn("addStyledText error", (Throwable)e);
        }
    }

    protected RoundRectLabel initWebToolsAgreeLabel() {
        RoundRectLabel agreeLabel = new RoundRectLabel(CosyBundle.message("tool.mcp.execute.operation.execute", new Object[0]) + " " + BaseToolCallHandler.getCmdReturnKey(), ColorUtil.getItemSelectionBackground(), 8, 3, 8, 0);
        agreeLabel.setBackground(ColorUtil.getItemSelectionBackground());
        agreeLabel.setCursor(Cursor.getPredefinedCursor(12));
        agreeLabel.setFont(agreeLabel.getFont().deriveFont(0, 13.0f));
        agreeLabel.setForeground(ColorUtil.getItemSelectionForeground());
        agreeLabel.setHorizontalAlignment(0);
        return agreeLabel;
    }

    protected JLabel initWebToolsRejectLabel() {
        JLabel refuseLabel = new JLabel(CosyBundle.message("tool.mcp.execute.operation.cancel", new Object[0]) + " " + BaseToolCallHandler.getCmdDeleteKey());
        refuseLabel.setOpaque(true);
        refuseLabel.setBackground(ColorUtil.getEditorBackgroundColor());
        refuseLabel.setCursor(Cursor.getPredefinedCursor(12));
        refuseLabel.setFont(refuseLabel.getFont().deriveFont(0, 13.0f));
        refuseLabel.setForeground(ColorUtil.getTextForegroundColor());
        refuseLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)3, (int)14));
        refuseLabel.setHorizontalAlignment(0);
        return refuseLabel;
    }

    @NotNull
    protected MouseMotionAdapter getMouseMotionAdapter(final JBList<?> jbList) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean mouseInCell;
                int index = jbList.locationToIndex(e.getPoint());
                Rectangle cellBounds = jbList.getCellBounds(index, index);
                boolean bl = mouseInCell = cellBounds != null && cellBounds.contains(e.getPoint());
                if (mouseInCell) {
                    BaseToolCallHandler.this.hoveredIndex.set(index);
                } else {
                    BaseToolCallHandler.this.hoveredIndex.set(-1);
                }
                jbList.revalidate();
                jbList.repaint();
            }
        };
    }
}

