/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.model.LineRange;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.tool.model.ProblemPosition;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.ProblemItem;
import com.alibabacloud.intellij.qoder.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class GetProblemsToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(GetProblemsToolDetailPanel.class);
    private Project project;
    private ToolPanel parentPanel;
    private JPanel contentPanel;

    public GetProblemsToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List problemItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), ProblemItem.class);
            if (problemItems.isEmpty()) {
                return;
            }
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(problemItems);
            final JBList problemItemList = new JBList(listModel);
            problemItemList.setVisibleRowCount(8);
            problemItemList.setOpaque(false);
            problemItemList.setFixedCellHeight(28);
            problemItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            problemItemList.setBorder(BorderFactory.createEmptyBorder());
            problemItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions((JList)problemItemList);
            problemItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ProblemItem problemItem = (ProblemItem)problemItemList.getSelectedValue();
                    LineRange lineRange = null;
                    if (problemItem.getRange() != null) {
                        ProblemPosition startPosition = problemItem.getRange().getStart();
                        ProblemPosition endPosition = problemItem.getRange().getEnd();
                        if (startPosition != null && endPosition != null) {
                            lineRange = new LineRange(startPosition.getLine() - 1, endPosition.getLine() - 1);
                        }
                    }
                    EditorUtil.openEditorFile(GetProblemsToolDetailPanel.this.project, problemItem.getPath(), lineRange, (JComponent)problemItemList);
                    problemItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GetProblemsToolDetailPanel.this.hoveredIndex.set(-1);
                    problemItemList.revalidate();
                    problemItemList.repaint();
                }
            });
            problemItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(problemItemList));
            JBScrollPane problemScrollPane = new JBScrollPane();
            problemScrollPane.setBorder(BorderFactory.createEmptyBorder());
            problemScrollPane.setViewportView((Component)problemItemList);
            problemScrollPane.setOpaque(false);
            problemScrollPane.setVerticalScrollBarPolicy(20);
            problemScrollPane.setHorizontalScrollBarPolicy(31);
            RoundRectPanel problemPanel = new RoundRectPanel();
            problemPanel.setLayout(new BorderLayout());
            problemPanel.add((Component)problemScrollPane, "Center");
            this.contentPanel.add(problemPanel);
            SwingUtil.foreachChildComponent(problemPanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

