/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.model.LineRange;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.CodeItem;
import com.alibabacloud.intellij.qoder.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class GrepCodeToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(GrepCodeToolDetailPanel.class);
    private Project project;
    private ToolPanel parentPanel;
    private JPanel contentPanel;
    private JBList<CodeItem> codeItemList;
    private RoundRectPanel codePanel;
    private JScrollPane codeScrollPane;

    public GrepCodeToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List codeItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), CodeItem.class);
            if (codeItems.isEmpty()) {
                return;
            }
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(codeItems);
            this.codeItemList = new JBList(listModel);
            this.codeItemList.setVisibleRowCount(8);
            this.codeItemList.setOpaque(false);
            this.codeItemList.setFixedCellHeight(28);
            this.codeItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            this.codeItemList.setBorder(BorderFactory.createEmptyBorder());
            this.codeItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions(this.codeItemList);
            this.codeItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CodeItem codeItem = (CodeItem)GrepCodeToolDetailPanel.this.codeItemList.getSelectedValue();
                    LineRange lineRange = null;
                    if (codeItem.getStartLine() != null && codeItem.getEndLine() != null) {
                        lineRange = new LineRange(codeItem.getStartLine() - 1, codeItem.getEndLine() - 1);
                    }
                    EditorUtil.openEditorFile(GrepCodeToolDetailPanel.this.project, codeItem.getPath(), lineRange, GrepCodeToolDetailPanel.this.codeItemList);
                    GrepCodeToolDetailPanel.this.codeItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GrepCodeToolDetailPanel.this.hoveredIndex.set(-1);
                    GrepCodeToolDetailPanel.this.codeItemList.revalidate();
                    GrepCodeToolDetailPanel.this.codeItemList.repaint();
                }
            });
            this.codeItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(this.codeItemList));
            this.codeScrollPane = new JBScrollPane();
            this.codeScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.codeScrollPane.setViewportView((Component)this.codeItemList);
            this.codeScrollPane.setOpaque(false);
            this.codeScrollPane.setVerticalScrollBarPolicy(20);
            this.codeScrollPane.setHorizontalScrollBarPolicy(31);
            this.codePanel = new RoundRectPanel();
            this.codePanel.setLayout(new BorderLayout());
            this.codePanel.add((Component)this.codeScrollPane, "Center");
            this.contentPanel.add(this.codePanel);
            SwingUtil.foreachChildComponent(this.codePanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

