/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.DirItem;
import com.alibabacloud.intellij.qoder.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class ListDirToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(ListDirToolDetailPanel.class);
    private Project project;
    private ToolPanel parentPanel;
    private JPanel contentPanel;
    private JBList<DirItem> dirItemList;
    private RoundRectPanel dirPanel;
    private JScrollPane dirScrollPane;

    public ListDirToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List dirItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), DirItem.class);
            if (dirItems.isEmpty()) {
                return;
            }
            final DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(dirItems);
            this.dirItemList = new JBList(listModel);
            this.dirItemList.setVisibleRowCount(8);
            this.dirItemList.setOpaque(false);
            this.dirItemList.setFixedCellHeight(28);
            this.dirItemList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            this.dirItemList.setBorder(BorderFactory.createEmptyBorder());
            this.dirItemList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions(this.dirItemList);
            this.dirItemList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = ListDirToolDetailPanel.this.dirItemList.locationToIndex(e.getPoint());
                    if (index >= 0) {
                        DirItem dirItem = (DirItem)listModel.getElementAt(index);
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(dirItem.getPath());
                        if (file != null) {
                            if (file.isDirectory()) {
                                ToolWindow projectToolWindow = ToolWindowManager.getInstance((Project)ListDirToolDetailPanel.this.project).getToolWindow("Project");
                                if (projectToolWindow != null && !projectToolWindow.isVisible()) {
                                    projectToolWindow.show(null);
                                }
                                ProjectView.getInstance((Project)ListDirToolDetailPanel.this.project).select((Object)file, file, true);
                            } else {
                                FileEditorManager.getInstance((Project)ListDirToolDetailPanel.this.project).openFile(file, true);
                            }
                        }
                    }
                    ListDirToolDetailPanel.this.dirItemList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ListDirToolDetailPanel.this.hoveredIndex.set(-1);
                    ListDirToolDetailPanel.this.dirItemList.revalidate();
                    ListDirToolDetailPanel.this.dirItemList.repaint();
                }
            });
            this.dirItemList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(this.dirItemList));
            this.dirScrollPane = new JBScrollPane();
            this.dirScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.dirScrollPane.setViewportView((Component)this.dirItemList);
            this.dirScrollPane.setOpaque(false);
            this.dirScrollPane.setVerticalScrollBarPolicy(20);
            this.dirScrollPane.setHorizontalScrollBarPolicy(31);
            this.dirPanel = new RoundRectPanel();
            this.dirPanel.setLayout(new BorderLayout());
            this.dirPanel.add((Component)this.dirScrollPane, "Center");
            this.contentPanel.add(this.dirPanel);
            SwingUtil.foreachChildComponent(this.dirPanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
        if (this.dirItemList != null) {
            this.dirItemList.repaint();
        }
    }
}

