/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public class MCPToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(MCPToolDetailPanel.class);
    private static final String MCP_RESULT_TYPE = "text";
    private static final String MCP_KEY_TYPE = "type";
    private static final String MCP_KEY_TEXT = "text";
    private Project project;
    private ToolPanel parentPanel;
    private JPanel contentPanel;
    private JLabel parametersLabel;
    private JLabel resultLabel;

    public MCPToolDetailPanel(Project project, ToolPanel parentPanel) {
        this.project = project;
        this.parentPanel = parentPanel;
        this.contentPanel = this.initContentPanel(parentPanel.getToolTypeEnum().isWeekUi());
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        JBScrollPane scrollPane;
        RoundRectPanel jPanel;
        this.contentPanel.removeAll();
        if (toolCallInfo.getResults() == null && toolCallInfo.getParameters() == null) {
            return;
        }
        RoundRectPanel mcpPanel = new RoundRectPanel();
        mcpPanel.setLayout(new BorderLayout());
        mcpPanel.setBorder(JBUI.Borders.empty((int)8));
        mcpPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        if (toolCallInfo.getParameters() != null) {
            JPanel parametersPanel = new JPanel(new BorderLayout());
            parametersPanel.setBorder((Border)JBUI.Borders.empty());
            parametersPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.parametersLabel = new JLabel(CosyBundle.message("tool.mcp.execute.params", new Object[0]));
            this.parametersLabel.setOpaque(true);
            this.parametersLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.parametersLabel.setFont(this.parametersLabel.getFont().deriveFont(0, 12.0f));
            this.parametersLabel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.parametersLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
            parametersPanel.add((Component)this.parametersLabel, "North");
            jPanel = new RoundRectPanel(new BorderLayout());
            jPanel.setBorder(JBUI.Borders.empty((int)8));
            jPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
            JTextPane jsonPane = new JTextPane();
            jsonPane.setEditable(false);
            jsonPane.setBackground(ColorUtil.getToolWindowBackgroundColor());
            String formattedJson = this.formatJson(toolCallInfo.getParameters());
            this.addStyledText(jsonPane, StringUtils.trim((String)formattedJson));
            scrollPane = new JBScrollPane(jsonPane){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (size.height > 120) {
                        size.height = 120;
                    }
                    return size;
                }
            };
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setBackground(ColorUtil.getToolWindowBackgroundColor());
            scrollPane.getViewport().setBackground(ColorUtil.getToolWindowBackgroundColor());
            jPanel.add((Component)scrollPane, "Center");
            parametersPanel.add((Component)jPanel, "Center");
            mcpPanel.add((Component)parametersPanel, "North");
        }
        if (toolCallInfo.getResults() != null) {
            JPanel resultPanel = new JPanel(new BorderLayout());
            resultPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
            resultPanel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.resultLabel = new JLabel(CosyBundle.message("tool.mcp.execute.results", new Object[0]));
            this.resultLabel.setOpaque(true);
            this.resultLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.resultLabel.setFont(this.resultLabel.getFont().deriveFont(0, 12.0f));
            this.resultLabel.setBackground(ColorUtil.getEditorBackgroundColor());
            this.resultLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
            resultPanel.add((Component)this.resultLabel, "North");
            jPanel = new RoundRectPanel(new BorderLayout());
            jPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
            jPanel.setBorder(JBUI.Borders.empty((int)8));
            JPanel resultContentPanel = new JPanel(new BorderLayout());
            resultContentPanel.setOpaque(false);
            final JTextArea resultTextArea = new JTextArea();
            resultTextArea.setEditable(false);
            resultTextArea.setBackground(ColorUtil.getToolWindowBackgroundColor());
            resultTextArea.setText(this.getResultText(toolCallInfo.getResults()));
            resultTextArea.setLineWrap(true);
            resultTextArea.setWrapStyleWord(true);
            scrollPane = new JBScrollPane(resultTextArea){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (size.height > 200) {
                        size.height = 200;
                    }
                    return size;
                }
            };
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setBackground(ColorUtil.getToolWindowBackgroundColor());
            scrollPane.getViewport().setBackground(ColorUtil.getToolWindowBackgroundColor());
            scrollPane.setHorizontalScrollBarPolicy(31);
            JPanel copyButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
            copyButtonPanel.setOpaque(false);
            final JLabel copyLabel = new JLabel(CommonIcons.copyGreyIcon);
            copyLabel.setCursor(Cursor.getPredefinedCursor(12));
            copyLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StringSelection selection = new StringSelection(resultTextArea.getText());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    NotificationFactory.showToast((JComponent)copyLabel, QoderIcons.AcceptIcon, CosyBundle.message("chat.answer.copied", new Object[0]));
                }
            });
            copyButtonPanel.add(copyLabel);
            resultContentPanel.add((Component)scrollPane, "Center");
            resultContentPanel.add((Component)copyButtonPanel, "North");
            jPanel.add((Component)resultContentPanel, "Center");
            resultPanel.add((Component)jPanel, "Center");
            mcpPanel.add((Component)resultPanel, "South");
        }
        this.contentPanel.add(mcpPanel);
    }

    private String getResultText(List<Map<String, Object>> results) {
        try {
            if (results == null) {
                return null;
            }
            if (results.isEmpty()) {
                return results.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (Map<String, Object> result : results) {
                Object object;
                if (!result.containsKey(MCP_KEY_TYPE) || !result.get(MCP_KEY_TYPE).equals("text") || (object = result.get("text")) == null) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(result.get("text").toString());
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return results.toString();
        }
        catch (Exception e) {
            return results.toString();
        }
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    @Override
    public void updateUiTexts() {
        if (this.parametersLabel != null) {
            this.parametersLabel.setText(CosyBundle.message("tool.mcp.execute.params", new Object[0]));
            this.parametersLabel.repaint();
        }
        if (this.resultLabel != null) {
            this.resultLabel.setText(CosyBundle.message("tool.mcp.execute.results", new Object[0]));
            this.resultLabel.repaint();
        }
    }
}

