/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.component.tool.result;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallInfo;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.ToolPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.ToolDetailPanel;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.WebItem;
import com.alibabacloud.intellij.qoder.ui.search.renderer.ToolResultListCellRender;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class SearchWebToolDetailPanel
extends BaseToolCallHandler
implements ToolDetailPanel {
    private static final Logger log = Logger.getInstance(SearchWebToolDetailPanel.class);
    private Project project;
    private ToolPanel toolPanel;
    private JPanel contentPanel;
    private JBList<WebItem> webList;
    private RoundRectPanel webPanel;
    private JScrollPane webScrollPane;

    public SearchWebToolDetailPanel(Project project, ToolPanel toolPanel) {
        this.project = project;
        this.toolPanel = toolPanel;
        this.contentPanel = this.initContentPanel(true);
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    @Override
    public void refreshToolDetailPanel(ToolCallInfo toolCallInfo) {
        if (toolCallInfo.getResults() != null) {
            this.contentPanel.removeAll();
            List webItems = JSONObject.parseArray((String)JSONObject.toJSONString(toolCallInfo.getResults()), WebItem.class);
            if (webItems.isEmpty()) {
                return;
            }
            DefaultListModel listModel = new DefaultListModel();
            listModel.addAll(webItems);
            this.webList = new JBList(listModel);
            this.webList.setVisibleRowCount(8);
            this.webList.setOpaque(false);
            this.webList.setFixedCellHeight(28);
            this.webList.setCellRenderer((ListCellRenderer)new ToolResultListCellRender(this.project, this.getComponent(), this.hoveredIndex));
            this.webList.setBorder(BorderFactory.createEmptyBorder());
            this.webList.setCursor(Cursor.getPredefinedCursor(12));
            ScrollingUtil.installActions(this.webList);
            this.webList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WebItem webItem = (WebItem)SearchWebToolDetailPanel.this.webList.getSelectedValue();
                    if (StringUtils.isNotBlank((CharSequence)webItem.getLink())) {
                        try {
                            BrowserUtil.browse((String)webItem.getLink().trim());
                        }
                        catch (Exception ex) {
                            log.warn("browse url error", (Throwable)ex);
                        }
                    }
                    SearchWebToolDetailPanel.this.webList.getSelectionModel().clearSelection();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SearchWebToolDetailPanel.this.hoveredIndex.set(-1);
                    SearchWebToolDetailPanel.this.webList.revalidate();
                    SearchWebToolDetailPanel.this.webList.repaint();
                }
            });
            this.webList.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapter(this.webList));
            this.webScrollPane = new JBScrollPane();
            this.webScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.webScrollPane.setViewportView((Component)this.webList);
            this.webScrollPane.setOpaque(false);
            this.webScrollPane.setVerticalScrollBarPolicy(20);
            this.webScrollPane.setHorizontalScrollBarPolicy(31);
            this.webPanel = new RoundRectPanel();
            this.webPanel.setLayout(new BorderLayout());
            this.webPanel.add((Component)this.webScrollPane, "Center");
            this.contentPanel.add(this.webPanel);
            SwingUtil.foreachChildComponent(this.webPanel, cp -> cp.setBackground(ColorUtil.getChatCardChildBackgroundColor()));
        }
    }

    @Override
    public void updateUiTexts() {
    }
}

