/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.search.form;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.CodeDocContentDetail;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.search.CosyJBTableCell;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.MarkdownPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.ShadowPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.VoteAcceptPanel;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;

public class AnswerCell
implements CosyJBTableCell {
    private JPanel basePane;
    private VoteAcceptPanel votePane;
    private JPanel htmlPane;
    private JPanel bottomPane;
    private JLabel foldLabel;
    private JLabel expandLabel;
    private JPanel expandPanel;
    private Project project;
    private MessageBusConnection messageBusConnection;
    private static final int MAX_HEIGHT = 480;
    private static final int MAX_TEXT_HEIGHT = 1200;

    public AnswerCell(Project project, CodeDocContentDetail codeDocContentDetail) {
        this.project = project;
        this.$$$setupUI$$$();
        this.foldLabel.setVisible(false);
        this.foldLabel.setIcon(CommonIcons.arrowUpIcon);
        this.foldLabel.setHorizontalTextPosition(2);
        this.foldLabel.setForeground((Color)CosyColor.EXPAND_COLOR);
        this.expandLabel.setForeground((Color)CosyColor.EXPAND_COLOR);
        this.bottomPane.setBorder(JBUI.Borders.customLine((Color)CosyColor.BEST_ANSWER_BORDER_COLOR, (int)1, (int)0, (int)0, (int)0));
        this.votePane.setVoteCount(codeDocContentDetail.getLikeCount());
        this.votePane.setAnswerCount(codeDocContentDetail.getCommentCount());
        this.votePane.setHasAccepted(codeDocContentDetail.getIsAccepted());
        this.votePane.setAuthorName(codeDocContentDetail.getAuthors());
        this.votePane.setLayoutStyle(1);
        this.votePane.initUI();
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.expandLabel.setCursor(new Cursor(12));
        this.expandLabel.setHorizontalTextPosition(2);
        this.expandLabel.setIcon(CommonIcons.arrowDownIcon);
        this.foldLabel.setCursor(new Cursor(12));
        this.initBackground();
        String content = codeDocContentDetail.getContent();
        final MarkdownPanel markdownPanel = new MarkdownPanel(project, this.basePane, content);
        markdownPanel.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        for (Component childComponent : markdownPanel.getComponents()) {
            if (!(childComponent instanceof HtmlPanel)) continue;
            childComponent.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        }
        this.expandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AnswerCell.this.expandPanel.isVisible()) {
                    AnswerCell.this.htmlPane.removeAll();
                    AnswerCell.this.htmlPane.add((Component)markdownPanel, "Center");
                    AnswerCell.this.expandPanel.setVisible(false);
                    AnswerCell.this.foldLabel.setVisible(true);
                    AnswerCell.this.htmlPane.repaint();
                    AnswerCell.this.htmlPane.revalidate();
                }
            }
        });
        int remainingHeight = 480 - this.bottomPane.getPreferredSize().height;
        int textLength = this.getTextLength(markdownPanel);
        if (markdownPanel.getPreferredSize().height <= remainingHeight && textLength < 1200) {
            this.expandPanel.setVisible(false);
            this.htmlPane.add((Component)markdownPanel, "Center");
        } else {
            MouseWheelListener[] mouseWheelListeners;
            int height = this.bottomPane.getPreferredSize().height + this.expandPanel.getPreferredSize().height;
            ShadowPanel shadowPanel = new ShadowPanel(project, 480 - height);
            shadowPanel.setLayout(new BorderLayout());
            JBScrollPane jScrollPane = new JBScrollPane((Component)markdownPanel);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getVerticalScrollBar().setEnabled(false);
            jScrollPane.getVerticalScrollBar().setVisible(false);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            shadowPanel.add((Component)jScrollPane, "Center");
            for (MouseWheelListener mouseWheelListener : mouseWheelListeners = (MouseWheelListener[])jScrollPane.getListeners(MouseWheelListener.class)) {
                jScrollPane.removeMouseWheelListener(mouseWheelListener);
            }
            this.htmlPane.add((Component)shadowPanel, "Center");
            this.htmlPane.updateUI();
            this.foldLabel.addMouseListener(new MouseAdapter((JScrollPane)jScrollPane, markdownPanel, shadowPanel){
                final /* synthetic */ JScrollPane val$jScrollPane;
                final /* synthetic */ MarkdownPanel val$markdownPanel;
                final /* synthetic */ ShadowPanel val$shadowPanel;
                {
                    this.val$jScrollPane = jScrollPane;
                    this.val$markdownPanel = markdownPanel;
                    this.val$shadowPanel = shadowPanel;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    AnswerCell.this.htmlPane.removeAll();
                    AnswerCell.this.foldLabel.setVisible(false);
                    this.val$jScrollPane.setViewportView(this.val$markdownPanel);
                    this.val$shadowPanel.add((Component)this.val$jScrollPane, "Center");
                    AnswerCell.this.expandPanel.setVisible(true);
                    AnswerCell.this.htmlPane.add((Component)this.val$shadowPanel, "Center");
                    AnswerCell.this.htmlPane.repaint();
                    AnswerCell.this.htmlPane.revalidate();
                }
            });
        }
    }

    private int getTextLength(MarkdownPanel markdownPanel) {
        int count = 0;
        for (Component component : markdownPanel.getComponents()) {
            if (component instanceof HtmlPanel) {
                HtmlPanel sonPanel = (HtmlPanel)component;
                count += sonPanel.getDocument().getLength();
                continue;
            }
            if (!(component instanceof EditorTextField)) continue;
            EditorTextField sonEditor = (EditorTextField)component;
            count += sonEditor.getDocument().getTextLength();
        }
        return count;
    }

    private void updateUiTexts() {
        this.votePane.updateUiTexts();
    }

    public void initBackground() {
        this.htmlPane.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.basePane.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.expandPanel.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.bottomPane.setBackground((Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return this.basePane.getPreferredSize().height;
    }

    @Override
    public Component getComponent() {
        return this.basePane;
    }

    @Generated
    public void setBasePane(JPanel basePane) {
        this.basePane = basePane;
    }

    @Generated
    public void setVotePane(VoteAcceptPanel votePane) {
        this.votePane = votePane;
    }

    @Generated
    public void setHtmlPane(JPanel htmlPane) {
        this.htmlPane = htmlPane;
    }

    @Generated
    public void setBottomPane(JPanel bottomPane) {
        this.bottomPane = bottomPane;
    }

    @Generated
    public void setFoldLabel(JLabel foldLabel) {
        this.foldLabel = foldLabel;
    }

    @Generated
    public void setExpandLabel(JLabel expandLabel) {
        this.expandLabel = expandLabel;
    }

    @Generated
    public void setExpandPanel(JPanel expandPanel) {
        this.expandPanel = expandPanel;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    @Generated
    public JPanel getBasePane() {
        return this.basePane;
    }

    @Generated
    public VoteAcceptPanel getVotePane() {
        return this.votePane;
    }

    @Generated
    public JPanel getHtmlPane() {
        return this.htmlPane;
    }

    @Generated
    public JPanel getBottomPane() {
        return this.bottomPane;
    }

    @Generated
    public JLabel getFoldLabel() {
        return this.foldLabel;
    }

    @Generated
    public JLabel getExpandLabel() {
        return this.expandLabel;
    }

    @Generated
    public JPanel getExpandPanel() {
        return this.expandPanel;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        VoteAcceptPanel voteAcceptPanel;
        JPanel jPanel3;
        JPanel jPanel4;
        this.basePane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 10, 0, 10), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.bottomPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(8, 0, 8, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.votePane = voteAcceptPanel = new VoteAcceptPanel();
        jPanel3.add((Component)voteAcceptPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.foldLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messageBundle").getString("fold.label.txt"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.htmlPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.expandPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 12, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.expandLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-12618800));
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messageBundle").getString("expand.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

